/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CommodityMarketDisruptionSequence;
import fpml.confirmation.DisruptionFallbacksEnum;
import fpml.confirmation.MarketDisruptionEvent;
import fpml.confirmation.SequencedDisruptionFallback;
import fpml.confirmation.Underlyer;
import fpml.confirmation.meta.CommodityMarketDisruptionMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommodityMarketDisruption", builder=CommodityMarketDisruptionBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CommodityMarketDisruption", model="fpml", builder=CommodityMarketDisruptionBuilderImpl.class, version="0.17.2")
public interface CommodityMarketDisruption
extends RosettaModelObject {
    public static final CommodityMarketDisruptionMeta metaData = new CommodityMarketDisruptionMeta();

    public CommodityMarketDisruptionSequence getCommodityMarketDisruptionSequence();

    public List<? extends MarketDisruptionEvent> getMarketDisruptionEvent();

    public DisruptionFallbacksEnum getDisruptionFallbacks();

    public List<? extends SequencedDisruptionFallback> getDisruptionFallback();

    public Underlyer getFallbackReferencePrice();

    public Integer getMaximumNumberOfDaysOfDisruption();

    public BigDecimal getPriceMaterialityPercentage();

    public Integer getMinimumFuturesContracts();

    public CommodityMarketDisruption build();

    public CommodityMarketDisruptionBuilder toBuilder();

    public static CommodityMarketDisruptionBuilder builder() {
        return new CommodityMarketDisruptionBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityMarketDisruption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityMarketDisruption> getType() {
        return CommodityMarketDisruption.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("commodityMarketDisruptionSequence"), processor, CommodityMarketDisruptionSequence.class, this.getCommodityMarketDisruptionSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("marketDisruptionEvent"), processor, MarketDisruptionEvent.class, this.getMarketDisruptionEvent(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("disruptionFallbacks"), DisruptionFallbacksEnum.class, (Object)this.getDisruptionFallbacks(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("disruptionFallback"), processor, SequencedDisruptionFallback.class, this.getDisruptionFallback(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fallbackReferencePrice"), processor, Underlyer.class, this.getFallbackReferencePrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maximumNumberOfDaysOfDisruption"), Integer.class, (Object)this.getMaximumNumberOfDaysOfDisruption(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceMaterialityPercentage"), BigDecimal.class, (Object)this.getPriceMaterialityPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("minimumFuturesContracts"), Integer.class, (Object)this.getMinimumFuturesContracts(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommodityMarketDisruptionBuilderImpl
    implements CommodityMarketDisruptionBuilder {
        protected CommodityMarketDisruptionSequence.CommodityMarketDisruptionSequenceBuilder commodityMarketDisruptionSequence;
        protected List<MarketDisruptionEvent.MarketDisruptionEventBuilder> marketDisruptionEvent = new ArrayList<MarketDisruptionEvent.MarketDisruptionEventBuilder>();
        protected DisruptionFallbacksEnum disruptionFallbacks;
        protected List<SequencedDisruptionFallback.SequencedDisruptionFallbackBuilder> disruptionFallback = new ArrayList<SequencedDisruptionFallback.SequencedDisruptionFallbackBuilder>();
        protected Underlyer.UnderlyerBuilder fallbackReferencePrice;
        protected Integer maximumNumberOfDaysOfDisruption;
        protected BigDecimal priceMaterialityPercentage;
        protected Integer minimumFuturesContracts;

        @Override
        @RosettaAttribute(value="commodityMarketDisruptionSequence")
        @RuneAttribute(value="commodityMarketDisruptionSequence")
        public CommodityMarketDisruptionSequence.CommodityMarketDisruptionSequenceBuilder getCommodityMarketDisruptionSequence() {
            return this.commodityMarketDisruptionSequence;
        }

        @Override
        public CommodityMarketDisruptionSequence.CommodityMarketDisruptionSequenceBuilder getOrCreateCommodityMarketDisruptionSequence() {
            CommodityMarketDisruptionSequence.CommodityMarketDisruptionSequenceBuilder result = this.commodityMarketDisruptionSequence != null ? this.commodityMarketDisruptionSequence : (this.commodityMarketDisruptionSequence = CommodityMarketDisruptionSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="marketDisruptionEvent")
        @RuneAttribute(value="marketDisruptionEvent")
        public List<? extends MarketDisruptionEvent.MarketDisruptionEventBuilder> getMarketDisruptionEvent() {
            return this.marketDisruptionEvent;
        }

        @Override
        public MarketDisruptionEvent.MarketDisruptionEventBuilder getOrCreateMarketDisruptionEvent(int index) {
            if (this.marketDisruptionEvent == null) {
                this.marketDisruptionEvent = new ArrayList<MarketDisruptionEvent.MarketDisruptionEventBuilder>();
            }
            return (MarketDisruptionEvent.MarketDisruptionEventBuilder)this.getIndex(this.marketDisruptionEvent, index, () -> {
                MarketDisruptionEvent.MarketDisruptionEventBuilder newMarketDisruptionEvent = MarketDisruptionEvent.builder();
                return newMarketDisruptionEvent;
            });
        }

        @Override
        @RosettaAttribute(value="disruptionFallbacks")
        @RuneAttribute(value="disruptionFallbacks")
        public DisruptionFallbacksEnum getDisruptionFallbacks() {
            return this.disruptionFallbacks;
        }

        @Override
        @RosettaAttribute(value="disruptionFallback")
        @RuneAttribute(value="disruptionFallback")
        public List<? extends SequencedDisruptionFallback.SequencedDisruptionFallbackBuilder> getDisruptionFallback() {
            return this.disruptionFallback;
        }

        @Override
        public SequencedDisruptionFallback.SequencedDisruptionFallbackBuilder getOrCreateDisruptionFallback(int index) {
            if (this.disruptionFallback == null) {
                this.disruptionFallback = new ArrayList<SequencedDisruptionFallback.SequencedDisruptionFallbackBuilder>();
            }
            return (SequencedDisruptionFallback.SequencedDisruptionFallbackBuilder)this.getIndex(this.disruptionFallback, index, () -> {
                SequencedDisruptionFallback.SequencedDisruptionFallbackBuilder newDisruptionFallback = SequencedDisruptionFallback.builder();
                return newDisruptionFallback;
            });
        }

        @Override
        @RosettaAttribute(value="fallbackReferencePrice")
        @RuneAttribute(value="fallbackReferencePrice")
        public Underlyer.UnderlyerBuilder getFallbackReferencePrice() {
            return this.fallbackReferencePrice;
        }

        @Override
        public Underlyer.UnderlyerBuilder getOrCreateFallbackReferencePrice() {
            Underlyer.UnderlyerBuilder result = this.fallbackReferencePrice != null ? this.fallbackReferencePrice : (this.fallbackReferencePrice = Underlyer.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="maximumNumberOfDaysOfDisruption")
        @RuneAttribute(value="maximumNumberOfDaysOfDisruption")
        public Integer getMaximumNumberOfDaysOfDisruption() {
            return this.maximumNumberOfDaysOfDisruption;
        }

        @Override
        @RosettaAttribute(value="priceMaterialityPercentage")
        @RuneAttribute(value="priceMaterialityPercentage")
        public BigDecimal getPriceMaterialityPercentage() {
            return this.priceMaterialityPercentage;
        }

        @Override
        @RosettaAttribute(value="minimumFuturesContracts")
        @RuneAttribute(value="minimumFuturesContracts")
        public Integer getMinimumFuturesContracts() {
            return this.minimumFuturesContracts;
        }

        @Override
        @RosettaAttribute(value="commodityMarketDisruptionSequence")
        @RuneAttribute(value="commodityMarketDisruptionSequence")
        public CommodityMarketDisruptionBuilder setCommodityMarketDisruptionSequence(CommodityMarketDisruptionSequence _commodityMarketDisruptionSequence) {
            this.commodityMarketDisruptionSequence = _commodityMarketDisruptionSequence == null ? null : _commodityMarketDisruptionSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="marketDisruptionEvent")
        @RuneAttribute(value="marketDisruptionEvent")
        public CommodityMarketDisruptionBuilder addMarketDisruptionEvent(MarketDisruptionEvent _marketDisruptionEvent) {
            if (_marketDisruptionEvent != null) {
                this.marketDisruptionEvent.add(_marketDisruptionEvent.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityMarketDisruptionBuilder addMarketDisruptionEvent(MarketDisruptionEvent _marketDisruptionEvent, int idx) {
            this.getIndex(this.marketDisruptionEvent, idx, () -> _marketDisruptionEvent.toBuilder());
            return this;
        }

        @Override
        public CommodityMarketDisruptionBuilder addMarketDisruptionEvent(List<? extends MarketDisruptionEvent> marketDisruptionEvents) {
            if (marketDisruptionEvents != null) {
                for (MarketDisruptionEvent marketDisruptionEvent : marketDisruptionEvents) {
                    this.marketDisruptionEvent.add(marketDisruptionEvent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="marketDisruptionEvent")
        public CommodityMarketDisruptionBuilder setMarketDisruptionEvent(List<? extends MarketDisruptionEvent> marketDisruptionEvents) {
            this.marketDisruptionEvent = marketDisruptionEvents == null ? new ArrayList<MarketDisruptionEvent.MarketDisruptionEventBuilder>() : (List)marketDisruptionEvents.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="disruptionFallbacks")
        @RuneAttribute(value="disruptionFallbacks")
        public CommodityMarketDisruptionBuilder setDisruptionFallbacks(DisruptionFallbacksEnum _disruptionFallbacks) {
            this.disruptionFallbacks = _disruptionFallbacks == null ? null : _disruptionFallbacks;
            return this;
        }

        @Override
        @RosettaAttribute(value="disruptionFallback")
        @RuneAttribute(value="disruptionFallback")
        public CommodityMarketDisruptionBuilder addDisruptionFallback(SequencedDisruptionFallback _disruptionFallback) {
            if (_disruptionFallback != null) {
                this.disruptionFallback.add(_disruptionFallback.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityMarketDisruptionBuilder addDisruptionFallback(SequencedDisruptionFallback _disruptionFallback, int idx) {
            this.getIndex(this.disruptionFallback, idx, () -> _disruptionFallback.toBuilder());
            return this;
        }

        @Override
        public CommodityMarketDisruptionBuilder addDisruptionFallback(List<? extends SequencedDisruptionFallback> _disruptionFallbacks) {
            if (_disruptionFallbacks != null) {
                for (SequencedDisruptionFallback sequencedDisruptionFallback : _disruptionFallbacks) {
                    this.disruptionFallback.add(sequencedDisruptionFallback.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="disruptionFallback")
        public CommodityMarketDisruptionBuilder setDisruptionFallback(List<? extends SequencedDisruptionFallback> _disruptionFallbacks) {
            this.disruptionFallback = _disruptionFallbacks == null ? new ArrayList<SequencedDisruptionFallback.SequencedDisruptionFallbackBuilder>() : (List)_disruptionFallbacks.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fallbackReferencePrice")
        @RuneAttribute(value="fallbackReferencePrice")
        public CommodityMarketDisruptionBuilder setFallbackReferencePrice(Underlyer _fallbackReferencePrice) {
            this.fallbackReferencePrice = _fallbackReferencePrice == null ? null : _fallbackReferencePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="maximumNumberOfDaysOfDisruption")
        @RuneAttribute(value="maximumNumberOfDaysOfDisruption")
        public CommodityMarketDisruptionBuilder setMaximumNumberOfDaysOfDisruption(Integer _maximumNumberOfDaysOfDisruption) {
            this.maximumNumberOfDaysOfDisruption = _maximumNumberOfDaysOfDisruption == null ? null : _maximumNumberOfDaysOfDisruption;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceMaterialityPercentage")
        @RuneAttribute(value="priceMaterialityPercentage")
        public CommodityMarketDisruptionBuilder setPriceMaterialityPercentage(BigDecimal _priceMaterialityPercentage) {
            this.priceMaterialityPercentage = _priceMaterialityPercentage == null ? null : _priceMaterialityPercentage;
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumFuturesContracts")
        @RuneAttribute(value="minimumFuturesContracts")
        public CommodityMarketDisruptionBuilder setMinimumFuturesContracts(Integer _minimumFuturesContracts) {
            this.minimumFuturesContracts = _minimumFuturesContracts == null ? null : _minimumFuturesContracts;
            return this;
        }

        @Override
        public CommodityMarketDisruption build() {
            return new CommodityMarketDisruptionImpl(this);
        }

        @Override
        public CommodityMarketDisruptionBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityMarketDisruptionBuilder prune() {
            if (this.commodityMarketDisruptionSequence != null && !this.commodityMarketDisruptionSequence.prune().hasData()) {
                this.commodityMarketDisruptionSequence = null;
            }
            this.marketDisruptionEvent = this.marketDisruptionEvent.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.disruptionFallback = this.disruptionFallback.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.fallbackReferencePrice != null && !this.fallbackReferencePrice.prune().hasData()) {
                this.fallbackReferencePrice = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCommodityMarketDisruptionSequence() != null && this.getCommodityMarketDisruptionSequence().hasData()) {
                return true;
            }
            if (this.getMarketDisruptionEvent() != null && this.getMarketDisruptionEvent().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDisruptionFallbacks() != null) {
                return true;
            }
            if (this.getDisruptionFallback() != null && this.getDisruptionFallback().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFallbackReferencePrice() != null && this.getFallbackReferencePrice().hasData()) {
                return true;
            }
            if (this.getMaximumNumberOfDaysOfDisruption() != null) {
                return true;
            }
            if (this.getPriceMaterialityPercentage() != null) {
                return true;
            }
            return this.getMinimumFuturesContracts() != null;
        }

        public CommodityMarketDisruptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityMarketDisruptionBuilder o = (CommodityMarketDisruptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityMarketDisruptionSequence(), (RosettaModelObjectBuilder)o.getCommodityMarketDisruptionSequence(), this::setCommodityMarketDisruptionSequence);
            merger.mergeRosetta(this.getMarketDisruptionEvent(), o.getMarketDisruptionEvent(), this::getOrCreateMarketDisruptionEvent);
            merger.mergeRosetta(this.getDisruptionFallback(), o.getDisruptionFallback(), this::getOrCreateDisruptionFallback);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFallbackReferencePrice(), (RosettaModelObjectBuilder)o.getFallbackReferencePrice(), this::setFallbackReferencePrice);
            merger.mergeBasic((Object)this.getDisruptionFallbacks(), (Object)o.getDisruptionFallbacks(), this::setDisruptionFallbacks, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaximumNumberOfDaysOfDisruption(), (Object)o.getMaximumNumberOfDaysOfDisruption(), this::setMaximumNumberOfDaysOfDisruption, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceMaterialityPercentage(), (Object)o.getPriceMaterialityPercentage(), this::setPriceMaterialityPercentage, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMinimumFuturesContracts(), (Object)o.getMinimumFuturesContracts(), this::setMinimumFuturesContracts, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityMarketDisruption _that = this.getType().cast(o);
            if (!Objects.equals(this.commodityMarketDisruptionSequence, _that.getCommodityMarketDisruptionSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.marketDisruptionEvent, _that.getMarketDisruptionEvent())) {
                return false;
            }
            if (!Objects.equals((Object)this.disruptionFallbacks, (Object)_that.getDisruptionFallbacks())) {
                return false;
            }
            if (!ListEquals.listEquals(this.disruptionFallback, _that.getDisruptionFallback())) {
                return false;
            }
            if (!Objects.equals(this.fallbackReferencePrice, _that.getFallbackReferencePrice())) {
                return false;
            }
            if (!Objects.equals(this.maximumNumberOfDaysOfDisruption, _that.getMaximumNumberOfDaysOfDisruption())) {
                return false;
            }
            if (!Objects.equals(this.priceMaterialityPercentage, _that.getPriceMaterialityPercentage())) {
                return false;
            }
            return Objects.equals(this.minimumFuturesContracts, _that.getMinimumFuturesContracts());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commodityMarketDisruptionSequence != null ? this.commodityMarketDisruptionSequence.hashCode() : 0);
            _result = 31 * _result + (this.marketDisruptionEvent != null ? this.marketDisruptionEvent.hashCode() : 0);
            _result = 31 * _result + (this.disruptionFallbacks != null ? ((Object)((Object)this.disruptionFallbacks)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.disruptionFallback != null ? this.disruptionFallback.hashCode() : 0);
            _result = 31 * _result + (this.fallbackReferencePrice != null ? this.fallbackReferencePrice.hashCode() : 0);
            _result = 31 * _result + (this.maximumNumberOfDaysOfDisruption != null ? this.maximumNumberOfDaysOfDisruption.hashCode() : 0);
            _result = 31 * _result + (this.priceMaterialityPercentage != null ? this.priceMaterialityPercentage.hashCode() : 0);
            _result = 31 * _result + (this.minimumFuturesContracts != null ? this.minimumFuturesContracts.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityMarketDisruptionBuilder {commodityMarketDisruptionSequence=" + this.commodityMarketDisruptionSequence + ", marketDisruptionEvent=" + this.marketDisruptionEvent + ", disruptionFallbacks=" + (Object)((Object)this.disruptionFallbacks) + ", disruptionFallback=" + this.disruptionFallback + ", fallbackReferencePrice=" + this.fallbackReferencePrice + ", maximumNumberOfDaysOfDisruption=" + this.maximumNumberOfDaysOfDisruption + ", priceMaterialityPercentage=" + this.priceMaterialityPercentage + ", minimumFuturesContracts=" + this.minimumFuturesContracts + '}';
        }
    }

    public static interface CommodityMarketDisruptionBuilder
    extends CommodityMarketDisruption,
    RosettaModelObjectBuilder {
        public CommodityMarketDisruptionSequence.CommodityMarketDisruptionSequenceBuilder getOrCreateCommodityMarketDisruptionSequence();

        @Override
        public CommodityMarketDisruptionSequence.CommodityMarketDisruptionSequenceBuilder getCommodityMarketDisruptionSequence();

        public MarketDisruptionEvent.MarketDisruptionEventBuilder getOrCreateMarketDisruptionEvent(int var1);

        public List<? extends MarketDisruptionEvent.MarketDisruptionEventBuilder> getMarketDisruptionEvent();

        public SequencedDisruptionFallback.SequencedDisruptionFallbackBuilder getOrCreateDisruptionFallback(int var1);

        public List<? extends SequencedDisruptionFallback.SequencedDisruptionFallbackBuilder> getDisruptionFallback();

        public Underlyer.UnderlyerBuilder getOrCreateFallbackReferencePrice();

        @Override
        public Underlyer.UnderlyerBuilder getFallbackReferencePrice();

        public CommodityMarketDisruptionBuilder setCommodityMarketDisruptionSequence(CommodityMarketDisruptionSequence var1);

        public CommodityMarketDisruptionBuilder addMarketDisruptionEvent(MarketDisruptionEvent var1);

        public CommodityMarketDisruptionBuilder addMarketDisruptionEvent(MarketDisruptionEvent var1, int var2);

        public CommodityMarketDisruptionBuilder addMarketDisruptionEvent(List<? extends MarketDisruptionEvent> var1);

        public CommodityMarketDisruptionBuilder setMarketDisruptionEvent(List<? extends MarketDisruptionEvent> var1);

        public CommodityMarketDisruptionBuilder setDisruptionFallbacks(DisruptionFallbacksEnum var1);

        public CommodityMarketDisruptionBuilder addDisruptionFallback(SequencedDisruptionFallback var1);

        public CommodityMarketDisruptionBuilder addDisruptionFallback(SequencedDisruptionFallback var1, int var2);

        public CommodityMarketDisruptionBuilder addDisruptionFallback(List<? extends SequencedDisruptionFallback> var1);

        public CommodityMarketDisruptionBuilder setDisruptionFallback(List<? extends SequencedDisruptionFallback> var1);

        public CommodityMarketDisruptionBuilder setFallbackReferencePrice(Underlyer var1);

        public CommodityMarketDisruptionBuilder setMaximumNumberOfDaysOfDisruption(Integer var1);

        public CommodityMarketDisruptionBuilder setPriceMaterialityPercentage(BigDecimal var1);

        public CommodityMarketDisruptionBuilder setMinimumFuturesContracts(Integer var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("commodityMarketDisruptionSequence"), processor, CommodityMarketDisruptionSequence.CommodityMarketDisruptionSequenceBuilder.class, this.getCommodityMarketDisruptionSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("marketDisruptionEvent"), processor, MarketDisruptionEvent.MarketDisruptionEventBuilder.class, this.getMarketDisruptionEvent(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("disruptionFallbacks"), DisruptionFallbacksEnum.class, (Object)this.getDisruptionFallbacks(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("disruptionFallback"), processor, SequencedDisruptionFallback.SequencedDisruptionFallbackBuilder.class, this.getDisruptionFallback(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fallbackReferencePrice"), processor, Underlyer.UnderlyerBuilder.class, this.getFallbackReferencePrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maximumNumberOfDaysOfDisruption"), Integer.class, (Object)this.getMaximumNumberOfDaysOfDisruption(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceMaterialityPercentage"), BigDecimal.class, (Object)this.getPriceMaterialityPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("minimumFuturesContracts"), Integer.class, (Object)this.getMinimumFuturesContracts(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CommodityMarketDisruptionBuilder prune();
    }

    public static class CommodityMarketDisruptionImpl
    implements CommodityMarketDisruption {
        private final CommodityMarketDisruptionSequence commodityMarketDisruptionSequence;
        private final List<? extends MarketDisruptionEvent> marketDisruptionEvent;
        private final DisruptionFallbacksEnum disruptionFallbacks;
        private final List<? extends SequencedDisruptionFallback> disruptionFallback;
        private final Underlyer fallbackReferencePrice;
        private final Integer maximumNumberOfDaysOfDisruption;
        private final BigDecimal priceMaterialityPercentage;
        private final Integer minimumFuturesContracts;

        protected CommodityMarketDisruptionImpl(CommodityMarketDisruptionBuilder builder) {
            this.commodityMarketDisruptionSequence = Optional.ofNullable(builder.getCommodityMarketDisruptionSequence()).map(f -> f.build()).orElse(null);
            this.marketDisruptionEvent = Optional.ofNullable(builder.getMarketDisruptionEvent()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.disruptionFallbacks = builder.getDisruptionFallbacks();
            this.disruptionFallback = Optional.ofNullable(builder.getDisruptionFallback()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fallbackReferencePrice = Optional.ofNullable(builder.getFallbackReferencePrice()).map(f -> f.build()).orElse(null);
            this.maximumNumberOfDaysOfDisruption = builder.getMaximumNumberOfDaysOfDisruption();
            this.priceMaterialityPercentage = builder.getPriceMaterialityPercentage();
            this.minimumFuturesContracts = builder.getMinimumFuturesContracts();
        }

        @Override
        @RosettaAttribute(value="commodityMarketDisruptionSequence")
        @RuneAttribute(value="commodityMarketDisruptionSequence")
        public CommodityMarketDisruptionSequence getCommodityMarketDisruptionSequence() {
            return this.commodityMarketDisruptionSequence;
        }

        @Override
        @RosettaAttribute(value="marketDisruptionEvent")
        @RuneAttribute(value="marketDisruptionEvent")
        public List<? extends MarketDisruptionEvent> getMarketDisruptionEvent() {
            return this.marketDisruptionEvent;
        }

        @Override
        @RosettaAttribute(value="disruptionFallbacks")
        @RuneAttribute(value="disruptionFallbacks")
        public DisruptionFallbacksEnum getDisruptionFallbacks() {
            return this.disruptionFallbacks;
        }

        @Override
        @RosettaAttribute(value="disruptionFallback")
        @RuneAttribute(value="disruptionFallback")
        public List<? extends SequencedDisruptionFallback> getDisruptionFallback() {
            return this.disruptionFallback;
        }

        @Override
        @RosettaAttribute(value="fallbackReferencePrice")
        @RuneAttribute(value="fallbackReferencePrice")
        public Underlyer getFallbackReferencePrice() {
            return this.fallbackReferencePrice;
        }

        @Override
        @RosettaAttribute(value="maximumNumberOfDaysOfDisruption")
        @RuneAttribute(value="maximumNumberOfDaysOfDisruption")
        public Integer getMaximumNumberOfDaysOfDisruption() {
            return this.maximumNumberOfDaysOfDisruption;
        }

        @Override
        @RosettaAttribute(value="priceMaterialityPercentage")
        @RuneAttribute(value="priceMaterialityPercentage")
        public BigDecimal getPriceMaterialityPercentage() {
            return this.priceMaterialityPercentage;
        }

        @Override
        @RosettaAttribute(value="minimumFuturesContracts")
        @RuneAttribute(value="minimumFuturesContracts")
        public Integer getMinimumFuturesContracts() {
            return this.minimumFuturesContracts;
        }

        @Override
        public CommodityMarketDisruption build() {
            return this;
        }

        @Override
        public CommodityMarketDisruptionBuilder toBuilder() {
            CommodityMarketDisruptionBuilder builder = CommodityMarketDisruption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityMarketDisruptionBuilder builder) {
            Optional.ofNullable(this.getCommodityMarketDisruptionSequence()).ifPresent(builder::setCommodityMarketDisruptionSequence);
            Optional.ofNullable(this.getMarketDisruptionEvent()).ifPresent(builder::setMarketDisruptionEvent);
            Optional.ofNullable(this.getDisruptionFallbacks()).ifPresent(builder::setDisruptionFallbacks);
            Optional.ofNullable(this.getDisruptionFallback()).ifPresent(builder::setDisruptionFallback);
            Optional.ofNullable(this.getFallbackReferencePrice()).ifPresent(builder::setFallbackReferencePrice);
            Optional.ofNullable(this.getMaximumNumberOfDaysOfDisruption()).ifPresent(builder::setMaximumNumberOfDaysOfDisruption);
            Optional.ofNullable(this.getPriceMaterialityPercentage()).ifPresent(builder::setPriceMaterialityPercentage);
            Optional.ofNullable(this.getMinimumFuturesContracts()).ifPresent(builder::setMinimumFuturesContracts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityMarketDisruption _that = this.getType().cast(o);
            if (!Objects.equals(this.commodityMarketDisruptionSequence, _that.getCommodityMarketDisruptionSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.marketDisruptionEvent, _that.getMarketDisruptionEvent())) {
                return false;
            }
            if (!Objects.equals((Object)this.disruptionFallbacks, (Object)_that.getDisruptionFallbacks())) {
                return false;
            }
            if (!ListEquals.listEquals(this.disruptionFallback, _that.getDisruptionFallback())) {
                return false;
            }
            if (!Objects.equals(this.fallbackReferencePrice, _that.getFallbackReferencePrice())) {
                return false;
            }
            if (!Objects.equals(this.maximumNumberOfDaysOfDisruption, _that.getMaximumNumberOfDaysOfDisruption())) {
                return false;
            }
            if (!Objects.equals(this.priceMaterialityPercentage, _that.getPriceMaterialityPercentage())) {
                return false;
            }
            return Objects.equals(this.minimumFuturesContracts, _that.getMinimumFuturesContracts());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commodityMarketDisruptionSequence != null ? this.commodityMarketDisruptionSequence.hashCode() : 0);
            _result = 31 * _result + (this.marketDisruptionEvent != null ? this.marketDisruptionEvent.hashCode() : 0);
            _result = 31 * _result + (this.disruptionFallbacks != null ? ((Object)((Object)this.disruptionFallbacks)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.disruptionFallback != null ? this.disruptionFallback.hashCode() : 0);
            _result = 31 * _result + (this.fallbackReferencePrice != null ? this.fallbackReferencePrice.hashCode() : 0);
            _result = 31 * _result + (this.maximumNumberOfDaysOfDisruption != null ? this.maximumNumberOfDaysOfDisruption.hashCode() : 0);
            _result = 31 * _result + (this.priceMaterialityPercentage != null ? this.priceMaterialityPercentage.hashCode() : 0);
            _result = 31 * _result + (this.minimumFuturesContracts != null ? this.minimumFuturesContracts.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityMarketDisruption {commodityMarketDisruptionSequence=" + this.commodityMarketDisruptionSequence + ", marketDisruptionEvent=" + this.marketDisruptionEvent + ", disruptionFallbacks=" + (Object)((Object)this.disruptionFallbacks) + ", disruptionFallback=" + this.disruptionFallback + ", fallbackReferencePrice=" + this.fallbackReferencePrice + ", maximumNumberOfDaysOfDisruption=" + this.maximumNumberOfDaysOfDisruption + ", priceMaterialityPercentage=" + this.priceMaterialityPercentage + ", minimumFuturesContracts=" + this.minimumFuturesContracts + '}';
        }
    }
}

