/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AdjustableOrRelativeDate;
import fpml.confirmation.Frequency;
import fpml.confirmation.meta.CommodityEuropeanExerciseSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommodityEuropeanExerciseSequence", builder=CommodityEuropeanExerciseSequenceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CommodityEuropeanExerciseSequence", model="fpml", builder=CommodityEuropeanExerciseSequenceBuilderImpl.class, version="0.17.2")
public interface CommodityEuropeanExerciseSequence
extends RosettaModelObject {
    public static final CommodityEuropeanExerciseSequenceMeta metaData = new CommodityEuropeanExerciseSequenceMeta();

    public List<? extends AdjustableOrRelativeDate> getExpirationDate();

    public Frequency getExerciseFrequency();

    public CommodityEuropeanExerciseSequence build();

    public CommodityEuropeanExerciseSequenceBuilder toBuilder();

    public static CommodityEuropeanExerciseSequenceBuilder builder() {
        return new CommodityEuropeanExerciseSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityEuropeanExerciseSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityEuropeanExerciseSequence> getType() {
        return CommodityEuropeanExerciseSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseFrequency"), processor, Frequency.class, this.getExerciseFrequency(), new AttributeMeta[0]);
    }

    public static class CommodityEuropeanExerciseSequenceBuilderImpl
    implements CommodityEuropeanExerciseSequenceBuilder {
        protected List<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> expirationDate = new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>();
        protected Frequency.FrequencyBuilder exerciseFrequency;

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public List<? extends AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate(int index) {
            if (this.expirationDate == null) {
                this.expirationDate = new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>();
            }
            return (AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder)this.getIndex(this.expirationDate, index, () -> {
                AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder newExpirationDate = AdjustableOrRelativeDate.builder();
                return newExpirationDate;
            });
        }

        @Override
        @RosettaAttribute(value="exerciseFrequency")
        @RuneAttribute(value="exerciseFrequency")
        public Frequency.FrequencyBuilder getExerciseFrequency() {
            return this.exerciseFrequency;
        }

        @Override
        public Frequency.FrequencyBuilder getOrCreateExerciseFrequency() {
            Frequency.FrequencyBuilder result = this.exerciseFrequency != null ? this.exerciseFrequency : (this.exerciseFrequency = Frequency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public CommodityEuropeanExerciseSequenceBuilder addExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            if (_expirationDate != null) {
                this.expirationDate.add(_expirationDate.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityEuropeanExerciseSequenceBuilder addExpirationDate(AdjustableOrRelativeDate _expirationDate, int idx) {
            this.getIndex(this.expirationDate, idx, () -> _expirationDate.toBuilder());
            return this;
        }

        @Override
        public CommodityEuropeanExerciseSequenceBuilder addExpirationDate(List<? extends AdjustableOrRelativeDate> expirationDates) {
            if (expirationDates != null) {
                for (AdjustableOrRelativeDate adjustableOrRelativeDate : expirationDates) {
                    this.expirationDate.add(adjustableOrRelativeDate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="expirationDate")
        public CommodityEuropeanExerciseSequenceBuilder setExpirationDate(List<? extends AdjustableOrRelativeDate> expirationDates) {
            this.expirationDate = expirationDates == null ? new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>() : (List)expirationDates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseFrequency")
        @RuneAttribute(value="exerciseFrequency")
        public CommodityEuropeanExerciseSequenceBuilder setExerciseFrequency(Frequency _exerciseFrequency) {
            this.exerciseFrequency = _exerciseFrequency == null ? null : _exerciseFrequency.toBuilder();
            return this;
        }

        @Override
        public CommodityEuropeanExerciseSequence build() {
            return new CommodityEuropeanExerciseSequenceImpl(this);
        }

        @Override
        public CommodityEuropeanExerciseSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityEuropeanExerciseSequenceBuilder prune() {
            this.expirationDate = this.expirationDate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.exerciseFrequency != null && !this.exerciseFrequency.prune().hasData()) {
                this.exerciseFrequency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getExpirationDate() != null && this.getExpirationDate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getExerciseFrequency() != null && this.getExerciseFrequency().hasData();
        }

        public CommodityEuropeanExerciseSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityEuropeanExerciseSequenceBuilder o = (CommodityEuropeanExerciseSequenceBuilder)other;
            merger.mergeRosetta(this.getExpirationDate(), o.getExpirationDate(), this::getOrCreateExpirationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseFrequency(), (RosettaModelObjectBuilder)o.getExerciseFrequency(), this::setExerciseFrequency);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityEuropeanExerciseSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            return Objects.equals(this.exerciseFrequency, _that.getExerciseFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFrequency != null ? this.exerciseFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityEuropeanExerciseSequenceBuilder {expirationDate=" + this.expirationDate + ", exerciseFrequency=" + this.exerciseFrequency + '}';
        }
    }

    public static interface CommodityEuropeanExerciseSequenceBuilder
    extends CommodityEuropeanExerciseSequence,
    RosettaModelObjectBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate(int var1);

        public List<? extends AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> getExpirationDate();

        public Frequency.FrequencyBuilder getOrCreateExerciseFrequency();

        @Override
        public Frequency.FrequencyBuilder getExerciseFrequency();

        public CommodityEuropeanExerciseSequenceBuilder addExpirationDate(AdjustableOrRelativeDate var1);

        public CommodityEuropeanExerciseSequenceBuilder addExpirationDate(AdjustableOrRelativeDate var1, int var2);

        public CommodityEuropeanExerciseSequenceBuilder addExpirationDate(List<? extends AdjustableOrRelativeDate> var1);

        public CommodityEuropeanExerciseSequenceBuilder setExpirationDate(List<? extends AdjustableOrRelativeDate> var1);

        public CommodityEuropeanExerciseSequenceBuilder setExerciseFrequency(Frequency var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseFrequency"), processor, Frequency.FrequencyBuilder.class, this.getExerciseFrequency(), new AttributeMeta[0]);
        }

        public CommodityEuropeanExerciseSequenceBuilder prune();
    }

    public static class CommodityEuropeanExerciseSequenceImpl
    implements CommodityEuropeanExerciseSequence {
        private final List<? extends AdjustableOrRelativeDate> expirationDate;
        private final Frequency exerciseFrequency;

        protected CommodityEuropeanExerciseSequenceImpl(CommodityEuropeanExerciseSequenceBuilder builder) {
            this.expirationDate = Optional.ofNullable(builder.getExpirationDate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.exerciseFrequency = Optional.ofNullable(builder.getExerciseFrequency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public List<? extends AdjustableOrRelativeDate> getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="exerciseFrequency")
        @RuneAttribute(value="exerciseFrequency")
        public Frequency getExerciseFrequency() {
            return this.exerciseFrequency;
        }

        @Override
        public CommodityEuropeanExerciseSequence build() {
            return this;
        }

        @Override
        public CommodityEuropeanExerciseSequenceBuilder toBuilder() {
            CommodityEuropeanExerciseSequenceBuilder builder = CommodityEuropeanExerciseSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityEuropeanExerciseSequenceBuilder builder) {
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getExerciseFrequency()).ifPresent(builder::setExerciseFrequency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityEuropeanExerciseSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            return Objects.equals(this.exerciseFrequency, _that.getExerciseFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFrequency != null ? this.exerciseFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityEuropeanExerciseSequence {expirationDate=" + this.expirationDate + ", exerciseFrequency=" + this.exerciseFrequency + '}';
        }
    }
}

