/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AdjustableOrRelativeDate;
import fpml.confirmation.BullionDeliveryLocation;
import fpml.confirmation.BullionTypeEnum;
import fpml.confirmation.CommodityClassification;
import fpml.confirmation.CommodityFixedPhysicalQuantityModel;
import fpml.confirmation.PayerReceiverModel;
import fpml.confirmation.PhysicalForwardLeg;
import fpml.confirmation.meta.BullionPhysicalLegMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="BullionPhysicalLeg", builder=BullionPhysicalLegBuilderImpl.class, version="0.17.2")
@RuneDataType(value="BullionPhysicalLeg", model="fpml", builder=BullionPhysicalLegBuilderImpl.class, version="0.17.2")
public interface BullionPhysicalLeg
extends PhysicalForwardLeg {
    public static final BullionPhysicalLegMeta metaData = new BullionPhysicalLegMeta();

    public BullionTypeEnum getBullionType();

    public BullionDeliveryLocation getDeliveryLocation();

    public CommodityFixedPhysicalQuantityModel getCommodityFixedPhysicalQuantityModel();

    public AdjustableOrRelativeDate getSettlementDate();

    @Override
    public BullionPhysicalLeg build();

    @Override
    public BullionPhysicalLegBuilder toBuilder();

    public static BullionPhysicalLegBuilder builder() {
        return new BullionPhysicalLegBuilderImpl();
    }

    default public RosettaMetaData<? extends BullionPhysicalLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BullionPhysicalLeg> getType() {
        return BullionPhysicalLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.class, this.getCommodityClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bullionType"), BullionTypeEnum.class, (Object)this.getBullionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryLocation"), processor, BullionDeliveryLocation.class, this.getDeliveryLocation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityFixedPhysicalQuantityModel"), processor, CommodityFixedPhysicalQuantityModel.class, this.getCommodityFixedPhysicalQuantityModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrRelativeDate.class, this.getSettlementDate(), new AttributeMeta[0]);
    }

    public static class BullionPhysicalLegBuilderImpl
    extends PhysicalForwardLeg.PhysicalForwardLegBuilderImpl
    implements BullionPhysicalLegBuilder {
        protected BullionTypeEnum bullionType;
        protected BullionDeliveryLocation.BullionDeliveryLocationBuilder deliveryLocation;
        protected CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder commodityFixedPhysicalQuantityModel;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder settlementDate;

        @Override
        @RosettaAttribute(value="bullionType", isRequired=true)
        @RuneAttribute(value="bullionType", isRequired=true)
        public BullionTypeEnum getBullionType() {
            return this.bullionType;
        }

        @Override
        @RosettaAttribute(value="deliveryLocation", isRequired=true)
        @RuneAttribute(value="deliveryLocation", isRequired=true)
        public BullionDeliveryLocation.BullionDeliveryLocationBuilder getDeliveryLocation() {
            return this.deliveryLocation;
        }

        @Override
        public BullionDeliveryLocation.BullionDeliveryLocationBuilder getOrCreateDeliveryLocation() {
            BullionDeliveryLocation.BullionDeliveryLocationBuilder result = this.deliveryLocation != null ? this.deliveryLocation : (this.deliveryLocation = BullionDeliveryLocation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        @RuneAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        public CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder getCommodityFixedPhysicalQuantityModel() {
            return this.commodityFixedPhysicalQuantityModel;
        }

        @Override
        public CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder getOrCreateCommodityFixedPhysicalQuantityModel() {
            CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder result = this.commodityFixedPhysicalQuantityModel != null ? this.commodityFixedPhysicalQuantityModel : (this.commodityFixedPhysicalQuantityModel = CommodityFixedPhysicalQuantityModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateSettlementDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.settlementDate != null ? this.settlementDate : (this.settlementDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public BullionPhysicalLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityClassification")
        @RuneAttribute(value="commodityClassification")
        public BullionPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification) {
            if (_commodityClassification != null) {
                this.commodityClassification.add(_commodityClassification.toBuilder());
            }
            return this;
        }

        @Override
        public BullionPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification, int idx) {
            this.getIndex(this.commodityClassification, idx, () -> _commodityClassification.toBuilder());
            return this;
        }

        @Override
        public BullionPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            if (commodityClassifications != null) {
                for (CommodityClassification commodityClassification : commodityClassifications) {
                    this.commodityClassification.add(commodityClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityClassification")
        public BullionPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            this.commodityClassification = commodityClassifications == null ? new ArrayList() : (List)commodityClassifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public BullionPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="bullionType", isRequired=true)
        @RuneAttribute(value="bullionType", isRequired=true)
        public BullionPhysicalLegBuilder setBullionType(BullionTypeEnum _bullionType) {
            this.bullionType = _bullionType == null ? null : _bullionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryLocation", isRequired=true)
        @RuneAttribute(value="deliveryLocation", isRequired=true)
        public BullionPhysicalLegBuilder setDeliveryLocation(BullionDeliveryLocation _deliveryLocation) {
            this.deliveryLocation = _deliveryLocation == null ? null : _deliveryLocation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        @RuneAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        public BullionPhysicalLegBuilder setCommodityFixedPhysicalQuantityModel(CommodityFixedPhysicalQuantityModel _commodityFixedPhysicalQuantityModel) {
            this.commodityFixedPhysicalQuantityModel = _commodityFixedPhysicalQuantityModel == null ? null : _commodityFixedPhysicalQuantityModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public BullionPhysicalLegBuilder setSettlementDate(AdjustableOrRelativeDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        public BullionPhysicalLeg build() {
            return new BullionPhysicalLegImpl(this);
        }

        @Override
        public BullionPhysicalLegBuilder toBuilder() {
            return this;
        }

        @Override
        public BullionPhysicalLegBuilder prune() {
            super.prune();
            if (this.deliveryLocation != null && !this.deliveryLocation.prune().hasData()) {
                this.deliveryLocation = null;
            }
            if (this.commodityFixedPhysicalQuantityModel != null && !this.commodityFixedPhysicalQuantityModel.prune().hasData()) {
                this.commodityFixedPhysicalQuantityModel = null;
            }
            if (this.settlementDate != null && !this.settlementDate.prune().hasData()) {
                this.settlementDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBullionType() != null) {
                return true;
            }
            if (this.getDeliveryLocation() != null && this.getDeliveryLocation().hasData()) {
                return true;
            }
            if (this.getCommodityFixedPhysicalQuantityModel() != null && this.getCommodityFixedPhysicalQuantityModel().hasData()) {
                return true;
            }
            return this.getSettlementDate() != null && this.getSettlementDate().hasData();
        }

        @Override
        public BullionPhysicalLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BullionPhysicalLegBuilder o = (BullionPhysicalLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryLocation(), (RosettaModelObjectBuilder)o.getDeliveryLocation(), this::setDeliveryLocation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityFixedPhysicalQuantityModel(), (RosettaModelObjectBuilder)o.getCommodityFixedPhysicalQuantityModel(), this::setCommodityFixedPhysicalQuantityModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementDate(), (RosettaModelObjectBuilder)o.getSettlementDate(), this::setSettlementDate);
            merger.mergeBasic((Object)this.getBullionType(), (Object)o.getBullionType(), this::setBullionType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BullionPhysicalLeg _that = (BullionPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals((Object)this.bullionType, (Object)_that.getBullionType())) {
                return false;
            }
            if (!Objects.equals(this.deliveryLocation, _that.getDeliveryLocation())) {
                return false;
            }
            if (!Objects.equals(this.commodityFixedPhysicalQuantityModel, _that.getCommodityFixedPhysicalQuantityModel())) {
                return false;
            }
            return Objects.equals(this.settlementDate, _that.getSettlementDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.bullionType != null ? ((Object)((Object)this.bullionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryLocation != null ? this.deliveryLocation.hashCode() : 0);
            _result = 31 * _result + (this.commodityFixedPhysicalQuantityModel != null ? this.commodityFixedPhysicalQuantityModel.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BullionPhysicalLegBuilder {bullionType=" + (Object)((Object)this.bullionType) + ", deliveryLocation=" + this.deliveryLocation + ", commodityFixedPhysicalQuantityModel=" + this.commodityFixedPhysicalQuantityModel + ", settlementDate=" + this.settlementDate + '}' + " " + super.toString();
        }
    }

    public static interface BullionPhysicalLegBuilder
    extends BullionPhysicalLeg,
    PhysicalForwardLeg.PhysicalForwardLegBuilder {
        public BullionDeliveryLocation.BullionDeliveryLocationBuilder getOrCreateDeliveryLocation();

        @Override
        public BullionDeliveryLocation.BullionDeliveryLocationBuilder getDeliveryLocation();

        public CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder getOrCreateCommodityFixedPhysicalQuantityModel();

        @Override
        public CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder getCommodityFixedPhysicalQuantityModel();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateSettlementDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getSettlementDate();

        @Override
        public BullionPhysicalLegBuilder setId(String var1);

        @Override
        public BullionPhysicalLegBuilder addCommodityClassification(CommodityClassification var1);

        @Override
        public BullionPhysicalLegBuilder addCommodityClassification(CommodityClassification var1, int var2);

        @Override
        public BullionPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public BullionPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public BullionPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public BullionPhysicalLegBuilder setBullionType(BullionTypeEnum var1);

        public BullionPhysicalLegBuilder setDeliveryLocation(BullionDeliveryLocation var1);

        public BullionPhysicalLegBuilder setCommodityFixedPhysicalQuantityModel(CommodityFixedPhysicalQuantityModel var1);

        public BullionPhysicalLegBuilder setSettlementDate(AdjustableOrRelativeDate var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.CommodityClassificationBuilder.class, this.getCommodityClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bullionType"), BullionTypeEnum.class, (Object)this.getBullionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryLocation"), processor, BullionDeliveryLocation.BullionDeliveryLocationBuilder.class, this.getDeliveryLocation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityFixedPhysicalQuantityModel"), processor, CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder.class, this.getCommodityFixedPhysicalQuantityModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getSettlementDate(), new AttributeMeta[0]);
        }

        @Override
        public BullionPhysicalLegBuilder prune();
    }

    public static class BullionPhysicalLegImpl
    extends PhysicalForwardLeg.PhysicalForwardLegImpl
    implements BullionPhysicalLeg {
        private final BullionTypeEnum bullionType;
        private final BullionDeliveryLocation deliveryLocation;
        private final CommodityFixedPhysicalQuantityModel commodityFixedPhysicalQuantityModel;
        private final AdjustableOrRelativeDate settlementDate;

        protected BullionPhysicalLegImpl(BullionPhysicalLegBuilder builder) {
            super(builder);
            this.bullionType = builder.getBullionType();
            this.deliveryLocation = Optional.ofNullable(builder.getDeliveryLocation()).map(f -> f.build()).orElse(null);
            this.commodityFixedPhysicalQuantityModel = Optional.ofNullable(builder.getCommodityFixedPhysicalQuantityModel()).map(f -> f.build()).orElse(null);
            this.settlementDate = Optional.ofNullable(builder.getSettlementDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="bullionType", isRequired=true)
        @RuneAttribute(value="bullionType", isRequired=true)
        public BullionTypeEnum getBullionType() {
            return this.bullionType;
        }

        @Override
        @RosettaAttribute(value="deliveryLocation", isRequired=true)
        @RuneAttribute(value="deliveryLocation", isRequired=true)
        public BullionDeliveryLocation getDeliveryLocation() {
            return this.deliveryLocation;
        }

        @Override
        @RosettaAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        @RuneAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        public CommodityFixedPhysicalQuantityModel getCommodityFixedPhysicalQuantityModel() {
            return this.commodityFixedPhysicalQuantityModel;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public AdjustableOrRelativeDate getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public BullionPhysicalLeg build() {
            return this;
        }

        @Override
        public BullionPhysicalLegBuilder toBuilder() {
            BullionPhysicalLegBuilder builder = BullionPhysicalLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BullionPhysicalLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBullionType()).ifPresent(builder::setBullionType);
            Optional.ofNullable(this.getDeliveryLocation()).ifPresent(builder::setDeliveryLocation);
            Optional.ofNullable(this.getCommodityFixedPhysicalQuantityModel()).ifPresent(builder::setCommodityFixedPhysicalQuantityModel);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BullionPhysicalLeg _that = (BullionPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals((Object)this.bullionType, (Object)_that.getBullionType())) {
                return false;
            }
            if (!Objects.equals(this.deliveryLocation, _that.getDeliveryLocation())) {
                return false;
            }
            if (!Objects.equals(this.commodityFixedPhysicalQuantityModel, _that.getCommodityFixedPhysicalQuantityModel())) {
                return false;
            }
            return Objects.equals(this.settlementDate, _that.getSettlementDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.bullionType != null ? ((Object)((Object)this.bullionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryLocation != null ? this.deliveryLocation.hashCode() : 0);
            _result = 31 * _result + (this.commodityFixedPhysicalQuantityModel != null ? this.commodityFixedPhysicalQuantityModel.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BullionPhysicalLeg {bullionType=" + (Object)((Object)this.bullionType) + ", deliveryLocation=" + this.deliveryLocation + ", commodityFixedPhysicalQuantityModel=" + this.commodityFixedPhysicalQuantityModel + ", settlementDate=" + this.settlementDate + '}' + " " + super.toString();
        }
    }
}

