/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AmountAdjustmentEnum;
import fpml.confirmation.MoneyWithParticipantShare;
import fpml.confirmation.meta.AdjustmentMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Adjustment", builder=AdjustmentBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Adjustment", model="fpml", builder=AdjustmentBuilderImpl.class, version="0.17.2")
public interface Adjustment
extends RosettaModelObject {
    public static final AdjustmentMeta metaData = new AdjustmentMeta();

    public AmountAdjustmentEnum getAdjustmentType();

    public MoneyWithParticipantShare getAmount();

    public Adjustment build();

    public AdjustmentBuilder toBuilder();

    public static AdjustmentBuilder builder() {
        return new AdjustmentBuilderImpl();
    }

    default public RosettaMetaData<? extends Adjustment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Adjustment> getType() {
        return Adjustment.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("adjustmentType"), AmountAdjustmentEnum.class, (Object)this.getAdjustmentType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
    }

    public static class AdjustmentBuilderImpl
    implements AdjustmentBuilder {
        protected AmountAdjustmentEnum adjustmentType;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;

        @Override
        @RosettaAttribute(value="adjustmentType", isRequired=true)
        @RuneAttribute(value="adjustmentType", isRequired=true)
        public AmountAdjustmentEnum getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustmentType", isRequired=true)
        @RuneAttribute(value="adjustmentType", isRequired=true)
        public AdjustmentBuilder setAdjustmentType(AmountAdjustmentEnum _adjustmentType) {
            this.adjustmentType = _adjustmentType == null ? null : _adjustmentType;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public AdjustmentBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        public Adjustment build() {
            return new AdjustmentImpl(this);
        }

        @Override
        public AdjustmentBuilder toBuilder() {
            return this;
        }

        @Override
        public AdjustmentBuilder prune() {
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAdjustmentType() != null) {
                return true;
            }
            return this.getAmount() != null && this.getAmount().hasData();
        }

        public AdjustmentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AdjustmentBuilder o = (AdjustmentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeBasic((Object)this.getAdjustmentType(), (Object)o.getAdjustmentType(), this::setAdjustmentType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Adjustment _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.adjustmentType, (Object)_that.getAdjustmentType())) {
                return false;
            }
            return Objects.equals(this.amount, _that.getAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustmentType != null ? ((Object)((Object)this.adjustmentType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AdjustmentBuilder {adjustmentType=" + (Object)((Object)this.adjustmentType) + ", amount=" + this.amount + '}';
        }
    }

    public static interface AdjustmentBuilder
    extends Adjustment,
    RosettaModelObjectBuilder {
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        public AdjustmentBuilder setAdjustmentType(AmountAdjustmentEnum var1);

        public AdjustmentBuilder setAmount(MoneyWithParticipantShare var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("adjustmentType"), AmountAdjustmentEnum.class, (Object)this.getAdjustmentType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
        }

        public AdjustmentBuilder prune();
    }

    public static class AdjustmentImpl
    implements Adjustment {
        private final AmountAdjustmentEnum adjustmentType;
        private final MoneyWithParticipantShare amount;

        protected AdjustmentImpl(AdjustmentBuilder builder) {
            this.adjustmentType = builder.getAdjustmentType();
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="adjustmentType", isRequired=true)
        @RuneAttribute(value="adjustmentType", isRequired=true)
        public AmountAdjustmentEnum getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        public Adjustment build() {
            return this;
        }

        @Override
        public AdjustmentBuilder toBuilder() {
            AdjustmentBuilder builder = Adjustment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AdjustmentBuilder builder) {
            Optional.ofNullable(this.getAdjustmentType()).ifPresent(builder::setAdjustmentType);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Adjustment _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.adjustmentType, (Object)_that.getAdjustmentType())) {
                return false;
            }
            return Objects.equals(this.amount, _that.getAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustmentType != null ? ((Object)((Object)this.adjustmentType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Adjustment {adjustmentType=" + (Object)((Object)this.adjustmentType) + ", amount=" + this.amount + '}';
        }
    }
}

