/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CorrectableRequestMessage;
import fpml.confirmation.CorrelationAndSequenceModel;
import fpml.confirmation.LoanTradePayment;
import fpml.confirmation.LoanTradingPartyRole;
import fpml.confirmation.OnBehalfOfModel;
import fpml.confirmation.PartyReference;
import fpml.confirmation.RequestMessageHeader;
import fpml.confirmation.ValidationModel;
import fpml.confirmation.meta.AbstractLoanTradeNotificationMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractLoanTradeNotification", builder=AbstractLoanTradeNotificationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="AbstractLoanTradeNotification", model="fpml", builder=AbstractLoanTradeNotificationBuilderImpl.class, version="0.17.2")
public interface AbstractLoanTradeNotification
extends CorrectableRequestMessage {
    public static final AbstractLoanTradeNotificationMeta metaData = new AbstractLoanTradeNotificationMeta();

    public ZonedDateTime getNoticeDate();

    public PartyReference getPartyReference();

    public LoanTradingPartyRole getRole();

    public List<? extends LoanTradePayment> getPayment();

    @Override
    public AbstractLoanTradeNotification build();

    @Override
    public AbstractLoanTradeNotificationBuilder toBuilder();

    public static AbstractLoanTradeNotificationBuilder builder() {
        return new AbstractLoanTradeNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractLoanTradeNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractLoanTradeNotification> getType() {
        return AbstractLoanTradeNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("role"), processor, LoanTradingPartyRole.class, this.getRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payment"), processor, LoanTradePayment.class, this.getPayment(), new AttributeMeta[0]);
    }

    public static class AbstractLoanTradeNotificationBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements AbstractLoanTradeNotificationBuilder {
        protected ZonedDateTime noticeDate;
        protected PartyReference.PartyReferenceBuilder partyReference;
        protected LoanTradingPartyRole.LoanTradingPartyRoleBuilder role;
        protected List<LoanTradePayment.LoanTradePaymentBuilder> payment = new ArrayList<LoanTradePayment.LoanTradePaymentBuilder>();

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public ZonedDateTime getNoticeDate() {
            return this.noticeDate;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference.PartyReferenceBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference() {
            PartyReference.PartyReferenceBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="role", isRequired=true)
        @RuneAttribute(value="role", isRequired=true)
        public LoanTradingPartyRole.LoanTradingPartyRoleBuilder getRole() {
            return this.role;
        }

        @Override
        public LoanTradingPartyRole.LoanTradingPartyRoleBuilder getOrCreateRole() {
            LoanTradingPartyRole.LoanTradingPartyRoleBuilder result = this.role != null ? this.role : (this.role = LoanTradingPartyRole.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public List<? extends LoanTradePayment.LoanTradePaymentBuilder> getPayment() {
            return this.payment;
        }

        @Override
        public LoanTradePayment.LoanTradePaymentBuilder getOrCreatePayment(int index) {
            if (this.payment == null) {
                this.payment = new ArrayList<LoanTradePayment.LoanTradePaymentBuilder>();
            }
            return (LoanTradePayment.LoanTradePaymentBuilder)this.getIndex(this.payment, index, () -> {
                LoanTradePayment.LoanTradePaymentBuilder newPayment = LoanTradePayment.builder();
                return newPayment;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public AbstractLoanTradeNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public AbstractLoanTradeNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public AbstractLoanTradeNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header", isRequired=true)
        @RuneAttribute(value="header", isRequired=true)
        public AbstractLoanTradeNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public AbstractLoanTradeNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection", isRequired=true)
        @RuneAttribute(value="isCorrection", isRequired=true)
        public AbstractLoanTradeNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public AbstractLoanTradeNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public AbstractLoanTradeNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public AbstractLoanTradeNotificationBuilder setNoticeDate(ZonedDateTime _noticeDate) {
            this.noticeDate = _noticeDate == null ? null : _noticeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public AbstractLoanTradeNotificationBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="role", isRequired=true)
        @RuneAttribute(value="role", isRequired=true)
        public AbstractLoanTradeNotificationBuilder setRole(LoanTradingPartyRole _role) {
            this.role = _role == null ? null : _role.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public AbstractLoanTradeNotificationBuilder addPayment(LoanTradePayment _payment) {
            if (_payment != null) {
                this.payment.add(_payment.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractLoanTradeNotificationBuilder addPayment(LoanTradePayment _payment, int idx) {
            this.getIndex(this.payment, idx, () -> _payment.toBuilder());
            return this;
        }

        @Override
        public AbstractLoanTradeNotificationBuilder addPayment(List<? extends LoanTradePayment> payments) {
            if (payments != null) {
                for (LoanTradePayment loanTradePayment : payments) {
                    this.payment.add(loanTradePayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="payment")
        public AbstractLoanTradeNotificationBuilder setPayment(List<? extends LoanTradePayment> payments) {
            this.payment = payments == null ? new ArrayList<LoanTradePayment.LoanTradePaymentBuilder>() : (List)payments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AbstractLoanTradeNotification build() {
            return new AbstractLoanTradeNotificationImpl(this);
        }

        @Override
        public AbstractLoanTradeNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractLoanTradeNotificationBuilder prune() {
            super.prune();
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            if (this.role != null && !this.role.prune().hasData()) {
                this.role = null;
            }
            this.payment = this.payment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getNoticeDate() != null) {
                return true;
            }
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            if (this.getRole() != null && this.getRole().hasData()) {
                return true;
            }
            return this.getPayment() != null && this.getPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public AbstractLoanTradeNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractLoanTradeNotificationBuilder o = (AbstractLoanTradeNotificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRole(), (RosettaModelObjectBuilder)o.getRole(), this::setRole);
            merger.mergeRosetta(this.getPayment(), o.getPayment(), this::getOrCreatePayment);
            merger.mergeBasic((Object)this.getNoticeDate(), (Object)o.getNoticeDate(), this::setNoticeDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanTradeNotification _that = (AbstractLoanTradeNotification)this.getType().cast(o);
            if (!Objects.equals(this.noticeDate, _that.getNoticeDate())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.role, _that.getRole())) {
                return false;
            }
            return ListEquals.listEquals(this.payment, _that.getPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.noticeDate != null ? this.noticeDate.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.role != null ? this.role.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanTradeNotificationBuilder {noticeDate=" + this.noticeDate + ", partyReference=" + this.partyReference + ", role=" + this.role + ", payment=" + this.payment + '}' + " " + super.toString();
        }
    }

    public static interface AbstractLoanTradeNotificationBuilder
    extends AbstractLoanTradeNotification,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getPartyReference();

        public LoanTradingPartyRole.LoanTradingPartyRoleBuilder getOrCreateRole();

        @Override
        public LoanTradingPartyRole.LoanTradingPartyRoleBuilder getRole();

        public LoanTradePayment.LoanTradePaymentBuilder getOrCreatePayment(int var1);

        public List<? extends LoanTradePayment.LoanTradePaymentBuilder> getPayment();

        @Override
        public AbstractLoanTradeNotificationBuilder setFpmlVersion(String var1);

        @Override
        public AbstractLoanTradeNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public AbstractLoanTradeNotificationBuilder setActualBuild(Integer var1);

        @Override
        public AbstractLoanTradeNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public AbstractLoanTradeNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public AbstractLoanTradeNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public AbstractLoanTradeNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public AbstractLoanTradeNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public AbstractLoanTradeNotificationBuilder setNoticeDate(ZonedDateTime var1);

        public AbstractLoanTradeNotificationBuilder setPartyReference(PartyReference var1);

        public AbstractLoanTradeNotificationBuilder setRole(LoanTradingPartyRole var1);

        public AbstractLoanTradeNotificationBuilder addPayment(LoanTradePayment var1);

        public AbstractLoanTradeNotificationBuilder addPayment(LoanTradePayment var1, int var2);

        public AbstractLoanTradeNotificationBuilder addPayment(List<? extends LoanTradePayment> var1);

        public AbstractLoanTradeNotificationBuilder setPayment(List<? extends LoanTradePayment> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("role"), processor, LoanTradingPartyRole.LoanTradingPartyRoleBuilder.class, this.getRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payment"), processor, LoanTradePayment.LoanTradePaymentBuilder.class, this.getPayment(), new AttributeMeta[0]);
        }

        @Override
        public AbstractLoanTradeNotificationBuilder prune();
    }

    public static class AbstractLoanTradeNotificationImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements AbstractLoanTradeNotification {
        private final ZonedDateTime noticeDate;
        private final PartyReference partyReference;
        private final LoanTradingPartyRole role;
        private final List<? extends LoanTradePayment> payment;

        protected AbstractLoanTradeNotificationImpl(AbstractLoanTradeNotificationBuilder builder) {
            super(builder);
            this.noticeDate = builder.getNoticeDate();
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.role = Optional.ofNullable(builder.getRole()).map(f -> f.build()).orElse(null);
            this.payment = Optional.ofNullable(builder.getPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public ZonedDateTime getNoticeDate() {
            return this.noticeDate;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="role", isRequired=true)
        @RuneAttribute(value="role", isRequired=true)
        public LoanTradingPartyRole getRole() {
            return this.role;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public List<? extends LoanTradePayment> getPayment() {
            return this.payment;
        }

        @Override
        public AbstractLoanTradeNotification build() {
            return this;
        }

        @Override
        public AbstractLoanTradeNotificationBuilder toBuilder() {
            AbstractLoanTradeNotificationBuilder builder = AbstractLoanTradeNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractLoanTradeNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getNoticeDate()).ifPresent(builder::setNoticeDate);
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getRole()).ifPresent(builder::setRole);
            Optional.ofNullable(this.getPayment()).ifPresent(builder::setPayment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanTradeNotification _that = (AbstractLoanTradeNotification)this.getType().cast(o);
            if (!Objects.equals(this.noticeDate, _that.getNoticeDate())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.role, _that.getRole())) {
                return false;
            }
            return ListEquals.listEquals(this.payment, _that.getPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.noticeDate != null ? this.noticeDate.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.role != null ? this.role.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanTradeNotification {noticeDate=" + this.noticeDate + ", partyReference=" + this.partyReference + ", role=" + this.role + ", payment=" + this.payment + '}' + " " + super.toString();
        }
    }
}

