/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.processor;

import cdm.product.template.ExerciseNotice;
import cdm.product.template.ExerciseNoticeGiverEnum;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExerciseNoticeGiverMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExerciseNoticeGiverMappingProcessor.class);
    private static final String[] OPTION_PAYOUT_BUYER_CDM_PATH = new String[]{"optionPayout", "buyerSeller", "buyer"};
    private static final String[] OPTION_PAYOUT_SELLER_CDM_PATH = new String[]{"optionPayout", "buyerSeller", "seller"};

    public ExerciseNoticeGiverMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public <T> void mapBasic(Path synonymPath, Optional<T> instance, RosettaModelObjectBuilder parent) {
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)synonymPath.addElement("href"), noticeGiverParty -> {
            Optional<ExerciseNoticeGiverEnum> noticeGiverEnum = this.getExerciseNoticeGiverEnum((String)noticeGiverParty);
            if (noticeGiverEnum.isPresent()) {
                LOGGER.info("Exercise notice giver party [{}] was mapped to option {}.", noticeGiverParty, (Object)noticeGiverEnum.get());
                ((ExerciseNotice.ExerciseNoticeBuilder)parent).setExerciseNoticeGiver(noticeGiverEnum.get());
                return true;
            }
            LOGGER.info("Exercise notice giver party [{}] could not be mapped to either option BUYER or SELLER.", noticeGiverParty);
            return false;
        }, (List)this.getMappings(), (RosettaPath)this.getModelPath());
    }

    private Optional<ExerciseNoticeGiverEnum> getExerciseNoticeGiverEnum(String noticeGiver) {
        List<Mapping> tradableProductMappings = this.filterMappingsToTradableProduct();
        if (this.getModelPath().containsPath(RosettaPath.valueOf((String)"exerciseProcedure.manualExercise"))) {
            String buyerParty = this.getXmlValue(tradableProductMappings, m -> m.getRosettaPath().endsWith(OPTION_PAYOUT_BUYER_CDM_PATH));
            String sellerParty = this.getXmlValue(tradableProductMappings, m -> m.getRosettaPath().endsWith(OPTION_PAYOUT_SELLER_CDM_PATH));
            return noticeGiver.equals(buyerParty) ? Optional.of(ExerciseNoticeGiverEnum.BUYER) : (noticeGiver.equals(sellerParty) ? Optional.of(ExerciseNoticeGiverEnum.SELLER) : Optional.empty());
        }
        return Optional.empty();
    }

    private List<Mapping> filterMappingsToTradableProduct() {
        String cdmPath = this.getModelPath().buildPath();
        Path tradableProductPath = PathUtils.toPath((RosettaPath)RosettaPath.valueOf((String)cdmPath.substring(0, cdmPath.indexOf(".product."))));
        return this.getMappings().stream().filter(m -> m.getRosettaPath() != null).filter(m -> tradableProductPath.fullStartMatches(m.getRosettaPath())).collect(Collectors.toList());
    }

    private String getXmlValue(List<Mapping> tradableProductMappings, Function<Mapping, Boolean> mappingFilter) {
        return MappingProcessorUtils.getNonNullMappedValue(tradableProductMappings.stream().filter(mappingFilter::apply).collect(Collectors.toList())).orElse(null);
    }
}

