/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.base.math.Rounding;
import cdm.observable.asset.Price;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.NegativeInterestRateTreatmentEnum;
import cdm.product.asset.RateTreatmentEnum;
import cdm.product.asset.floatingrate.FloatingRateProcessingParameters;
import cdm.product.asset.floatingrate.functions.CapRateAmount;
import cdm.product.asset.floatingrate.functions.FloorRateAmount;
import cdm.product.asset.floatingrate.functions.MultiplierAmount;
import cdm.product.asset.floatingrate.functions.SpreadAmount;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetFloatingRateProcessingParametersDefault.class)
public abstract class GetFloatingRateProcessingParameters
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CapRateAmount capRateAmount;
    @Inject
    protected FloorRateAmount floorRateAmount;
    @Inject
    protected MultiplierAmount multiplierAmount;
    @Inject
    protected SpreadAmount spreadAmount;

    public FloatingRateProcessingParameters evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
        FloatingRateProcessingParameters processingParameters;
        FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder processingParametersBuilder = this.doEvaluate(interestRatePayout, calculationPeriod);
        if (processingParametersBuilder == null) {
            processingParameters = null;
        } else {
            processingParameters = processingParametersBuilder.build();
            this.objectValidator.validate(FloatingRateProcessingParameters.class, (RosettaModelObject)processingParameters);
        }
        return processingParameters;
    }

    protected abstract FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract MapperS<BigDecimal> spreadRate(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract MapperS<BigDecimal> multiplier(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract MapperS<BigDecimal> cap(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract MapperS<BigDecimal> floor(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract MapperS<? extends Rounding> rounding(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract MapperS<NegativeInterestRateTreatmentEnum> negativeTreatment(InterestRatePayout var1, CalculationPeriodBase var2);

    protected abstract MapperS<RateTreatmentEnum> treatment(InterestRatePayout var1, CalculationPeriodBase var2);

    public static class GetFloatingRateProcessingParametersDefault
    extends GetFloatingRateProcessingParameters {
        @Override
        protected FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder processingParameters = FloatingRateProcessingParameters.builder();
            return this.assignOutput(processingParameters, interestRatePayout, calculationPeriod);
        }

        protected FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder assignOutput(FloatingRateProcessingParameters.FloatingRateProcessingParametersBuilder processingParameters, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            processingParameters.setInitialRate((Price)MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRateSpecification", rateSpecification -> rateSpecification.getFloatingRateSpecification()).map("getInitialRate", floatingRateSpecification -> floatingRateSpecification.getInitialRate()).get());
            processingParameters.setSpread((BigDecimal)this.spreadRate(interestRatePayout, calculationPeriod).get());
            processingParameters.setMultiplier((BigDecimal)this.multiplier(interestRatePayout, calculationPeriod).get());
            processingParameters.setTreatment((RateTreatmentEnum)((Object)this.treatment(interestRatePayout, calculationPeriod).get()));
            processingParameters.setCapRate((BigDecimal)this.cap(interestRatePayout, calculationPeriod).get());
            processingParameters.setFloorRate((BigDecimal)this.floor(interestRatePayout, calculationPeriod).get());
            processingParameters.setRounding((Rounding)this.rounding(interestRatePayout, calculationPeriod).get());
            processingParameters.setNegativeTreatment((NegativeInterestRateTreatmentEnum)((Object)this.negativeTreatment(interestRatePayout, calculationPeriod).get()));
            return Optional.ofNullable(processingParameters).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> spreadRate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.spreadAmount.evaluate(interestRatePayout, calculationPeriod));
        }

        @Override
        protected MapperS<BigDecimal> multiplier(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.multiplierAmount.evaluate(interestRatePayout, calculationPeriod));
        }

        @Override
        protected MapperS<BigDecimal> cap(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.capRateAmount.evaluate(interestRatePayout, calculationPeriod));
        }

        @Override
        protected MapperS<BigDecimal> floor(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.floorRateAmount.evaluate(interestRatePayout, calculationPeriod));
        }

        @Override
        protected MapperS<? extends Rounding> rounding(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRateSpecification", rateSpecification -> rateSpecification.getFloatingRateSpecification()).map("getFinalRateRounding", floatingRateSpecification -> floatingRateSpecification.getFinalRateRounding());
        }

        @Override
        protected MapperS<NegativeInterestRateTreatmentEnum> negativeTreatment(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRateSpecification", rateSpecification -> rateSpecification.getFloatingRateSpecification()).map("getNegativeInterestRateTreatment", floatingRateSpecification -> floatingRateSpecification.getNegativeInterestRateTreatment());
        }

        @Override
        protected MapperS<RateTreatmentEnum> treatment(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRateSpecification", rateSpecification -> rateSpecification.getFloatingRateSpecification()).map("getRateTreatment", floatingRateSpecification -> floatingRateSpecification.getRateTreatment());
        }
    }
}

