/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.event.common.Trade;
import cdm.margin.schedule.StandardizedScheduleAssetClassEnum;
import cdm.margin.schedule.StandardizedScheduleProductClassEnum;
import cdm.margin.schedule.functions.StandardizedScheduleCommodityForwardNotionalAmount;
import cdm.margin.schedule.functions.StandardizedScheduleCommoditySwapFixedFloatNotionalAmount;
import cdm.margin.schedule.functions.StandardizedScheduleEquityForwardNotionalAmount;
import cdm.margin.schedule.functions.StandardizedScheduleFXSwapNotional;
import cdm.margin.schedule.functions.StandardizedScheduleFXVarianceNotionalAmount;
import cdm.margin.schedule.functions.StandardizedScheduleMonetaryNotionalFromResolvablePQ;
import cdm.margin.schedule.functions.StandardizedScheduleOptionNotionalAmount;
import cdm.margin.schedule.functions.StandardizedScheduleVarianceSwapNotionalAmount;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.EconomicTerms;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.SettlementPayout;
import cdm.product.template.TradeLot;
import cdm.product.template.functions.FXFarLeg;
import cdm.product.template.functions.UnderlierForOptionOrForwardProduct;
import cdm.product.template.util.ProductDeepPathUtil;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=StandardizedScheduleNotionalDefault.class)
public abstract class StandardizedScheduleNotional
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected FXFarLeg fXFarLeg;
    @Inject
    protected ProductDeepPathUtil productDeepPathUtil;
    @Inject
    protected StandardizedScheduleCommodityForwardNotionalAmount standardizedScheduleCommodityForwardNotionalAmount;
    @Inject
    protected StandardizedScheduleCommoditySwapFixedFloatNotionalAmount standardizedScheduleCommoditySwapFixedFloatNotionalAmount;
    @Inject
    protected StandardizedScheduleEquityForwardNotionalAmount standardizedScheduleEquityForwardNotionalAmount;
    @Inject
    protected StandardizedScheduleFXSwapNotional standardizedScheduleFXSwapNotional;
    @Inject
    protected StandardizedScheduleFXVarianceNotionalAmount standardizedScheduleFXVarianceNotionalAmount;
    @Inject
    protected StandardizedScheduleMonetaryNotionalFromResolvablePQ standardizedScheduleMonetaryNotionalFromResolvablePQ;
    @Inject
    protected StandardizedScheduleOptionNotionalAmount standardizedScheduleOptionNotionalAmount;
    @Inject
    protected StandardizedScheduleVarianceSwapNotionalAmount standardizedScheduleVarianceSwapNotionalAmount;
    @Inject
    protected UnderlierForOptionOrForwardProduct underlierForOptionOrForwardProduct;

    public BigDecimal evaluate(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
        BigDecimal notional = this.doEvaluate(trade, assetClass, productClass);
        this.conditionValidator.validate(() -> ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)notional), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All), "Ensure notional is greater than 0");
        return notional;
    }

    protected abstract BigDecimal doEvaluate(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<? extends NonTransferableProduct> product(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    public static class StandardizedScheduleNotionalDefault
    extends StandardizedScheduleNotional {
        @Override
        protected BigDecimal doEvaluate(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            BigDecimal notional = null;
            return this.assignOutput(notional, trade, assetClass, productClass);
        }

        protected BigDecimal assignOutput(BigDecimal notional, Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.INTEREST_RATES)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAP)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAP_WITH_CALLABLE_BERMUDAN_RIGHT_TO_ENTER_EXIT_SWAPS)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg0 = this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule())).get());
                    MapperS thenArg1 = thenArg0.first();
                    MapperS thenArg2 = thenArg1.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
                    notional = (BigDecimal)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg2.get())).get();
                } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.CROSS_CURRENCY_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg3 = this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).filterItemNullSafe(item -> true);
                    MapperS thenArg4 = thenArg3.first();
                    MapperS thenArg5 = thenArg4.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
                    notional = (BigDecimal)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg5.get())).get();
                } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPTION)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPTION_STRADDLE)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg6 = MapperS.of((Object)this.underlierForOptionOrForwardProduct.evaluate((NonTransferableProduct)this.product(trade, assetClass, productClass).get())).map("getProduct", underlier -> underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule())).get());
                    MapperS thenArg7 = thenArg6.first();
                    MapperS thenArg8 = thenArg7.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
                    notional = (BigDecimal)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg8.get())).get();
                } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperS thenArg9 = MapperS.of((Object)((InterestRatePayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get())).map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
                    notional = (BigDecimal)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg9.get())).get();
                } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.FORWARD_RATE_AGREEMENT)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg10 = this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRateSpecification", rateSpecification -> rateSpecification.getFixedRateSpecification())).get());
                    MapperS thenArg11 = MapperS.of((Object)((InterestRatePayout)thenArg10.get()));
                    MapperS thenArg12 = thenArg11.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity());
                    notional = (BigDecimal)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg12.get())).get();
                } else {
                    notional = null;
                }
            } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.CREDIT)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SINGLE_NAME_CREDIT_DEFAULT_SWAP)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.INDEX_CDS)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.INDEX_TRANCHE)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.CREDIT_NTH_TO_DEFAULT)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperS thenArg13 = MapperS.of((Object)((CreditDefaultPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get())).map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity());
                    notional = (BigDecimal)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg13.get())).get();
                } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperS thenArg14 = MapperS.of((Object)((CreditDefaultPayout)MapperS.of((Object)this.underlierForOptionOrForwardProduct.evaluate((NonTransferableProduct)this.product(trade, assetClass, productClass).get())).map("getProduct", underlier -> underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get())).map("getPriceQuantity", creditDefaultPayout -> creditDefaultPayout.getPriceQuantity());
                    notional = (BigDecimal)MapperS.of((Object)this.standardizedScheduleMonetaryNotionalFromResolvablePQ.evaluate((ResolvablePriceQuantity)thenArg14.get())).get();
                } else {
                    notional = null;
                }
            } else {
                notional = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.FOREIGN_EXCHANGE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.DELIVERABLE_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (BigDecimal)MapperS.of((Object)this.standardizedScheduleFXSwapNotional.evaluate(this.fXFarLeg.evaluate((NonTransferableProduct)this.product(trade, assetClass, productClass).get()), (TradeLot)MapperS.of((Object)trade).mapC("getTradeLot", _trade -> _trade.getTradeLot()).get())).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.NON_DELIVERABLE_CROSS_CURRENCY_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? new BigDecimal("0.0") : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.DELIVERABLE_FORWARD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (BigDecimal)MapperS.of((Object)((SettlementPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getSettlementPayout", payout -> payout.getSettlementPayout()).get())).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.NON_DELIVERABLE_FORWARD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (BigDecimal)MapperS.of((Object)((SettlementPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getSettlementPayout", payout -> payout.getSettlementPayout()).get())).map("getPriceQuantity", settlementPayout -> settlementPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.DELIVERABLE_OPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (BigDecimal)MapperS.of((Object)((OptionPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.NON_DELIVERABLE_OPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (BigDecimal)MapperS.of((Object)((OptionPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.VARIANCE_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? this.standardizedScheduleFXVarianceNotionalAmount.evaluate((PerformancePayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getPerformancePayout", payout -> payout.getPerformancePayout()).get()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.VOLATILITY_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? new BigDecimal("0.0") : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.CORRELATION_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? new BigDecimal("0.0") : null))))))))) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? this.standardizedScheduleOptionNotionalAmount.evaluate((OptionPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.FORWARD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? this.standardizedScheduleEquityForwardNotionalAmount.evaluate((SettlementPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getSettlementPayout", payout -> payout.getSettlementPayout()).get()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.DIVIDEND_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? new BigDecimal("0.0") : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.VARIANCE_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? this.standardizedScheduleVarianceSwapNotionalAmount.evaluate((PerformancePayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getPerformancePayout", payout -> payout.getPerformancePayout()).get()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.VOLATILITY_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? new BigDecimal("0.0") : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPS_AND_PORTFOLIO_SWAPS)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? new BigDecimal("0.0") : null)))))) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.COMMODITY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.FORWARD)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? this.standardizedScheduleCommodityForwardNotionalAmount.evaluate((EconomicTerms)this.economicTerms(trade, assetClass, productClass).get()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? this.standardizedScheduleOptionNotionalAmount.evaluate((OptionPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.FIXED_FLOAT_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? this.standardizedScheduleCommoditySwapFixedFloatNotionalAmount.evaluate((EconomicTerms)this.economicTerms(trade, assetClass, productClass).get()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.BASIS_SWAP)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? new BigDecimal("0.0") : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? this.standardizedScheduleCommoditySwapFixedFloatNotionalAmount.evaluate((EconomicTerms)MapperS.of((Object)this.underlierForOptionOrForwardProduct.evaluate((NonTransferableProduct)this.product(trade, assetClass, productClass).get())).map("getProduct", underlier -> underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).get()) : null))))) : null));
            }
            return notional;
        }

        @Override
        protected MapperS<? extends NonTransferableProduct> product(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct());
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return this.product(trade, assetClass, productClass).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms());
        }
    }
}

