/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.legaldocumentation.csa.PostingObligations;
import cdm.legaldocumentation.csa.PostingObligationsElection;
import cdm.product.collateral.CollateralTreatment;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import org.isda.cdm.processor.CdmMappingProcessorUtils;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class PostingObligationsMappingProcessor
extends MappingProcessor {
    public PostingObligationsMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        PostingObligations.PostingObligationsBuilder obligationsBuilder = (PostingObligations.PostingObligationsBuilder)builder;
        CreateiQMappingProcessorUtils.PARTIES.forEach(party -> this.getPostingObligationsElectionBuilder(synonymPath, (String)party).ifPresent(obligationsBuilder::addPartyElection));
    }

    private Optional<PostingObligationsElection> getPostingObligationsElectionBuilder(Path synonymPath, String party) {
        PostingObligationsElection.PostingObligationsElectionBuilder postingObligationsElectionBuilder = PostingObligationsElection.builder();
        this.setValueAndUpdateMappings(synonymPath.addElement(party + "_type"), value -> postingObligationsElectionBuilder.setParty(CreateiQMappingProcessorUtils.toCounterpartyRoleEnum(party)));
        this.setValueAndUpdateMappings(synonymPath.addElement("additional_language"), value -> postingObligationsElectionBuilder.setAdditionalLanguage(CdmMappingProcessorUtils.removeHtml(value)));
        this.setValueAndUpdateMappings(synonymPath.addElement(party + "_additional_language"), value -> postingObligationsElectionBuilder.setAdditionalLanguage(CdmMappingProcessorUtils.removeHtml(value)));
        this.setValueAndUpdateMappings(synonymPath.addElement(party + "_type"), value -> postingObligationsElectionBuilder.setAsPermitted(!"specify".equals(value)));
        this.setExcludedCollateralValueIfYey(synonymPath, party, postingObligationsElectionBuilder, "_collateral_management_agreement", "_collateral_management_agreement_specify");
        this.setExcludedCollateralValueIfYey(synonymPath, party, postingObligationsElectionBuilder, "_control_agreement", "_control_agreement_specify");
        this.setFxHaircutPercentage(synonymPath, party, postingObligationsElectionBuilder);
        return postingObligationsElectionBuilder.hasData() ? Optional.of(postingObligationsElectionBuilder.build()) : Optional.empty();
    }

    private void setFxHaircutPercentage(Path synonymPath, String party, PostingObligationsElection.PostingObligationsElectionBuilder postingObligationsElectionBuilder) {
        Path fxHaircutPercentagePath = synonymPath.addElement(party + "_fx_haircut_percentage");
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)fxHaircutPercentagePath, xmlValue -> {
            Optional<BigDecimal> maybeFxHaircutValue = this.parseFxHaircutPercentageValue(xmlValue);
            maybeFxHaircutValue.ifPresent(fxHaircutPercentage -> {
                CollateralTreatment.CollateralTreatmentBuilder collateralTreatmentBuilder = postingObligationsElectionBuilder.getOrCreateEligibleCollateral(0).getOrCreateTreatment();
                collateralTreatmentBuilder.setIsIncluded(true);
                collateralTreatmentBuilder.getOrCreateValuationTreatment().setFxHaircutPercentage((BigDecimal)fxHaircutPercentage);
            });
            return maybeFxHaircutValue.isPresent();
        }, (List)this.getMappings(), (RosettaPath)this.getModelPath());
    }

    private Optional<BigDecimal> parseFxHaircutPercentageValue(Object xmlValue) {
        int intValue;
        if (!(xmlValue instanceof String)) {
            return Optional.empty();
        }
        String value = (String)xmlValue;
        try {
            intValue = Integer.parseInt(value.replaceAll(".*\\[(\\d+)\\]%.*", "$1"));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
        if (intValue > 100 || intValue < 0) {
            return Optional.empty();
        }
        BigDecimal bdValue = BigDecimal.valueOf(intValue);
        return Optional.of(bdValue.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_EVEN));
    }

    private void setExcludedCollateralValueIfYey(Path synonymPath, String party, PostingObligationsElection.PostingObligationsElectionBuilder postingObligationsElectionBuilder, String collateral_management_agreement, String collateral_management_agreement_specify) {
        this.setValueAndUpdateMappings(synonymPath.addElement(party + collateral_management_agreement), agreement -> {
            if (agreement.equals("yey")) {
                this.setValueAndUpdateMappings(synonymPath.addElement(party + collateral_management_agreement_specify), postingObligationsElectionBuilder::setExcludedCollateral);
            }
        });
    }
}

