/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.legaldocumentation.csa.meta.RatingMultiplierMeta;
import cdm.observable.asset.CreditNotation;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RatingMultiplier", builder=RatingMultiplierBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="RatingMultiplier", model="cdm", builder=RatingMultiplierBuilderImpl.class, version="7.0.0-dev.50")
public interface RatingMultiplier
extends RosettaModelObject {
    public static final RatingMultiplierMeta metaData = new RatingMultiplierMeta();

    public List<? extends CreditNotation> getRatingVariableSet();

    public BigDecimal getExposureMultiplier();

    public RatingMultiplier build();

    public RatingMultiplierBuilder toBuilder();

    public static RatingMultiplierBuilder builder() {
        return new RatingMultiplierBuilderImpl();
    }

    default public RosettaMetaData<? extends RatingMultiplier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RatingMultiplier> getType() {
        return RatingMultiplier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("ratingVariableSet"), processor, CreditNotation.class, this.getRatingVariableSet(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exposureMultiplier"), BigDecimal.class, (Object)this.getExposureMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class RatingMultiplierBuilderImpl
    implements RatingMultiplierBuilder {
        protected List<CreditNotation.CreditNotationBuilder> ratingVariableSet = new ArrayList<CreditNotation.CreditNotationBuilder>();
        protected BigDecimal exposureMultiplier;

        @Override
        @RosettaAttribute(value="ratingVariableSet", isRequired=true)
        @RuneAttribute(value="ratingVariableSet", isRequired=true)
        public List<? extends CreditNotation.CreditNotationBuilder> getRatingVariableSet() {
            return this.ratingVariableSet;
        }

        @Override
        public CreditNotation.CreditNotationBuilder getOrCreateRatingVariableSet(int index) {
            if (this.ratingVariableSet == null) {
                this.ratingVariableSet = new ArrayList<CreditNotation.CreditNotationBuilder>();
            }
            return (CreditNotation.CreditNotationBuilder)this.getIndex(this.ratingVariableSet, index, () -> {
                CreditNotation.CreditNotationBuilder newRatingVariableSet = CreditNotation.builder();
                return newRatingVariableSet;
            });
        }

        @Override
        @RosettaAttribute(value="exposureMultiplier", isRequired=true)
        @RuneAttribute(value="exposureMultiplier", isRequired=true)
        public BigDecimal getExposureMultiplier() {
            return this.exposureMultiplier;
        }

        @Override
        @RosettaAttribute(value="ratingVariableSet", isRequired=true)
        @RuneAttribute(value="ratingVariableSet", isRequired=true)
        public RatingMultiplierBuilder addRatingVariableSet(CreditNotation _ratingVariableSet) {
            if (_ratingVariableSet != null) {
                this.ratingVariableSet.add(_ratingVariableSet.toBuilder());
            }
            return this;
        }

        @Override
        public RatingMultiplierBuilder addRatingVariableSet(CreditNotation _ratingVariableSet, int idx) {
            this.getIndex(this.ratingVariableSet, idx, () -> _ratingVariableSet.toBuilder());
            return this;
        }

        @Override
        public RatingMultiplierBuilder addRatingVariableSet(List<? extends CreditNotation> ratingVariableSets) {
            if (ratingVariableSets != null) {
                for (CreditNotation creditNotation : ratingVariableSets) {
                    this.ratingVariableSet.add(creditNotation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="ratingVariableSet")
        public RatingMultiplierBuilder setRatingVariableSet(List<? extends CreditNotation> ratingVariableSets) {
            this.ratingVariableSet = ratingVariableSets == null ? new ArrayList<CreditNotation.CreditNotationBuilder>() : (List)ratingVariableSets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="exposureMultiplier", isRequired=true)
        @RuneAttribute(value="exposureMultiplier", isRequired=true)
        public RatingMultiplierBuilder setExposureMultiplier(BigDecimal _exposureMultiplier) {
            this.exposureMultiplier = _exposureMultiplier == null ? null : _exposureMultiplier;
            return this;
        }

        @Override
        public RatingMultiplier build() {
            return new RatingMultiplierImpl(this);
        }

        @Override
        public RatingMultiplierBuilder toBuilder() {
            return this;
        }

        @Override
        public RatingMultiplierBuilder prune() {
            this.ratingVariableSet = this.ratingVariableSet.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getRatingVariableSet() != null && this.getRatingVariableSet().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getExposureMultiplier() != null;
        }

        public RatingMultiplierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RatingMultiplierBuilder o = (RatingMultiplierBuilder)other;
            merger.mergeRosetta(this.getRatingVariableSet(), o.getRatingVariableSet(), this::getOrCreateRatingVariableSet);
            merger.mergeBasic((Object)this.getExposureMultiplier(), (Object)o.getExposureMultiplier(), this::setExposureMultiplier, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RatingMultiplier _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.ratingVariableSet, _that.getRatingVariableSet())) {
                return false;
            }
            return Objects.equals(this.exposureMultiplier, _that.getExposureMultiplier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.ratingVariableSet != null ? this.ratingVariableSet.hashCode() : 0);
            _result = 31 * _result + (this.exposureMultiplier != null ? this.exposureMultiplier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RatingMultiplierBuilder {ratingVariableSet=" + this.ratingVariableSet + ", exposureMultiplier=" + this.exposureMultiplier + '}';
        }
    }

    public static interface RatingMultiplierBuilder
    extends RatingMultiplier,
    RosettaModelObjectBuilder {
        public CreditNotation.CreditNotationBuilder getOrCreateRatingVariableSet(int var1);

        public List<? extends CreditNotation.CreditNotationBuilder> getRatingVariableSet();

        public RatingMultiplierBuilder addRatingVariableSet(CreditNotation var1);

        public RatingMultiplierBuilder addRatingVariableSet(CreditNotation var1, int var2);

        public RatingMultiplierBuilder addRatingVariableSet(List<? extends CreditNotation> var1);

        public RatingMultiplierBuilder setRatingVariableSet(List<? extends CreditNotation> var1);

        public RatingMultiplierBuilder setExposureMultiplier(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("ratingVariableSet"), processor, CreditNotation.CreditNotationBuilder.class, this.getRatingVariableSet(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exposureMultiplier"), BigDecimal.class, (Object)this.getExposureMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public RatingMultiplierBuilder prune();
    }

    public static class RatingMultiplierImpl
    implements RatingMultiplier {
        private final List<? extends CreditNotation> ratingVariableSet;
        private final BigDecimal exposureMultiplier;

        protected RatingMultiplierImpl(RatingMultiplierBuilder builder) {
            this.ratingVariableSet = Optional.ofNullable(builder.getRatingVariableSet()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.exposureMultiplier = builder.getExposureMultiplier();
        }

        @Override
        @RosettaAttribute(value="ratingVariableSet", isRequired=true)
        @RuneAttribute(value="ratingVariableSet", isRequired=true)
        public List<? extends CreditNotation> getRatingVariableSet() {
            return this.ratingVariableSet;
        }

        @Override
        @RosettaAttribute(value="exposureMultiplier", isRequired=true)
        @RuneAttribute(value="exposureMultiplier", isRequired=true)
        public BigDecimal getExposureMultiplier() {
            return this.exposureMultiplier;
        }

        @Override
        public RatingMultiplier build() {
            return this;
        }

        @Override
        public RatingMultiplierBuilder toBuilder() {
            RatingMultiplierBuilder builder = RatingMultiplier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RatingMultiplierBuilder builder) {
            Optional.ofNullable(this.getRatingVariableSet()).ifPresent(builder::setRatingVariableSet);
            Optional.ofNullable(this.getExposureMultiplier()).ifPresent(builder::setExposureMultiplier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RatingMultiplier _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.ratingVariableSet, _that.getRatingVariableSet())) {
                return false;
            }
            return Objects.equals(this.exposureMultiplier, _that.getExposureMultiplier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.ratingVariableSet != null ? this.ratingVariableSet.hashCode() : 0);
            _result = 31 * _result + (this.exposureMultiplier != null ? this.exposureMultiplier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RatingMultiplier {ratingVariableSet=" + this.ratingVariableSet + ", exposureMultiplier=" + this.exposureMultiplier + '}';
        }
    }
}

