/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.legaldocumentation.csa.CSAMTAVariableSet;
import cdm.legaldocumentation.csa.NotRatedByEnum;
import cdm.legaldocumentation.csa.NumberOfRatingAgenciesEnum;
import cdm.legaldocumentation.csa.RatedPartyEnum;
import cdm.legaldocumentation.csa.RatingTypeEnum;
import cdm.legaldocumentation.csa.ZeroEventEnum;
import cdm.legaldocumentation.csa.meta.MTARatingsBasedMeta;
import cdm.observable.asset.CreditNotationMismatchResolutionEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MTARatingsBased", builder=MTARatingsBasedBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="MTARatingsBased", model="cdm", builder=MTARatingsBasedBuilderImpl.class, version="7.0.0-dev.50")
public interface MTARatingsBased
extends RosettaModelObject {
    public static final MTARatingsBasedMeta metaData = new MTARatingsBasedMeta();

    public CounterpartyRoleEnum getParty();

    public ISOCurrencyCodeEnum getCurrency();

    public RatingTypeEnum getRatingType();

    public List<? extends CSAMTAVariableSet> getVariableSet();

    public RatedPartyEnum getRatedParty();

    public String getNamedEntity();

    public String getNamedAffiliate();

    public CreditNotationMismatchResolutionEnum getCompare();

    public Boolean getNoRating();

    public NotRatedByEnum getNotRatedBy();

    public NumberOfRatingAgenciesEnum getNumberOfRatingAgencies();

    public Boolean getZeroEvent();

    public List<ZeroEventEnum> getEvent();

    public MTARatingsBased build();

    public MTARatingsBasedBuilder toBuilder();

    public static MTARatingsBasedBuilder builder() {
        return new MTARatingsBasedBuilderImpl();
    }

    default public RosettaMetaData<? extends MTARatingsBased> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MTARatingsBased> getType() {
        return MTARatingsBased.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currency"), ISOCurrencyCodeEnum.class, (Object)this.getCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ratingType"), RatingTypeEnum.class, (Object)this.getRatingType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("variableSet"), processor, CSAMTAVariableSet.class, this.getVariableSet(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ratedParty"), RatedPartyEnum.class, (Object)this.getRatedParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("namedEntity"), String.class, (Object)this.getNamedEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("namedAffiliate"), String.class, (Object)this.getNamedAffiliate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("compare"), CreditNotationMismatchResolutionEnum.class, (Object)this.getCompare(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noRating"), Boolean.class, (Object)this.getNoRating(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notRatedBy"), NotRatedByEnum.class, (Object)this.getNotRatedBy(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfRatingAgencies"), NumberOfRatingAgenciesEnum.class, (Object)this.getNumberOfRatingAgencies(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("zeroEvent"), Boolean.class, (Object)this.getZeroEvent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("event"), ZeroEventEnum.class, this.getEvent(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MTARatingsBasedBuilderImpl
    implements MTARatingsBasedBuilder {
        protected CounterpartyRoleEnum party;
        protected ISOCurrencyCodeEnum currency;
        protected RatingTypeEnum ratingType;
        protected List<CSAMTAVariableSet.CSAMTAVariableSetBuilder> variableSet = new ArrayList<CSAMTAVariableSet.CSAMTAVariableSetBuilder>();
        protected RatedPartyEnum ratedParty;
        protected String namedEntity;
        protected String namedAffiliate;
        protected CreditNotationMismatchResolutionEnum compare;
        protected Boolean noRating;
        protected NotRatedByEnum notRatedBy;
        protected NumberOfRatingAgenciesEnum numberOfRatingAgencies;
        protected Boolean zeroEvent;
        protected List<ZeroEventEnum> event = new ArrayList<ZeroEventEnum>();

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public ISOCurrencyCodeEnum getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="ratingType", isRequired=true)
        @RuneAttribute(value="ratingType", isRequired=true)
        public RatingTypeEnum getRatingType() {
            return this.ratingType;
        }

        @Override
        @RosettaAttribute(value="variableSet")
        @RuneAttribute(value="variableSet")
        public List<? extends CSAMTAVariableSet.CSAMTAVariableSetBuilder> getVariableSet() {
            return this.variableSet;
        }

        @Override
        public CSAMTAVariableSet.CSAMTAVariableSetBuilder getOrCreateVariableSet(int index) {
            if (this.variableSet == null) {
                this.variableSet = new ArrayList<CSAMTAVariableSet.CSAMTAVariableSetBuilder>();
            }
            return (CSAMTAVariableSet.CSAMTAVariableSetBuilder)this.getIndex(this.variableSet, index, () -> {
                CSAMTAVariableSet.CSAMTAVariableSetBuilder newVariableSet = CSAMTAVariableSet.builder();
                return newVariableSet;
            });
        }

        @Override
        @RosettaAttribute(value="ratedParty")
        @RuneAttribute(value="ratedParty")
        public RatedPartyEnum getRatedParty() {
            return this.ratedParty;
        }

        @Override
        @RosettaAttribute(value="namedEntity")
        @RuneAttribute(value="namedEntity")
        public String getNamedEntity() {
            return this.namedEntity;
        }

        @Override
        @RosettaAttribute(value="namedAffiliate")
        @RuneAttribute(value="namedAffiliate")
        public String getNamedAffiliate() {
            return this.namedAffiliate;
        }

        @Override
        @RosettaAttribute(value="compare")
        @RuneAttribute(value="compare")
        public CreditNotationMismatchResolutionEnum getCompare() {
            return this.compare;
        }

        @Override
        @RosettaAttribute(value="noRating", isRequired=true)
        @RuneAttribute(value="noRating", isRequired=true)
        public Boolean getNoRating() {
            return this.noRating;
        }

        @Override
        @RosettaAttribute(value="notRatedBy")
        @RuneAttribute(value="notRatedBy")
        public NotRatedByEnum getNotRatedBy() {
            return this.notRatedBy;
        }

        @Override
        @RosettaAttribute(value="numberOfRatingAgencies")
        @RuneAttribute(value="numberOfRatingAgencies")
        public NumberOfRatingAgenciesEnum getNumberOfRatingAgencies() {
            return this.numberOfRatingAgencies;
        }

        @Override
        @RosettaAttribute(value="zeroEvent", isRequired=true)
        @RuneAttribute(value="zeroEvent", isRequired=true)
        public Boolean getZeroEvent() {
            return this.zeroEvent;
        }

        @Override
        @RosettaAttribute(value="event")
        @RuneAttribute(value="event")
        public List<ZeroEventEnum> getEvent() {
            return this.event;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public MTARatingsBasedBuilder setParty(CounterpartyRoleEnum _party) {
            this.party = _party == null ? null : _party;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public MTARatingsBasedBuilder setCurrency(ISOCurrencyCodeEnum _currency) {
            this.currency = _currency == null ? null : _currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="ratingType", isRequired=true)
        @RuneAttribute(value="ratingType", isRequired=true)
        public MTARatingsBasedBuilder setRatingType(RatingTypeEnum _ratingType) {
            this.ratingType = _ratingType == null ? null : _ratingType;
            return this;
        }

        @Override
        @RosettaAttribute(value="variableSet")
        @RuneAttribute(value="variableSet")
        public MTARatingsBasedBuilder addVariableSet(CSAMTAVariableSet _variableSet) {
            if (_variableSet != null) {
                this.variableSet.add(_variableSet.toBuilder());
            }
            return this;
        }

        @Override
        public MTARatingsBasedBuilder addVariableSet(CSAMTAVariableSet _variableSet, int idx) {
            this.getIndex(this.variableSet, idx, () -> _variableSet.toBuilder());
            return this;
        }

        @Override
        public MTARatingsBasedBuilder addVariableSet(List<? extends CSAMTAVariableSet> variableSets) {
            if (variableSets != null) {
                for (CSAMTAVariableSet cSAMTAVariableSet : variableSets) {
                    this.variableSet.add(cSAMTAVariableSet.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="variableSet")
        public MTARatingsBasedBuilder setVariableSet(List<? extends CSAMTAVariableSet> variableSets) {
            this.variableSet = variableSets == null ? new ArrayList<CSAMTAVariableSet.CSAMTAVariableSetBuilder>() : (List)variableSets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="ratedParty")
        @RuneAttribute(value="ratedParty")
        public MTARatingsBasedBuilder setRatedParty(RatedPartyEnum _ratedParty) {
            this.ratedParty = _ratedParty == null ? null : _ratedParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="namedEntity")
        @RuneAttribute(value="namedEntity")
        public MTARatingsBasedBuilder setNamedEntity(String _namedEntity) {
            this.namedEntity = _namedEntity == null ? null : _namedEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="namedAffiliate")
        @RuneAttribute(value="namedAffiliate")
        public MTARatingsBasedBuilder setNamedAffiliate(String _namedAffiliate) {
            this.namedAffiliate = _namedAffiliate == null ? null : _namedAffiliate;
            return this;
        }

        @Override
        @RosettaAttribute(value="compare")
        @RuneAttribute(value="compare")
        public MTARatingsBasedBuilder setCompare(CreditNotationMismatchResolutionEnum _compare) {
            this.compare = _compare == null ? null : _compare;
            return this;
        }

        @Override
        @RosettaAttribute(value="noRating", isRequired=true)
        @RuneAttribute(value="noRating", isRequired=true)
        public MTARatingsBasedBuilder setNoRating(Boolean _noRating) {
            this.noRating = _noRating == null ? null : _noRating;
            return this;
        }

        @Override
        @RosettaAttribute(value="notRatedBy")
        @RuneAttribute(value="notRatedBy")
        public MTARatingsBasedBuilder setNotRatedBy(NotRatedByEnum _notRatedBy) {
            this.notRatedBy = _notRatedBy == null ? null : _notRatedBy;
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfRatingAgencies")
        @RuneAttribute(value="numberOfRatingAgencies")
        public MTARatingsBasedBuilder setNumberOfRatingAgencies(NumberOfRatingAgenciesEnum _numberOfRatingAgencies) {
            this.numberOfRatingAgencies = _numberOfRatingAgencies == null ? null : _numberOfRatingAgencies;
            return this;
        }

        @Override
        @RosettaAttribute(value="zeroEvent", isRequired=true)
        @RuneAttribute(value="zeroEvent", isRequired=true)
        public MTARatingsBasedBuilder setZeroEvent(Boolean _zeroEvent) {
            this.zeroEvent = _zeroEvent == null ? null : _zeroEvent;
            return this;
        }

        @Override
        @RosettaAttribute(value="event")
        @RuneAttribute(value="event")
        public MTARatingsBasedBuilder addEvent(ZeroEventEnum _event) {
            if (_event != null) {
                this.event.add(_event);
            }
            return this;
        }

        @Override
        public MTARatingsBasedBuilder addEvent(ZeroEventEnum _event, int idx) {
            this.getIndex(this.event, idx, () -> _event);
            return this;
        }

        @Override
        public MTARatingsBasedBuilder addEvent(List<ZeroEventEnum> events) {
            if (events != null) {
                for (ZeroEventEnum toAdd : events) {
                    this.event.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="event")
        public MTARatingsBasedBuilder setEvent(List<ZeroEventEnum> events) {
            this.event = events == null ? new ArrayList<ZeroEventEnum>() : (List)events.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MTARatingsBased build() {
            return new MTARatingsBasedImpl(this);
        }

        @Override
        public MTARatingsBasedBuilder toBuilder() {
            return this;
        }

        @Override
        public MTARatingsBasedBuilder prune() {
            this.variableSet = this.variableSet.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null) {
                return true;
            }
            if (this.getCurrency() != null) {
                return true;
            }
            if (this.getRatingType() != null) {
                return true;
            }
            if (this.getVariableSet() != null && this.getVariableSet().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRatedParty() != null) {
                return true;
            }
            if (this.getNamedEntity() != null) {
                return true;
            }
            if (this.getNamedAffiliate() != null) {
                return true;
            }
            if (this.getCompare() != null) {
                return true;
            }
            if (this.getNoRating() != null) {
                return true;
            }
            if (this.getNotRatedBy() != null) {
                return true;
            }
            if (this.getNumberOfRatingAgencies() != null) {
                return true;
            }
            if (this.getZeroEvent() != null) {
                return true;
            }
            return this.getEvent() != null && !this.getEvent().isEmpty();
        }

        public MTARatingsBasedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MTARatingsBasedBuilder o = (MTARatingsBasedBuilder)other;
            merger.mergeRosetta(this.getVariableSet(), o.getVariableSet(), this::getOrCreateVariableSet);
            merger.mergeBasic((Object)this.getParty(), (Object)o.getParty(), this::setParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrency(), (Object)o.getCurrency(), this::setCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRatingType(), (Object)o.getRatingType(), this::setRatingType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRatedParty(), (Object)o.getRatedParty(), this::setRatedParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNamedEntity(), (Object)o.getNamedEntity(), this::setNamedEntity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNamedAffiliate(), (Object)o.getNamedAffiliate(), this::setNamedAffiliate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCompare(), (Object)o.getCompare(), this::setCompare, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNoRating(), (Object)o.getNoRating(), this::setNoRating, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotRatedBy(), (Object)o.getNotRatedBy(), this::setNotRatedBy, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNumberOfRatingAgencies(), (Object)o.getNumberOfRatingAgencies(), this::setNumberOfRatingAgencies, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getZeroEvent(), (Object)o.getZeroEvent(), this::setZeroEvent, new AttributeMeta[0]);
            merger.mergeBasic(this.getEvent(), o.getEvent(), this::addEvent);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MTARatingsBased _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.currency, (Object)_that.getCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.ratingType, (Object)_that.getRatingType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.variableSet, _that.getVariableSet())) {
                return false;
            }
            if (!Objects.equals((Object)this.ratedParty, (Object)_that.getRatedParty())) {
                return false;
            }
            if (!Objects.equals(this.namedEntity, _that.getNamedEntity())) {
                return false;
            }
            if (!Objects.equals(this.namedAffiliate, _that.getNamedAffiliate())) {
                return false;
            }
            if (!Objects.equals((Object)this.compare, (Object)_that.getCompare())) {
                return false;
            }
            if (!Objects.equals(this.noRating, _that.getNoRating())) {
                return false;
            }
            if (!Objects.equals((Object)this.notRatedBy, (Object)_that.getNotRatedBy())) {
                return false;
            }
            if (!Objects.equals((Object)this.numberOfRatingAgencies, (Object)_that.getNumberOfRatingAgencies())) {
                return false;
            }
            if (!Objects.equals(this.zeroEvent, _that.getZeroEvent())) {
                return false;
            }
            return ListEquals.listEquals(this.event, _that.getEvent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? ((Object)((Object)this.currency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.ratingType != null ? ((Object)((Object)this.ratingType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variableSet != null ? this.variableSet.hashCode() : 0);
            _result = 31 * _result + (this.ratedParty != null ? ((Object)((Object)this.ratedParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.namedEntity != null ? this.namedEntity.hashCode() : 0);
            _result = 31 * _result + (this.namedAffiliate != null ? this.namedAffiliate.hashCode() : 0);
            _result = 31 * _result + (this.compare != null ? ((Object)((Object)this.compare)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.noRating != null ? this.noRating.hashCode() : 0);
            _result = 31 * _result + (this.notRatedBy != null ? ((Object)((Object)this.notRatedBy)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.numberOfRatingAgencies != null ? ((Object)((Object)this.numberOfRatingAgencies)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.zeroEvent != null ? this.zeroEvent.hashCode() : 0);
            _result = 31 * _result + (this.event != null ? this.event.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        public String toString() {
            return "MTARatingsBasedBuilder {party=" + (Object)((Object)this.party) + ", currency=" + (Object)((Object)this.currency) + ", ratingType=" + (Object)((Object)this.ratingType) + ", variableSet=" + this.variableSet + ", ratedParty=" + (Object)((Object)this.ratedParty) + ", namedEntity=" + this.namedEntity + ", namedAffiliate=" + this.namedAffiliate + ", compare=" + (Object)((Object)this.compare) + ", noRating=" + this.noRating + ", notRatedBy=" + (Object)((Object)this.notRatedBy) + ", numberOfRatingAgencies=" + (Object)((Object)this.numberOfRatingAgencies) + ", zeroEvent=" + this.zeroEvent + ", event=" + this.event + '}';
        }
    }

    public static interface MTARatingsBasedBuilder
    extends MTARatingsBased,
    RosettaModelObjectBuilder {
        public CSAMTAVariableSet.CSAMTAVariableSetBuilder getOrCreateVariableSet(int var1);

        public List<? extends CSAMTAVariableSet.CSAMTAVariableSetBuilder> getVariableSet();

        public MTARatingsBasedBuilder setParty(CounterpartyRoleEnum var1);

        public MTARatingsBasedBuilder setCurrency(ISOCurrencyCodeEnum var1);

        public MTARatingsBasedBuilder setRatingType(RatingTypeEnum var1);

        public MTARatingsBasedBuilder addVariableSet(CSAMTAVariableSet var1);

        public MTARatingsBasedBuilder addVariableSet(CSAMTAVariableSet var1, int var2);

        public MTARatingsBasedBuilder addVariableSet(List<? extends CSAMTAVariableSet> var1);

        public MTARatingsBasedBuilder setVariableSet(List<? extends CSAMTAVariableSet> var1);

        public MTARatingsBasedBuilder setRatedParty(RatedPartyEnum var1);

        public MTARatingsBasedBuilder setNamedEntity(String var1);

        public MTARatingsBasedBuilder setNamedAffiliate(String var1);

        public MTARatingsBasedBuilder setCompare(CreditNotationMismatchResolutionEnum var1);

        public MTARatingsBasedBuilder setNoRating(Boolean var1);

        public MTARatingsBasedBuilder setNotRatedBy(NotRatedByEnum var1);

        public MTARatingsBasedBuilder setNumberOfRatingAgencies(NumberOfRatingAgenciesEnum var1);

        public MTARatingsBasedBuilder setZeroEvent(Boolean var1);

        public MTARatingsBasedBuilder addEvent(ZeroEventEnum var1);

        public MTARatingsBasedBuilder addEvent(ZeroEventEnum var1, int var2);

        public MTARatingsBasedBuilder addEvent(List<ZeroEventEnum> var1);

        public MTARatingsBasedBuilder setEvent(List<ZeroEventEnum> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currency"), ISOCurrencyCodeEnum.class, (Object)this.getCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ratingType"), RatingTypeEnum.class, (Object)this.getRatingType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("variableSet"), processor, CSAMTAVariableSet.CSAMTAVariableSetBuilder.class, this.getVariableSet(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ratedParty"), RatedPartyEnum.class, (Object)this.getRatedParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("namedEntity"), String.class, (Object)this.getNamedEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("namedAffiliate"), String.class, (Object)this.getNamedAffiliate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("compare"), CreditNotationMismatchResolutionEnum.class, (Object)this.getCompare(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noRating"), Boolean.class, (Object)this.getNoRating(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notRatedBy"), NotRatedByEnum.class, (Object)this.getNotRatedBy(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfRatingAgencies"), NumberOfRatingAgenciesEnum.class, (Object)this.getNumberOfRatingAgencies(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("zeroEvent"), Boolean.class, (Object)this.getZeroEvent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("event"), ZeroEventEnum.class, this.getEvent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public MTARatingsBasedBuilder prune();
    }

    public static class MTARatingsBasedImpl
    implements MTARatingsBased {
        private final CounterpartyRoleEnum party;
        private final ISOCurrencyCodeEnum currency;
        private final RatingTypeEnum ratingType;
        private final List<? extends CSAMTAVariableSet> variableSet;
        private final RatedPartyEnum ratedParty;
        private final String namedEntity;
        private final String namedAffiliate;
        private final CreditNotationMismatchResolutionEnum compare;
        private final Boolean noRating;
        private final NotRatedByEnum notRatedBy;
        private final NumberOfRatingAgenciesEnum numberOfRatingAgencies;
        private final Boolean zeroEvent;
        private final List<ZeroEventEnum> event;

        protected MTARatingsBasedImpl(MTARatingsBasedBuilder builder) {
            this.party = builder.getParty();
            this.currency = builder.getCurrency();
            this.ratingType = builder.getRatingType();
            this.variableSet = Optional.ofNullable(builder.getVariableSet()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.ratedParty = builder.getRatedParty();
            this.namedEntity = builder.getNamedEntity();
            this.namedAffiliate = builder.getNamedAffiliate();
            this.compare = builder.getCompare();
            this.noRating = builder.getNoRating();
            this.notRatedBy = builder.getNotRatedBy();
            this.numberOfRatingAgencies = builder.getNumberOfRatingAgencies();
            this.zeroEvent = builder.getZeroEvent();
            this.event = Optional.ofNullable(builder.getEvent()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public ISOCurrencyCodeEnum getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="ratingType", isRequired=true)
        @RuneAttribute(value="ratingType", isRequired=true)
        public RatingTypeEnum getRatingType() {
            return this.ratingType;
        }

        @Override
        @RosettaAttribute(value="variableSet")
        @RuneAttribute(value="variableSet")
        public List<? extends CSAMTAVariableSet> getVariableSet() {
            return this.variableSet;
        }

        @Override
        @RosettaAttribute(value="ratedParty")
        @RuneAttribute(value="ratedParty")
        public RatedPartyEnum getRatedParty() {
            return this.ratedParty;
        }

        @Override
        @RosettaAttribute(value="namedEntity")
        @RuneAttribute(value="namedEntity")
        public String getNamedEntity() {
            return this.namedEntity;
        }

        @Override
        @RosettaAttribute(value="namedAffiliate")
        @RuneAttribute(value="namedAffiliate")
        public String getNamedAffiliate() {
            return this.namedAffiliate;
        }

        @Override
        @RosettaAttribute(value="compare")
        @RuneAttribute(value="compare")
        public CreditNotationMismatchResolutionEnum getCompare() {
            return this.compare;
        }

        @Override
        @RosettaAttribute(value="noRating", isRequired=true)
        @RuneAttribute(value="noRating", isRequired=true)
        public Boolean getNoRating() {
            return this.noRating;
        }

        @Override
        @RosettaAttribute(value="notRatedBy")
        @RuneAttribute(value="notRatedBy")
        public NotRatedByEnum getNotRatedBy() {
            return this.notRatedBy;
        }

        @Override
        @RosettaAttribute(value="numberOfRatingAgencies")
        @RuneAttribute(value="numberOfRatingAgencies")
        public NumberOfRatingAgenciesEnum getNumberOfRatingAgencies() {
            return this.numberOfRatingAgencies;
        }

        @Override
        @RosettaAttribute(value="zeroEvent", isRequired=true)
        @RuneAttribute(value="zeroEvent", isRequired=true)
        public Boolean getZeroEvent() {
            return this.zeroEvent;
        }

        @Override
        @RosettaAttribute(value="event")
        @RuneAttribute(value="event")
        public List<ZeroEventEnum> getEvent() {
            return this.event;
        }

        @Override
        public MTARatingsBased build() {
            return this;
        }

        @Override
        public MTARatingsBasedBuilder toBuilder() {
            MTARatingsBasedBuilder builder = MTARatingsBased.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MTARatingsBasedBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getRatingType()).ifPresent(builder::setRatingType);
            Optional.ofNullable(this.getVariableSet()).ifPresent(builder::setVariableSet);
            Optional.ofNullable(this.getRatedParty()).ifPresent(builder::setRatedParty);
            Optional.ofNullable(this.getNamedEntity()).ifPresent(builder::setNamedEntity);
            Optional.ofNullable(this.getNamedAffiliate()).ifPresent(builder::setNamedAffiliate);
            Optional.ofNullable(this.getCompare()).ifPresent(builder::setCompare);
            Optional.ofNullable(this.getNoRating()).ifPresent(builder::setNoRating);
            Optional.ofNullable(this.getNotRatedBy()).ifPresent(builder::setNotRatedBy);
            Optional.ofNullable(this.getNumberOfRatingAgencies()).ifPresent(builder::setNumberOfRatingAgencies);
            Optional.ofNullable(this.getZeroEvent()).ifPresent(builder::setZeroEvent);
            Optional.ofNullable(this.getEvent()).ifPresent(builder::setEvent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MTARatingsBased _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.currency, (Object)_that.getCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.ratingType, (Object)_that.getRatingType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.variableSet, _that.getVariableSet())) {
                return false;
            }
            if (!Objects.equals((Object)this.ratedParty, (Object)_that.getRatedParty())) {
                return false;
            }
            if (!Objects.equals(this.namedEntity, _that.getNamedEntity())) {
                return false;
            }
            if (!Objects.equals(this.namedAffiliate, _that.getNamedAffiliate())) {
                return false;
            }
            if (!Objects.equals((Object)this.compare, (Object)_that.getCompare())) {
                return false;
            }
            if (!Objects.equals(this.noRating, _that.getNoRating())) {
                return false;
            }
            if (!Objects.equals((Object)this.notRatedBy, (Object)_that.getNotRatedBy())) {
                return false;
            }
            if (!Objects.equals((Object)this.numberOfRatingAgencies, (Object)_that.getNumberOfRatingAgencies())) {
                return false;
            }
            if (!Objects.equals(this.zeroEvent, _that.getZeroEvent())) {
                return false;
            }
            return ListEquals.listEquals(this.event, _that.getEvent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? ((Object)((Object)this.currency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.ratingType != null ? ((Object)((Object)this.ratingType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variableSet != null ? this.variableSet.hashCode() : 0);
            _result = 31 * _result + (this.ratedParty != null ? ((Object)((Object)this.ratedParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.namedEntity != null ? this.namedEntity.hashCode() : 0);
            _result = 31 * _result + (this.namedAffiliate != null ? this.namedAffiliate.hashCode() : 0);
            _result = 31 * _result + (this.compare != null ? ((Object)((Object)this.compare)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.noRating != null ? this.noRating.hashCode() : 0);
            _result = 31 * _result + (this.notRatedBy != null ? ((Object)((Object)this.notRatedBy)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.numberOfRatingAgencies != null ? ((Object)((Object)this.numberOfRatingAgencies)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.zeroEvent != null ? this.zeroEvent.hashCode() : 0);
            _result = 31 * _result + (this.event != null ? this.event.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        public String toString() {
            return "MTARatingsBased {party=" + (Object)((Object)this.party) + ", currency=" + (Object)((Object)this.currency) + ", ratingType=" + (Object)((Object)this.ratingType) + ", variableSet=" + this.variableSet + ", ratedParty=" + (Object)((Object)this.ratedParty) + ", namedEntity=" + this.namedEntity + ", namedAffiliate=" + this.namedAffiliate + ", compare=" + (Object)((Object)this.compare) + ", noRating=" + this.noRating + ", notRatedBy=" + (Object)((Object)this.notRatedBy) + ", numberOfRatingAgencies=" + (Object)((Object)this.numberOfRatingAgencies) + ", zeroEvent=" + this.zeroEvent + ", event=" + this.event + '}';
        }
    }
}

