/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow.functions;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Account;
import cdm.base.staticdata.party.Party;
import cdm.event.common.ActionEnum;
import cdm.event.common.BusinessEvent;
import cdm.event.workflow.EventTimestamp;
import cdm.event.workflow.MessageInformation;
import cdm.event.workflow.WorkflowStep;
import cdm.event.workflow.metafields.ReferenceWithMetaWorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_WorkflowStepDefault.class)
public abstract class Create_WorkflowStep
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public WorkflowStep evaluate(MessageInformation messageInformation, List<? extends EventTimestamp> timestamp, List<? extends Identifier> eventIdentifier, List<? extends Party> party, List<? extends Account> account, WorkflowStep previousWorkflowStep, ActionEnum action, BusinessEvent businessEvent) {
        WorkflowStep workflowStep;
        this.conditionValidator.validate(() -> {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)previousWorkflowStep)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)previousWorkflowStep).map("getBusinessEvent", _workflowStep -> _workflowStep.getBusinessEvent()));
            }
            return ComparisonResult.successEmptyOperand((String)"");
        }, "The previous workflow step must contain a business event. Use Create_AcceptedWorkflowStep when the previous workflow step is a proposal.");
        this.conditionValidator.validate(() -> {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)previousWorkflowStep).map("getAction", _workflowStep -> _workflowStep.getAction()), (Mapper)MapperS.of((Object)((Object)ActionEnum.NEW)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)previousWorkflowStep).map("getAction", _workflowStep -> _workflowStep.getAction()), (Mapper)MapperS.of((Object)((Object)ActionEnum.CORRECT)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)action)), (Mapper)MapperS.of((Object)((Object)ActionEnum.NEW)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)action)), (Mapper)MapperS.of((Object)((Object)ActionEnum.CORRECT)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)action)), (Mapper)MapperS.of((Object)((Object)ActionEnum.CANCEL)), (CardinalityOperator)CardinalityOperator.All));
            }
            return ComparisonResult.successEmptyOperand((String)"");
        }, "Valid action transitions are: New -> New, New -> Correct, New -> Cancel, Correct -> New, Correct -> Correct and Correct -> Cancel");
        this.conditionValidator.validate(() -> ExpressionOperators.notEqual((Mapper)MapperS.of((Object)previousWorkflowStep).map("getAction", _workflowStep -> _workflowStep.getAction()), (Mapper)MapperS.of((Object)((Object)ActionEnum.CANCEL)), (CardinalityOperator)CardinalityOperator.Any), "You cannot create a business event on a cancelled previous step");
        this.conditionValidator.validate(() -> {
            if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)previousWorkflowStep)).or(ExpressionOperators.notExists((Mapper)MapperS.of((Object)previousWorkflowStep).map("getAction", _workflowStep -> _workflowStep.getAction()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)action)), (Mapper)MapperS.of((Object)((Object)ActionEnum.NEW)), (CardinalityOperator)CardinalityOperator.All);
            }
            return ComparisonResult.successEmptyOperand((String)"");
        }, "Action must be New if there is no previous step");
        WorkflowStep.WorkflowStepBuilder workflowStepBuilder = this.doEvaluate(messageInformation, timestamp, eventIdentifier, party, account, previousWorkflowStep, action, businessEvent);
        if (workflowStepBuilder == null) {
            workflowStep = null;
        } else {
            workflowStep = workflowStepBuilder.build();
            this.objectValidator.validate(WorkflowStep.class, (RosettaModelObject)workflowStep);
        }
        return workflowStep;
    }

    protected abstract WorkflowStep.WorkflowStepBuilder doEvaluate(MessageInformation var1, List<? extends EventTimestamp> var2, List<? extends Identifier> var3, List<? extends Party> var4, List<? extends Account> var5, WorkflowStep var6, ActionEnum var7, BusinessEvent var8);

    public static class Create_WorkflowStepDefault
    extends Create_WorkflowStep {
        @Override
        protected WorkflowStep.WorkflowStepBuilder doEvaluate(MessageInformation messageInformation, List<? extends EventTimestamp> timestamp, List<? extends Identifier> eventIdentifier, List<? extends Party> party, List<? extends Account> account, WorkflowStep previousWorkflowStep, ActionEnum action, BusinessEvent businessEvent) {
            if (timestamp == null) {
                timestamp = Collections.emptyList();
            }
            if (eventIdentifier == null) {
                eventIdentifier = Collections.emptyList();
            }
            if (party == null) {
                party = Collections.emptyList();
            }
            if (account == null) {
                account = Collections.emptyList();
            }
            WorkflowStep.WorkflowStepBuilder workflowStep = WorkflowStep.builder();
            return this.assignOutput(workflowStep, messageInformation, timestamp, eventIdentifier, party, account, previousWorkflowStep, action, businessEvent);
        }

        protected WorkflowStep.WorkflowStepBuilder assignOutput(WorkflowStep.WorkflowStepBuilder workflowStep, MessageInformation messageInformation, List<? extends EventTimestamp> timestamp, List<? extends Identifier> eventIdentifier, List<? extends Party> party, List<? extends Account> account, WorkflowStep previousWorkflowStep, ActionEnum action, BusinessEvent businessEvent) {
            workflowStep.setAction(action);
            workflowStep.setMessageInformation(messageInformation);
            workflowStep.addTimestamp(timestamp);
            workflowStep.addEventIdentifier(eventIdentifier);
            workflowStep.addParty(party);
            workflowStep.addAccount(account);
            WorkflowStep workflowStepPreviousWorkflowStep = null;
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)previousWorkflowStep)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                workflowStepPreviousWorkflowStep = previousWorkflowStep;
            }
            workflowStep.setPreviousWorkflowStep(ReferenceWithMetaWorkflowStep.builder().setGlobalReference(Optional.ofNullable(workflowStepPreviousWorkflowStep).map(r -> r.getMeta()).map(m -> m.getGlobalKey()).orElse(null)).setExternalReference(Optional.ofNullable(workflowStepPreviousWorkflowStep).map(r -> r.getMeta()).map(m -> m.getExternalKey()).orElse(null)).build());
            workflowStep.setBusinessEvent(businessEvent);
            return Optional.ofNullable(workflowStep).map(o -> o.prune()).orElse(null);
        }
    }
}

