/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position.validation.datarule;

import cdm.event.position.PortfolioState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PortfolioStateNonTransferable")
@ImplementedBy(value=Default.class)
public interface PortfolioStateNonTransferable
extends Validator<PortfolioState> {
    public static final String NAME = "PortfolioStateNonTransferable";
    public static final String DEFINITION = "positions -> product -> NonTransferableProduct exists";

    public static class NoOp
    implements PortfolioStateNonTransferable {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PortfolioState portfolioState) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PortfolioStateNonTransferable {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PortfolioState portfolioState) {
            ComparisonResult result = this.executeDataRule(portfolioState);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PortfolioStateNonTransferable.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PortfolioState", (RosettaPath)path, (String)PortfolioStateNonTransferable.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PortfolioStateNonTransferable.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PortfolioState", (RosettaPath)path, (String)PortfolioStateNonTransferable.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PortfolioState portfolioState) {
            try {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)portfolioState).mapC("getPositions", _portfolioState -> _portfolioState.getPositions()).map("getProduct", position -> position.getProduct()).map("getNonTransferableProduct", product -> product.getNonTransferableProduct()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

