/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position;

import cdm.base.staticdata.asset.common.Asset;
import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.event.position.PositionBase;
import cdm.event.position.meta.PositionMeta;
import cdm.observable.asset.Money;
import cdm.observable.asset.PriceQuantity;
import cdm.product.template.Product;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Position", builder=PositionBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="Position", model="cdm", builder=PositionBuilderImpl.class, version="7.0.0-dev.50")
public interface Position
extends PositionBase {
    public static final PositionMeta metaData = new PositionMeta();

    @Override
    public Product getProduct();

    @Override
    public Position build();

    @Override
    public PositionBuilder toBuilder();

    public static PositionBuilder builder() {
        return new PositionBuilderImpl();
    }

    default public RosettaMetaData<? extends Position> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Position> getType() {
        return Position.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("product"), processor, Product.class, this.getProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("asset"), processor, Asset.class, this.getAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashBalance"), processor, Money.class, this.getCashBalance(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTradeState.class, this.getTradeReference(), new AttributeMeta[0]);
    }

    public static class PositionBuilderImpl
    extends PositionBase.PositionBaseBuilderImpl
    implements PositionBuilder {
        protected Product.ProductBuilder product;

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public Product.ProductBuilder getProduct() {
            return this.product;
        }

        @Override
        public Product.ProductBuilder getOrCreateProduct() {
            Product.ProductBuilder result = this.product != null ? this.product : (this.product = Product.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public PositionBuilder addPriceQuantity(PriceQuantity _priceQuantity) {
            if (_priceQuantity != null) {
                this.priceQuantity.add(_priceQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public PositionBuilder addPriceQuantity(PriceQuantity _priceQuantity, int idx) {
            this.getIndex(this.priceQuantity, idx, () -> _priceQuantity.toBuilder());
            return this;
        }

        @Override
        public PositionBuilder addPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            if (priceQuantitys != null) {
                for (PriceQuantity priceQuantity : priceQuantitys) {
                    this.priceQuantity.add(priceQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceQuantity")
        public PositionBuilder setPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            this.priceQuantity = priceQuantitys == null ? new ArrayList() : (List)priceQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public PositionBuilder setProductOverriddenAsProduct(Product _product) {
            this.product = _product == null ? null : _product.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public PositionBuilder setProduct(Product _product) {
            return this.setProductOverriddenAsProduct(_product);
        }

        @Override
        @RosettaAttribute(value="asset")
        @RuneAttribute(value="asset")
        public PositionBuilder setAsset(Asset _asset) {
            this.asset = _asset == null ? null : _asset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashBalance")
        @RuneAttribute(value="cashBalance")
        public PositionBuilder setCashBalance(Money _cashBalance) {
            this.cashBalance = _cashBalance == null ? null : _cashBalance.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public PositionBuilder setTradeReference(ReferenceWithMetaTradeState _tradeReference) {
            this.tradeReference = _tradeReference == null ? null : _tradeReference.toBuilder();
            return this;
        }

        @Override
        public PositionBuilder setTradeReferenceValue(TradeState _tradeReference) {
            this.getOrCreateTradeReference().setValue(_tradeReference);
            return this;
        }

        @Override
        public Position build() {
            return new PositionImpl(this);
        }

        @Override
        public PositionBuilder toBuilder() {
            return this;
        }

        @Override
        public PositionBuilder prune() {
            super.prune();
            if (this.product != null && !this.product.prune().hasData()) {
                this.product = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getProduct() != null && this.getProduct().hasData();
        }

        @Override
        public PositionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PositionBuilder o = (PositionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProduct(), (RosettaModelObjectBuilder)o.getProduct(), this::setProductOverriddenAsProduct);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Position _that = (Position)this.getType().cast(o);
            return Objects.equals(this.product, _that.getProduct());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PositionBuilder {product=" + this.product + '}' + " " + super.toString();
        }
    }

    public static interface PositionBuilder
    extends Position,
    PositionBase.PositionBaseBuilder {
        @Override
        public Product.ProductBuilder getOrCreateProduct();

        @Override
        public Product.ProductBuilder getProduct();

        @Override
        public PositionBuilder addPriceQuantity(PriceQuantity var1);

        @Override
        public PositionBuilder addPriceQuantity(PriceQuantity var1, int var2);

        @Override
        public PositionBuilder addPriceQuantity(List<? extends PriceQuantity> var1);

        @Override
        public PositionBuilder setPriceQuantity(List<? extends PriceQuantity> var1);

        @Override
        public PositionBuilder setProduct(Product var1);

        @Override
        public PositionBuilder setAsset(Asset var1);

        @Override
        public PositionBuilder setCashBalance(Money var1);

        @Override
        public PositionBuilder setTradeReference(ReferenceWithMetaTradeState var1);

        @Override
        public PositionBuilder setTradeReferenceValue(TradeState var1);

        public PositionBuilder setProductOverriddenAsProduct(Product var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.PriceQuantityBuilder.class, this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("product"), processor, Product.ProductBuilder.class, this.getProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("asset"), processor, Asset.AssetBuilder.class, (RosettaModelObjectBuilder)this.getAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashBalance"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getCashBalance(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder.class, (RosettaModelObjectBuilder)this.getTradeReference(), new AttributeMeta[0]);
        }

        @Override
        public PositionBuilder prune();
    }

    public static class PositionImpl
    extends PositionBase.PositionBaseImpl
    implements Position {
        private final Product product;

        protected PositionImpl(PositionBuilder builder) {
            super(builder);
            this.product = Optional.ofNullable(builder.getProduct()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public Product getProduct() {
            return this.product;
        }

        @Override
        public Position build() {
            return this;
        }

        @Override
        public PositionBuilder toBuilder() {
            PositionBuilder builder = Position.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PositionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProductOverriddenAsProduct);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Position _that = (Position)this.getType().cast(o);
            return Objects.equals(this.product, _that.getProduct());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Position {product=" + this.product + '}' + " " + super.toString();
        }
    }
}

