/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.ContractDetails;
import cdm.event.common.ExecutionDetails;
import cdm.event.common.PositionIdentifier;
import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaContractDetails;
import cdm.event.common.metafields.ReferenceWithMetaExecutionDetails;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.event.position.ContractBase;
import cdm.event.position.meta.CounterpartyPositionMeta;
import cdm.product.collateral.Collateral;
import cdm.product.collateral.metafields.ReferenceWithMetaCollateral;
import cdm.product.template.TradableProduct;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CounterpartyPosition", builder=CounterpartyPositionBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="CounterpartyPosition", model="cdm", builder=CounterpartyPositionBuilderImpl.class, version="7.0.0-dev.50")
public interface CounterpartyPosition
extends ContractBase {
    public static final CounterpartyPositionMeta metaData = new CounterpartyPositionMeta();

    public List<? extends PositionIdentifier> getPositionIdentifier();

    public LocalDateTime getOpenDateTime();

    public List<? extends ReferenceWithMetaTradeState> getTradeReference();

    public List<? extends Party> getParty();

    public List<? extends PartyRole> getPartyRole();

    public TradableProduct getPositionBase();

    @Override
    public CounterpartyPosition build();

    @Override
    public CounterpartyPositionBuilder toBuilder();

    public static CounterpartyPositionBuilder builder() {
        return new CounterpartyPositionBuilderImpl();
    }

    default public RosettaMetaData<? extends CounterpartyPosition> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CounterpartyPosition> getType() {
        return CounterpartyPosition.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("contractDetails"), processor, ReferenceWithMetaContractDetails.class, this.getContractDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionDetails"), processor, ReferenceWithMetaExecutionDetails.class, this.getExecutionDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateral"), processor, ReferenceWithMetaCollateral.class, this.getCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("positionIdentifier"), processor, PositionIdentifier.class, this.getPositionIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("openDateTime"), LocalDateTime.class, (Object)this.getOpenDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTradeState.class, this.getTradeReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.class, this.getPartyRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("positionBase"), processor, TradableProduct.class, this.getPositionBase(), new AttributeMeta[0]);
    }

    public static class CounterpartyPositionBuilderImpl
    extends ContractBase.ContractBaseBuilderImpl
    implements CounterpartyPositionBuilder {
        protected List<PositionIdentifier.PositionIdentifierBuilder> positionIdentifier = new ArrayList<PositionIdentifier.PositionIdentifierBuilder>();
        protected LocalDateTime openDateTime;
        protected List<ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder> tradeReference = new ArrayList<ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();
        protected List<PartyRole.PartyRoleBuilder> partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
        protected TradableProduct.TradableProductBuilder positionBase;

        @Override
        @RosettaAttribute(value="positionIdentifier")
        @RuneAttribute(value="positionIdentifier")
        public List<? extends PositionIdentifier.PositionIdentifierBuilder> getPositionIdentifier() {
            return this.positionIdentifier;
        }

        @Override
        public PositionIdentifier.PositionIdentifierBuilder getOrCreatePositionIdentifier(int index) {
            if (this.positionIdentifier == null) {
                this.positionIdentifier = new ArrayList<PositionIdentifier.PositionIdentifierBuilder>();
            }
            return (PositionIdentifier.PositionIdentifierBuilder)this.getIndex(this.positionIdentifier, index, () -> {
                PositionIdentifier.PositionIdentifierBuilder newPositionIdentifier = PositionIdentifier.builder();
                return newPositionIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="openDateTime")
        @RuneAttribute(value="openDateTime")
        public LocalDateTime getOpenDateTime() {
            return this.openDateTime;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public List<? extends ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder> getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeReference(int index) {
            if (this.tradeReference == null) {
                this.tradeReference = new ArrayList<ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder>();
            }
            return (ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder)this.getIndex(this.tradeReference, index, () -> {
                ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder newTradeReference = ReferenceWithMetaTradeState.builder();
                return newTradeReference;
            });
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole() {
            return this.partyRole;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int index) {
            if (this.partyRole == null) {
                this.partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
            }
            return (PartyRole.PartyRoleBuilder)this.getIndex(this.partyRole, index, () -> {
                PartyRole.PartyRoleBuilder newPartyRole = PartyRole.builder();
                return newPartyRole;
            });
        }

        @Override
        @RosettaAttribute(value="positionBase", isRequired=true)
        @RuneAttribute(value="positionBase", isRequired=true)
        public TradableProduct.TradableProductBuilder getPositionBase() {
            return this.positionBase;
        }

        @Override
        public TradableProduct.TradableProductBuilder getOrCreatePositionBase() {
            TradableProduct.TradableProductBuilder result = this.positionBase != null ? this.positionBase : (this.positionBase = TradableProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contractDetails")
        @RuneAttribute(value="contractDetails")
        public CounterpartyPositionBuilder setContractDetails(ReferenceWithMetaContractDetails _contractDetails) {
            this.contractDetails = _contractDetails == null ? null : _contractDetails.toBuilder();
            return this;
        }

        @Override
        public CounterpartyPositionBuilder setContractDetailsValue(ContractDetails _contractDetails) {
            this.getOrCreateContractDetails().setValue(_contractDetails);
            return this;
        }

        @Override
        @RosettaAttribute(value="executionDetails")
        @RuneAttribute(value="executionDetails")
        public CounterpartyPositionBuilder setExecutionDetails(ReferenceWithMetaExecutionDetails _executionDetails) {
            this.executionDetails = _executionDetails == null ? null : _executionDetails.toBuilder();
            return this;
        }

        @Override
        public CounterpartyPositionBuilder setExecutionDetailsValue(ExecutionDetails _executionDetails) {
            this.getOrCreateExecutionDetails().setValue(_executionDetails);
            return this;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public CounterpartyPositionBuilder setCollateral(ReferenceWithMetaCollateral _collateral) {
            this.collateral = _collateral == null ? null : _collateral.toBuilder();
            return this;
        }

        @Override
        public CounterpartyPositionBuilder setCollateralValue(Collateral _collateral) {
            this.getOrCreateCollateral().setValue(_collateral);
            return this;
        }

        @Override
        @RosettaAttribute(value="positionIdentifier")
        @RuneAttribute(value="positionIdentifier")
        public CounterpartyPositionBuilder addPositionIdentifier(PositionIdentifier _positionIdentifier) {
            if (_positionIdentifier != null) {
                this.positionIdentifier.add(_positionIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public CounterpartyPositionBuilder addPositionIdentifier(PositionIdentifier _positionIdentifier, int idx) {
            this.getIndex(this.positionIdentifier, idx, () -> _positionIdentifier.toBuilder());
            return this;
        }

        @Override
        public CounterpartyPositionBuilder addPositionIdentifier(List<? extends PositionIdentifier> positionIdentifiers) {
            if (positionIdentifiers != null) {
                for (PositionIdentifier positionIdentifier : positionIdentifiers) {
                    this.positionIdentifier.add(positionIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="positionIdentifier")
        public CounterpartyPositionBuilder setPositionIdentifier(List<? extends PositionIdentifier> positionIdentifiers) {
            this.positionIdentifier = positionIdentifiers == null ? new ArrayList<PositionIdentifier.PositionIdentifierBuilder>() : (List)positionIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="openDateTime")
        @RuneAttribute(value="openDateTime")
        public CounterpartyPositionBuilder setOpenDateTime(LocalDateTime _openDateTime) {
            this.openDateTime = _openDateTime == null ? null : _openDateTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public CounterpartyPositionBuilder addTradeReference(ReferenceWithMetaTradeState _tradeReference) {
            if (_tradeReference != null) {
                this.tradeReference.add(_tradeReference.toBuilder());
            }
            return this;
        }

        @Override
        public CounterpartyPositionBuilder addTradeReference(ReferenceWithMetaTradeState _tradeReference, int idx) {
            this.getIndex(this.tradeReference, idx, () -> _tradeReference.toBuilder());
            return this;
        }

        @Override
        public CounterpartyPositionBuilder addTradeReferenceValue(TradeState _tradeReference) {
            this.getOrCreateTradeReference(-1).setValue(_tradeReference.toBuilder());
            return this;
        }

        @Override
        public CounterpartyPositionBuilder addTradeReferenceValue(TradeState _tradeReference, int idx) {
            this.getOrCreateTradeReference(idx).setValue(_tradeReference.toBuilder());
            return this;
        }

        @Override
        public CounterpartyPositionBuilder addTradeReference(List<? extends ReferenceWithMetaTradeState> tradeReferences) {
            if (tradeReferences != null) {
                for (ReferenceWithMetaTradeState referenceWithMetaTradeState : tradeReferences) {
                    this.tradeReference.add(referenceWithMetaTradeState.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeReference")
        public CounterpartyPositionBuilder setTradeReference(List<? extends ReferenceWithMetaTradeState> tradeReferences) {
            this.tradeReference = tradeReferences == null ? new ArrayList<ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder>() : (List)tradeReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CounterpartyPositionBuilder addTradeReferenceValue(List<? extends TradeState> tradeReferences) {
            if (tradeReferences != null) {
                for (TradeState tradeState : tradeReferences) {
                    this.addTradeReferenceValue(tradeState);
                }
            }
            return this;
        }

        @Override
        public CounterpartyPositionBuilder setTradeReferenceValue(List<? extends TradeState> tradeReferences) {
            this.tradeReference.clear();
            if (tradeReferences != null) {
                tradeReferences.forEach(this::addTradeReferenceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public CounterpartyPositionBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public CounterpartyPositionBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public CounterpartyPositionBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public CounterpartyPositionBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public CounterpartyPositionBuilder addPartyRole(PartyRole _partyRole) {
            if (_partyRole != null) {
                this.partyRole.add(_partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public CounterpartyPositionBuilder addPartyRole(PartyRole _partyRole, int idx) {
            this.getIndex(this.partyRole, idx, () -> _partyRole.toBuilder());
            return this;
        }

        @Override
        public CounterpartyPositionBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyRole")
        public CounterpartyPositionBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList<PartyRole.PartyRoleBuilder>() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="positionBase", isRequired=true)
        @RuneAttribute(value="positionBase", isRequired=true)
        public CounterpartyPositionBuilder setPositionBase(TradableProduct _positionBase) {
            this.positionBase = _positionBase == null ? null : _positionBase.toBuilder();
            return this;
        }

        @Override
        public CounterpartyPosition build() {
            return new CounterpartyPositionImpl(this);
        }

        @Override
        public CounterpartyPositionBuilder toBuilder() {
            return this;
        }

        @Override
        public CounterpartyPositionBuilder prune() {
            super.prune();
            this.positionIdentifier = this.positionIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.tradeReference = this.tradeReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyRole = this.partyRole.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.positionBase != null && !this.positionBase.prune().hasData()) {
                this.positionBase = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPositionIdentifier() != null && this.getPositionIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOpenDateTime() != null) {
                return true;
            }
            if (this.getTradeReference() != null && this.getTradeReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyRole() != null && this.getPartyRole().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPositionBase() != null && this.getPositionBase().hasData();
        }

        @Override
        public CounterpartyPositionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CounterpartyPositionBuilder o = (CounterpartyPositionBuilder)other;
            merger.mergeRosetta(this.getPositionIdentifier(), o.getPositionIdentifier(), this::getOrCreatePositionIdentifier);
            merger.mergeRosetta(this.getTradeReference(), o.getTradeReference(), this::getOrCreateTradeReference);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeRosetta(this.getPartyRole(), o.getPartyRole(), this::getOrCreatePartyRole);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPositionBase(), (RosettaModelObjectBuilder)o.getPositionBase(), this::setPositionBase);
            merger.mergeBasic((Object)this.getOpenDateTime(), (Object)o.getOpenDateTime(), this::setOpenDateTime, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CounterpartyPosition _that = (CounterpartyPosition)this.getType().cast(o);
            if (!ListEquals.listEquals(this.positionIdentifier, _that.getPositionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.openDateTime, _that.getOpenDateTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeReference, _that.getTradeReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            return Objects.equals(this.positionBase, _that.getPositionBase());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.positionIdentifier != null ? this.positionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.openDateTime != null ? this.openDateTime.hashCode() : 0);
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.positionBase != null ? this.positionBase.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CounterpartyPositionBuilder {positionIdentifier=" + this.positionIdentifier + ", openDateTime=" + this.openDateTime + ", tradeReference=" + this.tradeReference + ", party=" + this.party + ", partyRole=" + this.partyRole + ", positionBase=" + this.positionBase + '}' + " " + super.toString();
        }
    }

    public static interface CounterpartyPositionBuilder
    extends CounterpartyPosition,
    ContractBase.ContractBaseBuilder {
        public PositionIdentifier.PositionIdentifierBuilder getOrCreatePositionIdentifier(int var1);

        public List<? extends PositionIdentifier.PositionIdentifierBuilder> getPositionIdentifier();

        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeReference(int var1);

        public List<? extends ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder> getTradeReference();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int var1);

        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole();

        public TradableProduct.TradableProductBuilder getOrCreatePositionBase();

        @Override
        public TradableProduct.TradableProductBuilder getPositionBase();

        @Override
        public CounterpartyPositionBuilder setContractDetails(ReferenceWithMetaContractDetails var1);

        @Override
        public CounterpartyPositionBuilder setContractDetailsValue(ContractDetails var1);

        @Override
        public CounterpartyPositionBuilder setExecutionDetails(ReferenceWithMetaExecutionDetails var1);

        @Override
        public CounterpartyPositionBuilder setExecutionDetailsValue(ExecutionDetails var1);

        @Override
        public CounterpartyPositionBuilder setCollateral(ReferenceWithMetaCollateral var1);

        @Override
        public CounterpartyPositionBuilder setCollateralValue(Collateral var1);

        public CounterpartyPositionBuilder addPositionIdentifier(PositionIdentifier var1);

        public CounterpartyPositionBuilder addPositionIdentifier(PositionIdentifier var1, int var2);

        public CounterpartyPositionBuilder addPositionIdentifier(List<? extends PositionIdentifier> var1);

        public CounterpartyPositionBuilder setPositionIdentifier(List<? extends PositionIdentifier> var1);

        public CounterpartyPositionBuilder setOpenDateTime(LocalDateTime var1);

        public CounterpartyPositionBuilder addTradeReference(ReferenceWithMetaTradeState var1);

        public CounterpartyPositionBuilder addTradeReference(ReferenceWithMetaTradeState var1, int var2);

        public CounterpartyPositionBuilder addTradeReferenceValue(TradeState var1);

        public CounterpartyPositionBuilder addTradeReferenceValue(TradeState var1, int var2);

        public CounterpartyPositionBuilder addTradeReference(List<? extends ReferenceWithMetaTradeState> var1);

        public CounterpartyPositionBuilder setTradeReference(List<? extends ReferenceWithMetaTradeState> var1);

        public CounterpartyPositionBuilder addTradeReferenceValue(List<? extends TradeState> var1);

        public CounterpartyPositionBuilder setTradeReferenceValue(List<? extends TradeState> var1);

        public CounterpartyPositionBuilder addParty(Party var1);

        public CounterpartyPositionBuilder addParty(Party var1, int var2);

        public CounterpartyPositionBuilder addParty(List<? extends Party> var1);

        public CounterpartyPositionBuilder setParty(List<? extends Party> var1);

        public CounterpartyPositionBuilder addPartyRole(PartyRole var1);

        public CounterpartyPositionBuilder addPartyRole(PartyRole var1, int var2);

        public CounterpartyPositionBuilder addPartyRole(List<? extends PartyRole> var1);

        public CounterpartyPositionBuilder setPartyRole(List<? extends PartyRole> var1);

        public CounterpartyPositionBuilder setPositionBase(TradableProduct var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("contractDetails"), processor, ReferenceWithMetaContractDetails.ReferenceWithMetaContractDetailsBuilder.class, (RosettaModelObjectBuilder)this.getContractDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionDetails"), processor, ReferenceWithMetaExecutionDetails.ReferenceWithMetaExecutionDetailsBuilder.class, (RosettaModelObjectBuilder)this.getExecutionDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateral"), processor, ReferenceWithMetaCollateral.ReferenceWithMetaCollateralBuilder.class, (RosettaModelObjectBuilder)this.getCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("positionIdentifier"), processor, PositionIdentifier.PositionIdentifierBuilder.class, this.getPositionIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("openDateTime"), LocalDateTime.class, (Object)this.getOpenDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder.class, this.getTradeReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("positionBase"), processor, TradableProduct.TradableProductBuilder.class, this.getPositionBase(), new AttributeMeta[0]);
        }

        @Override
        public CounterpartyPositionBuilder prune();
    }

    public static class CounterpartyPositionImpl
    extends ContractBase.ContractBaseImpl
    implements CounterpartyPosition {
        private final List<? extends PositionIdentifier> positionIdentifier;
        private final LocalDateTime openDateTime;
        private final List<? extends ReferenceWithMetaTradeState> tradeReference;
        private final List<? extends Party> party;
        private final List<? extends PartyRole> partyRole;
        private final TradableProduct positionBase;

        protected CounterpartyPositionImpl(CounterpartyPositionBuilder builder) {
            super(builder);
            this.positionIdentifier = Optional.ofNullable(builder.getPositionIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.openDateTime = builder.getOpenDateTime();
            this.tradeReference = Optional.ofNullable(builder.getTradeReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyRole = Optional.ofNullable(builder.getPartyRole()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.positionBase = Optional.ofNullable(builder.getPositionBase()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="positionIdentifier")
        @RuneAttribute(value="positionIdentifier")
        public List<? extends PositionIdentifier> getPositionIdentifier() {
            return this.positionIdentifier;
        }

        @Override
        @RosettaAttribute(value="openDateTime")
        @RuneAttribute(value="openDateTime")
        public LocalDateTime getOpenDateTime() {
            return this.openDateTime;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public List<? extends ReferenceWithMetaTradeState> getTradeReference() {
            return this.tradeReference;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public List<? extends PartyRole> getPartyRole() {
            return this.partyRole;
        }

        @Override
        @RosettaAttribute(value="positionBase", isRequired=true)
        @RuneAttribute(value="positionBase", isRequired=true)
        public TradableProduct getPositionBase() {
            return this.positionBase;
        }

        @Override
        public CounterpartyPosition build() {
            return this;
        }

        @Override
        public CounterpartyPositionBuilder toBuilder() {
            CounterpartyPositionBuilder builder = CounterpartyPosition.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CounterpartyPositionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPositionIdentifier()).ifPresent(builder::setPositionIdentifier);
            Optional.ofNullable(this.getOpenDateTime()).ifPresent(builder::setOpenDateTime);
            Optional.ofNullable(this.getTradeReference()).ifPresent(builder::setTradeReference);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getPartyRole()).ifPresent(builder::setPartyRole);
            Optional.ofNullable(this.getPositionBase()).ifPresent(builder::setPositionBase);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CounterpartyPosition _that = (CounterpartyPosition)this.getType().cast(o);
            if (!ListEquals.listEquals(this.positionIdentifier, _that.getPositionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.openDateTime, _that.getOpenDateTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeReference, _that.getTradeReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            return Objects.equals(this.positionBase, _that.getPositionBase());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.positionIdentifier != null ? this.positionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.openDateTime != null ? this.openDateTime.hashCode() : 0);
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.positionBase != null ? this.positionBase.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CounterpartyPosition {positionIdentifier=" + this.positionIdentifier + ", openDateTime=" + this.openDateTime + ", tradeReference=" + this.tradeReference + ", party=" + this.party + ", partyRole=" + this.partyRole + ", positionBase=" + this.positionBase + '}' + " " + super.toString();
        }
    }
}

