/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.CorporateAction;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CorporateActionDividendObservation")
@ImplementedBy(value=Default.class)
public interface CorporateActionDividendObservation
extends Validator<CorporateAction> {
    public static final String NAME = "CorporateActionDividendObservation";
    public static final String DEFINITION = "if dividendObservation exists then dividendObservation -> priceType = PriceTypeEnum -> Dividend";

    public static class NoOp
    implements CorporateActionDividendObservation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CorporateAction corporateAction) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CorporateActionDividendObservation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CorporateAction corporateAction) {
            ComparisonResult result = this.executeDataRule(corporateAction);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CorporateActionDividendObservation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CorporateAction", (RosettaPath)path, (String)CorporateActionDividendObservation.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CorporateActionDividendObservation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CorporateAction", (RosettaPath)path, (String)CorporateActionDividendObservation.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CorporateAction corporateAction) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)corporateAction).map("getDividendObservation", _corporateAction -> _corporateAction.getDividendObservation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)corporateAction).map("getDividendObservation", _corporateAction -> _corporateAction.getDividendObservation()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.DIVIDEND)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

