/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.AdjustmentFactor;
import cdm.event.common.CorporateActionTypeEnum;
import cdm.event.common.meta.CorporateActionMeta;
import cdm.observable.asset.InformationSource;
import cdm.observable.asset.PriceSchedule;
import cdm.product.template.Underlier;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CorporateAction", builder=CorporateActionBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="CorporateAction", model="cdm", builder=CorporateActionBuilderImpl.class, version="7.0.0-dev.50")
public interface CorporateAction
extends RosettaModelObject {
    public static final CorporateActionMeta metaData = new CorporateActionMeta();

    public CorporateActionTypeEnum getCorporateActionType();

    public Date getExDate();

    public Date getPayDate();

    public Date getRecordDate();

    public Date getAnnouncementDate();

    public Underlier getUnderlier();

    public AdjustmentFactor getAdjustmentFactor();

    public InformationSource getInformationSource();

    public PriceSchedule getDividendObservation();

    public String getBespokeEventDescription();

    public CorporateAction build();

    public CorporateActionBuilder toBuilder();

    public static CorporateActionBuilder builder() {
        return new CorporateActionBuilderImpl();
    }

    default public RosettaMetaData<? extends CorporateAction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CorporateAction> getType() {
        return CorporateAction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("corporateActionType"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exDate"), Date.class, (Object)this.getExDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("payDate"), Date.class, (Object)this.getPayDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("recordDate"), Date.class, (Object)this.getRecordDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("announcementDate"), Date.class, (Object)this.getAnnouncementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlier"), processor, Underlier.class, this.getUnderlier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustmentFactor"), processor, AdjustmentFactor.class, this.getAdjustmentFactor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendObservation"), processor, PriceSchedule.class, this.getDividendObservation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bespokeEventDescription"), String.class, (Object)this.getBespokeEventDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CorporateActionBuilderImpl
    implements CorporateActionBuilder {
        protected CorporateActionTypeEnum corporateActionType;
        protected Date exDate;
        protected Date payDate;
        protected Date recordDate;
        protected Date announcementDate;
        protected Underlier.UnderlierBuilder underlier;
        protected AdjustmentFactor.AdjustmentFactorBuilder adjustmentFactor;
        protected InformationSource.InformationSourceBuilder informationSource;
        protected PriceSchedule.PriceScheduleBuilder dividendObservation;
        protected String bespokeEventDescription;

        @Override
        @RosettaAttribute(value="corporateActionType", isRequired=true)
        @RuneAttribute(value="corporateActionType", isRequired=true)
        public CorporateActionTypeEnum getCorporateActionType() {
            return this.corporateActionType;
        }

        @Override
        @RosettaAttribute(value="exDate", isRequired=true)
        @RuneAttribute(value="exDate", isRequired=true)
        public Date getExDate() {
            return this.exDate;
        }

        @Override
        @RosettaAttribute(value="payDate", isRequired=true)
        @RuneAttribute(value="payDate", isRequired=true)
        public Date getPayDate() {
            return this.payDate;
        }

        @Override
        @RosettaAttribute(value="recordDate")
        @RuneAttribute(value="recordDate")
        public Date getRecordDate() {
            return this.recordDate;
        }

        @Override
        @RosettaAttribute(value="announcementDate")
        @RuneAttribute(value="announcementDate")
        public Date getAnnouncementDate() {
            return this.announcementDate;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Underlier.UnderlierBuilder getUnderlier() {
            return this.underlier;
        }

        @Override
        public Underlier.UnderlierBuilder getOrCreateUnderlier() {
            Underlier.UnderlierBuilder result = this.underlier != null ? this.underlier : (this.underlier = Underlier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustmentFactor")
        @RuneAttribute(value="adjustmentFactor")
        public AdjustmentFactor.AdjustmentFactorBuilder getAdjustmentFactor() {
            return this.adjustmentFactor;
        }

        @Override
        public AdjustmentFactor.AdjustmentFactorBuilder getOrCreateAdjustmentFactor() {
            AdjustmentFactor.AdjustmentFactorBuilder result = this.adjustmentFactor != null ? this.adjustmentFactor : (this.adjustmentFactor = AdjustmentFactor.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public InformationSource.InformationSourceBuilder getInformationSource() {
            return this.informationSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource() {
            InformationSource.InformationSourceBuilder result = this.informationSource != null ? this.informationSource : (this.informationSource = InformationSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dividendObservation")
        @RuneAttribute(value="dividendObservation")
        public PriceSchedule.PriceScheduleBuilder getDividendObservation() {
            return this.dividendObservation;
        }

        @Override
        public PriceSchedule.PriceScheduleBuilder getOrCreateDividendObservation() {
            PriceSchedule.PriceScheduleBuilder result = this.dividendObservation != null ? this.dividendObservation : (this.dividendObservation = PriceSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="bespokeEventDescription")
        @RuneAttribute(value="bespokeEventDescription")
        public String getBespokeEventDescription() {
            return this.bespokeEventDescription;
        }

        @Override
        @RosettaAttribute(value="corporateActionType", isRequired=true)
        @RuneAttribute(value="corporateActionType", isRequired=true)
        public CorporateActionBuilder setCorporateActionType(CorporateActionTypeEnum _corporateActionType) {
            this.corporateActionType = _corporateActionType == null ? null : _corporateActionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="exDate", isRequired=true)
        @RuneAttribute(value="exDate", isRequired=true)
        public CorporateActionBuilder setExDate(Date _exDate) {
            this.exDate = _exDate == null ? null : _exDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="payDate", isRequired=true)
        @RuneAttribute(value="payDate", isRequired=true)
        public CorporateActionBuilder setPayDate(Date _payDate) {
            this.payDate = _payDate == null ? null : _payDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="recordDate")
        @RuneAttribute(value="recordDate")
        public CorporateActionBuilder setRecordDate(Date _recordDate) {
            this.recordDate = _recordDate == null ? null : _recordDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="announcementDate")
        @RuneAttribute(value="announcementDate")
        public CorporateActionBuilder setAnnouncementDate(Date _announcementDate) {
            this.announcementDate = _announcementDate == null ? null : _announcementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public CorporateActionBuilder setUnderlier(Underlier _underlier) {
            this.underlier = _underlier == null ? null : _underlier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustmentFactor")
        @RuneAttribute(value="adjustmentFactor")
        public CorporateActionBuilder setAdjustmentFactor(AdjustmentFactor _adjustmentFactor) {
            this.adjustmentFactor = _adjustmentFactor == null ? null : _adjustmentFactor.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public CorporateActionBuilder setInformationSource(InformationSource _informationSource) {
            this.informationSource = _informationSource == null ? null : _informationSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendObservation")
        @RuneAttribute(value="dividendObservation")
        public CorporateActionBuilder setDividendObservation(PriceSchedule _dividendObservation) {
            this.dividendObservation = _dividendObservation == null ? null : _dividendObservation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="bespokeEventDescription")
        @RuneAttribute(value="bespokeEventDescription")
        public CorporateActionBuilder setBespokeEventDescription(String _bespokeEventDescription) {
            this.bespokeEventDescription = _bespokeEventDescription == null ? null : _bespokeEventDescription;
            return this;
        }

        @Override
        public CorporateAction build() {
            return new CorporateActionImpl(this);
        }

        @Override
        public CorporateActionBuilder toBuilder() {
            return this;
        }

        @Override
        public CorporateActionBuilder prune() {
            if (this.underlier != null && !this.underlier.prune().hasData()) {
                this.underlier = null;
            }
            if (this.adjustmentFactor != null && !this.adjustmentFactor.prune().hasData()) {
                this.adjustmentFactor = null;
            }
            if (this.informationSource != null && !this.informationSource.prune().hasData()) {
                this.informationSource = null;
            }
            if (this.dividendObservation != null && !this.dividendObservation.prune().hasData()) {
                this.dividendObservation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCorporateActionType() != null) {
                return true;
            }
            if (this.getExDate() != null) {
                return true;
            }
            if (this.getPayDate() != null) {
                return true;
            }
            if (this.getRecordDate() != null) {
                return true;
            }
            if (this.getAnnouncementDate() != null) {
                return true;
            }
            if (this.getUnderlier() != null && this.getUnderlier().hasData()) {
                return true;
            }
            if (this.getAdjustmentFactor() != null && this.getAdjustmentFactor().hasData()) {
                return true;
            }
            if (this.getInformationSource() != null && this.getInformationSource().hasData()) {
                return true;
            }
            if (this.getDividendObservation() != null && this.getDividendObservation().hasData()) {
                return true;
            }
            return this.getBespokeEventDescription() != null;
        }

        public CorporateActionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CorporateActionBuilder o = (CorporateActionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlier(), (RosettaModelObjectBuilder)o.getUnderlier(), this::setUnderlier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdjustmentFactor(), (RosettaModelObjectBuilder)o.getAdjustmentFactor(), this::setAdjustmentFactor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInformationSource(), (RosettaModelObjectBuilder)o.getInformationSource(), this::setInformationSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendObservation(), (RosettaModelObjectBuilder)o.getDividendObservation(), this::setDividendObservation);
            merger.mergeBasic((Object)this.getCorporateActionType(), (Object)o.getCorporateActionType(), this::setCorporateActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExDate(), (Object)o.getExDate(), this::setExDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPayDate(), (Object)o.getPayDate(), this::setPayDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRecordDate(), (Object)o.getRecordDate(), this::setRecordDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAnnouncementDate(), (Object)o.getAnnouncementDate(), this::setAnnouncementDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBespokeEventDescription(), (Object)o.getBespokeEventDescription(), this::setBespokeEventDescription, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CorporateAction _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.corporateActionType, (Object)_that.getCorporateActionType())) {
                return false;
            }
            if (!Objects.equals(this.exDate, _that.getExDate())) {
                return false;
            }
            if (!Objects.equals(this.payDate, _that.getPayDate())) {
                return false;
            }
            if (!Objects.equals(this.recordDate, _that.getRecordDate())) {
                return false;
            }
            if (!Objects.equals(this.announcementDate, _that.getAnnouncementDate())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals(this.adjustmentFactor, _that.getAdjustmentFactor())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.dividendObservation, _that.getDividendObservation())) {
                return false;
            }
            return Objects.equals(this.bespokeEventDescription, _that.getBespokeEventDescription());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.corporateActionType != null ? ((Object)((Object)this.corporateActionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exDate != null ? this.exDate.hashCode() : 0);
            _result = 31 * _result + (this.payDate != null ? this.payDate.hashCode() : 0);
            _result = 31 * _result + (this.recordDate != null ? this.recordDate.hashCode() : 0);
            _result = 31 * _result + (this.announcementDate != null ? this.announcementDate.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.adjustmentFactor != null ? this.adjustmentFactor.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.dividendObservation != null ? this.dividendObservation.hashCode() : 0);
            _result = 31 * _result + (this.bespokeEventDescription != null ? this.bespokeEventDescription.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CorporateActionBuilder {corporateActionType=" + (Object)((Object)this.corporateActionType) + ", exDate=" + this.exDate + ", payDate=" + this.payDate + ", recordDate=" + this.recordDate + ", announcementDate=" + this.announcementDate + ", underlier=" + this.underlier + ", adjustmentFactor=" + this.adjustmentFactor + ", informationSource=" + this.informationSource + ", dividendObservation=" + this.dividendObservation + ", bespokeEventDescription=" + this.bespokeEventDescription + '}';
        }
    }

    public static interface CorporateActionBuilder
    extends CorporateAction,
    RosettaModelObjectBuilder {
        public Underlier.UnderlierBuilder getOrCreateUnderlier();

        @Override
        public Underlier.UnderlierBuilder getUnderlier();

        public AdjustmentFactor.AdjustmentFactorBuilder getOrCreateAdjustmentFactor();

        @Override
        public AdjustmentFactor.AdjustmentFactorBuilder getAdjustmentFactor();

        public InformationSource.InformationSourceBuilder getOrCreateInformationSource();

        @Override
        public InformationSource.InformationSourceBuilder getInformationSource();

        public PriceSchedule.PriceScheduleBuilder getOrCreateDividendObservation();

        @Override
        public PriceSchedule.PriceScheduleBuilder getDividendObservation();

        public CorporateActionBuilder setCorporateActionType(CorporateActionTypeEnum var1);

        public CorporateActionBuilder setExDate(Date var1);

        public CorporateActionBuilder setPayDate(Date var1);

        public CorporateActionBuilder setRecordDate(Date var1);

        public CorporateActionBuilder setAnnouncementDate(Date var1);

        public CorporateActionBuilder setUnderlier(Underlier var1);

        public CorporateActionBuilder setAdjustmentFactor(AdjustmentFactor var1);

        public CorporateActionBuilder setInformationSource(InformationSource var1);

        public CorporateActionBuilder setDividendObservation(PriceSchedule var1);

        public CorporateActionBuilder setBespokeEventDescription(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("corporateActionType"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exDate"), Date.class, (Object)this.getExDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("payDate"), Date.class, (Object)this.getPayDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("recordDate"), Date.class, (Object)this.getRecordDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("announcementDate"), Date.class, (Object)this.getAnnouncementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlier"), processor, Underlier.UnderlierBuilder.class, this.getUnderlier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustmentFactor"), processor, AdjustmentFactor.AdjustmentFactorBuilder.class, this.getAdjustmentFactor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.InformationSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendObservation"), processor, PriceSchedule.PriceScheduleBuilder.class, this.getDividendObservation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bespokeEventDescription"), String.class, (Object)this.getBespokeEventDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CorporateActionBuilder prune();
    }

    public static class CorporateActionImpl
    implements CorporateAction {
        private final CorporateActionTypeEnum corporateActionType;
        private final Date exDate;
        private final Date payDate;
        private final Date recordDate;
        private final Date announcementDate;
        private final Underlier underlier;
        private final AdjustmentFactor adjustmentFactor;
        private final InformationSource informationSource;
        private final PriceSchedule dividendObservation;
        private final String bespokeEventDescription;

        protected CorporateActionImpl(CorporateActionBuilder builder) {
            this.corporateActionType = builder.getCorporateActionType();
            this.exDate = builder.getExDate();
            this.payDate = builder.getPayDate();
            this.recordDate = builder.getRecordDate();
            this.announcementDate = builder.getAnnouncementDate();
            this.underlier = Optional.ofNullable(builder.getUnderlier()).map(f -> f.build()).orElse(null);
            this.adjustmentFactor = Optional.ofNullable(builder.getAdjustmentFactor()).map(f -> f.build()).orElse(null);
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).map(f -> f.build()).orElse(null);
            this.dividendObservation = Optional.ofNullable(builder.getDividendObservation()).map(f -> f.build()).orElse(null);
            this.bespokeEventDescription = builder.getBespokeEventDescription();
        }

        @Override
        @RosettaAttribute(value="corporateActionType", isRequired=true)
        @RuneAttribute(value="corporateActionType", isRequired=true)
        public CorporateActionTypeEnum getCorporateActionType() {
            return this.corporateActionType;
        }

        @Override
        @RosettaAttribute(value="exDate", isRequired=true)
        @RuneAttribute(value="exDate", isRequired=true)
        public Date getExDate() {
            return this.exDate;
        }

        @Override
        @RosettaAttribute(value="payDate", isRequired=true)
        @RuneAttribute(value="payDate", isRequired=true)
        public Date getPayDate() {
            return this.payDate;
        }

        @Override
        @RosettaAttribute(value="recordDate")
        @RuneAttribute(value="recordDate")
        public Date getRecordDate() {
            return this.recordDate;
        }

        @Override
        @RosettaAttribute(value="announcementDate")
        @RuneAttribute(value="announcementDate")
        public Date getAnnouncementDate() {
            return this.announcementDate;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Underlier getUnderlier() {
            return this.underlier;
        }

        @Override
        @RosettaAttribute(value="adjustmentFactor")
        @RuneAttribute(value="adjustmentFactor")
        public AdjustmentFactor getAdjustmentFactor() {
            return this.adjustmentFactor;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public InformationSource getInformationSource() {
            return this.informationSource;
        }

        @Override
        @RosettaAttribute(value="dividendObservation")
        @RuneAttribute(value="dividendObservation")
        public PriceSchedule getDividendObservation() {
            return this.dividendObservation;
        }

        @Override
        @RosettaAttribute(value="bespokeEventDescription")
        @RuneAttribute(value="bespokeEventDescription")
        public String getBespokeEventDescription() {
            return this.bespokeEventDescription;
        }

        @Override
        public CorporateAction build() {
            return this;
        }

        @Override
        public CorporateActionBuilder toBuilder() {
            CorporateActionBuilder builder = CorporateAction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CorporateActionBuilder builder) {
            Optional.ofNullable(this.getCorporateActionType()).ifPresent(builder::setCorporateActionType);
            Optional.ofNullable(this.getExDate()).ifPresent(builder::setExDate);
            Optional.ofNullable(this.getPayDate()).ifPresent(builder::setPayDate);
            Optional.ofNullable(this.getRecordDate()).ifPresent(builder::setRecordDate);
            Optional.ofNullable(this.getAnnouncementDate()).ifPresent(builder::setAnnouncementDate);
            Optional.ofNullable(this.getUnderlier()).ifPresent(builder::setUnderlier);
            Optional.ofNullable(this.getAdjustmentFactor()).ifPresent(builder::setAdjustmentFactor);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
            Optional.ofNullable(this.getDividendObservation()).ifPresent(builder::setDividendObservation);
            Optional.ofNullable(this.getBespokeEventDescription()).ifPresent(builder::setBespokeEventDescription);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CorporateAction _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.corporateActionType, (Object)_that.getCorporateActionType())) {
                return false;
            }
            if (!Objects.equals(this.exDate, _that.getExDate())) {
                return false;
            }
            if (!Objects.equals(this.payDate, _that.getPayDate())) {
                return false;
            }
            if (!Objects.equals(this.recordDate, _that.getRecordDate())) {
                return false;
            }
            if (!Objects.equals(this.announcementDate, _that.getAnnouncementDate())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals(this.adjustmentFactor, _that.getAdjustmentFactor())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.dividendObservation, _that.getDividendObservation())) {
                return false;
            }
            return Objects.equals(this.bespokeEventDescription, _that.getBespokeEventDescription());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.corporateActionType != null ? ((Object)((Object)this.corporateActionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.exDate != null ? this.exDate.hashCode() : 0);
            _result = 31 * _result + (this.payDate != null ? this.payDate.hashCode() : 0);
            _result = 31 * _result + (this.recordDate != null ? this.recordDate.hashCode() : 0);
            _result = 31 * _result + (this.announcementDate != null ? this.announcementDate.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.adjustmentFactor != null ? this.adjustmentFactor.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.dividendObservation != null ? this.dividendObservation.hashCode() : 0);
            _result = 31 * _result + (this.bespokeEventDescription != null ? this.bespokeEventDescription.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CorporateAction {corporateActionType=" + (Object)((Object)this.corporateActionType) + ", exDate=" + this.exDate + ", payDate=" + this.payDate + ", recordDate=" + this.recordDate + ", announcementDate=" + this.announcementDate + ", underlier=" + this.underlier + ", adjustmentFactor=" + this.adjustmentFactor + ", informationSource=" + this.informationSource + ", dividendObservation=" + this.dividendObservation + ", bespokeEventDescription=" + this.bespokeEventDescription + '}';
        }
    }
}

