/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.event.common.CollateralBalance;
import cdm.event.common.CollateralPosition;
import cdm.event.common.meta.CollateralPortfolioMeta;
import cdm.legaldocumentation.common.LegalAgreement;
import cdm.legaldocumentation.common.metafields.ReferenceWithMetaLegalAgreement;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CollateralPortfolio", builder=CollateralPortfolioBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="CollateralPortfolio", model="cdm", builder=CollateralPortfolioBuilderImpl.class, version="7.0.0-dev.50")
public interface CollateralPortfolio
extends RosettaModelObject,
GlobalKey {
    public static final CollateralPortfolioMeta metaData = new CollateralPortfolioMeta();

    public Identifier getPortfolioIdentifier();

    public List<? extends CollateralPosition> getCollateralPosition();

    public List<? extends CollateralBalance> getCollateralBalance();

    public ReferenceWithMetaLegalAgreement getLegalAgreement();

    public MetaFields getMeta();

    public CollateralPortfolio build();

    public CollateralPortfolioBuilder toBuilder();

    public static CollateralPortfolioBuilder builder() {
        return new CollateralPortfolioBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralPortfolio> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralPortfolio> getType() {
        return CollateralPortfolio.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("portfolioIdentifier"), processor, Identifier.class, this.getPortfolioIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralPosition"), processor, CollateralPosition.class, this.getCollateralPosition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralBalance"), processor, CollateralBalance.class, this.getCollateralBalance(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalAgreement"), processor, ReferenceWithMetaLegalAgreement.class, this.getLegalAgreement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class CollateralPortfolioBuilderImpl
    implements CollateralPortfolioBuilder {
        protected Identifier.IdentifierBuilder portfolioIdentifier;
        protected List<CollateralPosition.CollateralPositionBuilder> collateralPosition = new ArrayList<CollateralPosition.CollateralPositionBuilder>();
        protected List<CollateralBalance.CollateralBalanceBuilder> collateralBalance = new ArrayList<CollateralBalance.CollateralBalanceBuilder>();
        protected ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder legalAgreement;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="portfolioIdentifier")
        @RuneAttribute(value="portfolioIdentifier")
        public Identifier.IdentifierBuilder getPortfolioIdentifier() {
            return this.portfolioIdentifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreatePortfolioIdentifier() {
            Identifier.IdentifierBuilder result = this.portfolioIdentifier != null ? this.portfolioIdentifier : (this.portfolioIdentifier = Identifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralPosition")
        @RuneAttribute(value="collateralPosition")
        public List<? extends CollateralPosition.CollateralPositionBuilder> getCollateralPosition() {
            return this.collateralPosition;
        }

        @Override
        public CollateralPosition.CollateralPositionBuilder getOrCreateCollateralPosition(int index) {
            if (this.collateralPosition == null) {
                this.collateralPosition = new ArrayList<CollateralPosition.CollateralPositionBuilder>();
            }
            return (CollateralPosition.CollateralPositionBuilder)this.getIndex(this.collateralPosition, index, () -> {
                CollateralPosition.CollateralPositionBuilder newCollateralPosition = CollateralPosition.builder();
                return newCollateralPosition;
            });
        }

        @Override
        @RosettaAttribute(value="collateralBalance")
        @RuneAttribute(value="collateralBalance")
        public List<? extends CollateralBalance.CollateralBalanceBuilder> getCollateralBalance() {
            return this.collateralBalance;
        }

        @Override
        public CollateralBalance.CollateralBalanceBuilder getOrCreateCollateralBalance(int index) {
            if (this.collateralBalance == null) {
                this.collateralBalance = new ArrayList<CollateralBalance.CollateralBalanceBuilder>();
            }
            return (CollateralBalance.CollateralBalanceBuilder)this.getIndex(this.collateralBalance, index, () -> {
                CollateralBalance.CollateralBalanceBuilder newCollateralBalance = CollateralBalance.builder();
                return newCollateralBalance;
            });
        }

        @Override
        @RosettaAttribute(value="legalAgreement")
        @RuneAttribute(value="legalAgreement")
        public ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder getLegalAgreement() {
            return this.legalAgreement;
        }

        @Override
        public ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder getOrCreateLegalAgreement() {
            ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder result = this.legalAgreement != null ? this.legalAgreement : (this.legalAgreement = ReferenceWithMetaLegalAgreement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="portfolioIdentifier")
        @RuneAttribute(value="portfolioIdentifier")
        public CollateralPortfolioBuilder setPortfolioIdentifier(Identifier _portfolioIdentifier) {
            this.portfolioIdentifier = _portfolioIdentifier == null ? null : _portfolioIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPosition")
        @RuneAttribute(value="collateralPosition")
        public CollateralPortfolioBuilder addCollateralPosition(CollateralPosition _collateralPosition) {
            if (_collateralPosition != null) {
                this.collateralPosition.add(_collateralPosition.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralPosition(CollateralPosition _collateralPosition, int idx) {
            this.getIndex(this.collateralPosition, idx, () -> _collateralPosition.toBuilder());
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralPosition(List<? extends CollateralPosition> collateralPositions) {
            if (collateralPositions != null) {
                for (CollateralPosition collateralPosition : collateralPositions) {
                    this.collateralPosition.add(collateralPosition.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralPosition")
        public CollateralPortfolioBuilder setCollateralPosition(List<? extends CollateralPosition> collateralPositions) {
            this.collateralPosition = collateralPositions == null ? new ArrayList<CollateralPosition.CollateralPositionBuilder>() : (List)collateralPositions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralBalance")
        @RuneAttribute(value="collateralBalance")
        public CollateralPortfolioBuilder addCollateralBalance(CollateralBalance _collateralBalance) {
            if (_collateralBalance != null) {
                this.collateralBalance.add(_collateralBalance.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralBalance(CollateralBalance _collateralBalance, int idx) {
            this.getIndex(this.collateralBalance, idx, () -> _collateralBalance.toBuilder());
            return this;
        }

        @Override
        public CollateralPortfolioBuilder addCollateralBalance(List<? extends CollateralBalance> collateralBalances) {
            if (collateralBalances != null) {
                for (CollateralBalance collateralBalance : collateralBalances) {
                    this.collateralBalance.add(collateralBalance.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralBalance")
        public CollateralPortfolioBuilder setCollateralBalance(List<? extends CollateralBalance> collateralBalances) {
            this.collateralBalance = collateralBalances == null ? new ArrayList<CollateralBalance.CollateralBalanceBuilder>() : (List)collateralBalances.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="legalAgreement")
        @RuneAttribute(value="legalAgreement")
        public CollateralPortfolioBuilder setLegalAgreement(ReferenceWithMetaLegalAgreement _legalAgreement) {
            this.legalAgreement = _legalAgreement == null ? null : _legalAgreement.toBuilder();
            return this;
        }

        @Override
        public CollateralPortfolioBuilder setLegalAgreementValue(LegalAgreement _legalAgreement) {
            this.getOrCreateLegalAgreement().setValue(_legalAgreement);
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public CollateralPortfolioBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public CollateralPortfolio build() {
            return new CollateralPortfolioImpl(this);
        }

        @Override
        public CollateralPortfolioBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralPortfolioBuilder prune() {
            if (this.portfolioIdentifier != null && !this.portfolioIdentifier.prune().hasData()) {
                this.portfolioIdentifier = null;
            }
            this.collateralPosition = this.collateralPosition.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.collateralBalance = this.collateralBalance.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.legalAgreement != null && !this.legalAgreement.prune().hasData()) {
                this.legalAgreement = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPortfolioIdentifier() != null && this.getPortfolioIdentifier().hasData()) {
                return true;
            }
            if (this.getCollateralPosition() != null && this.getCollateralPosition().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCollateralBalance() != null && this.getCollateralBalance().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getLegalAgreement() != null && this.getLegalAgreement().hasData();
        }

        public CollateralPortfolioBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralPortfolioBuilder o = (CollateralPortfolioBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPortfolioIdentifier(), (RosettaModelObjectBuilder)o.getPortfolioIdentifier(), this::setPortfolioIdentifier);
            merger.mergeRosetta(this.getCollateralPosition(), o.getCollateralPosition(), this::getOrCreateCollateralPosition);
            merger.mergeRosetta(this.getCollateralBalance(), o.getCollateralBalance(), this::getOrCreateCollateralBalance);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegalAgreement(), (RosettaModelObjectBuilder)o.getLegalAgreement(), this::setLegalAgreement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralPortfolio _that = this.getType().cast(o);
            if (!Objects.equals(this.portfolioIdentifier, _that.getPortfolioIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralPosition, _that.getCollateralPosition())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralBalance, _that.getCollateralBalance())) {
                return false;
            }
            if (!Objects.equals(this.legalAgreement, _that.getLegalAgreement())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.portfolioIdentifier != null ? this.portfolioIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.collateralPosition != null ? this.collateralPosition.hashCode() : 0);
            _result = 31 * _result + (this.collateralBalance != null ? this.collateralBalance.hashCode() : 0);
            _result = 31 * _result + (this.legalAgreement != null ? this.legalAgreement.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralPortfolioBuilder {portfolioIdentifier=" + this.portfolioIdentifier + ", collateralPosition=" + this.collateralPosition + ", collateralBalance=" + this.collateralBalance + ", legalAgreement=" + this.legalAgreement + ", meta=" + this.meta + '}';
        }
    }

    public static interface CollateralPortfolioBuilder
    extends CollateralPortfolio,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public Identifier.IdentifierBuilder getOrCreatePortfolioIdentifier();

        @Override
        public Identifier.IdentifierBuilder getPortfolioIdentifier();

        public CollateralPosition.CollateralPositionBuilder getOrCreateCollateralPosition(int var1);

        public List<? extends CollateralPosition.CollateralPositionBuilder> getCollateralPosition();

        public CollateralBalance.CollateralBalanceBuilder getOrCreateCollateralBalance(int var1);

        public List<? extends CollateralBalance.CollateralBalanceBuilder> getCollateralBalance();

        public ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder getOrCreateLegalAgreement();

        @Override
        public ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder getLegalAgreement();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public CollateralPortfolioBuilder setPortfolioIdentifier(Identifier var1);

        public CollateralPortfolioBuilder addCollateralPosition(CollateralPosition var1);

        public CollateralPortfolioBuilder addCollateralPosition(CollateralPosition var1, int var2);

        public CollateralPortfolioBuilder addCollateralPosition(List<? extends CollateralPosition> var1);

        public CollateralPortfolioBuilder setCollateralPosition(List<? extends CollateralPosition> var1);

        public CollateralPortfolioBuilder addCollateralBalance(CollateralBalance var1);

        public CollateralPortfolioBuilder addCollateralBalance(CollateralBalance var1, int var2);

        public CollateralPortfolioBuilder addCollateralBalance(List<? extends CollateralBalance> var1);

        public CollateralPortfolioBuilder setCollateralBalance(List<? extends CollateralBalance> var1);

        public CollateralPortfolioBuilder setLegalAgreement(ReferenceWithMetaLegalAgreement var1);

        public CollateralPortfolioBuilder setLegalAgreementValue(LegalAgreement var1);

        public CollateralPortfolioBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("portfolioIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getPortfolioIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralPosition"), processor, CollateralPosition.CollateralPositionBuilder.class, this.getCollateralPosition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralBalance"), processor, CollateralBalance.CollateralBalanceBuilder.class, this.getCollateralBalance(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalAgreement"), processor, ReferenceWithMetaLegalAgreement.ReferenceWithMetaLegalAgreementBuilder.class, this.getLegalAgreement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public CollateralPortfolioBuilder prune();
    }

    public static class CollateralPortfolioImpl
    implements CollateralPortfolio {
        private final Identifier portfolioIdentifier;
        private final List<? extends CollateralPosition> collateralPosition;
        private final List<? extends CollateralBalance> collateralBalance;
        private final ReferenceWithMetaLegalAgreement legalAgreement;
        private final MetaFields meta;

        protected CollateralPortfolioImpl(CollateralPortfolioBuilder builder) {
            this.portfolioIdentifier = Optional.ofNullable(builder.getPortfolioIdentifier()).map(f -> f.build()).orElse(null);
            this.collateralPosition = Optional.ofNullable(builder.getCollateralPosition()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateralBalance = Optional.ofNullable(builder.getCollateralBalance()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.legalAgreement = Optional.ofNullable(builder.getLegalAgreement()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="portfolioIdentifier")
        @RuneAttribute(value="portfolioIdentifier")
        public Identifier getPortfolioIdentifier() {
            return this.portfolioIdentifier;
        }

        @Override
        @RosettaAttribute(value="collateralPosition")
        @RuneAttribute(value="collateralPosition")
        public List<? extends CollateralPosition> getCollateralPosition() {
            return this.collateralPosition;
        }

        @Override
        @RosettaAttribute(value="collateralBalance")
        @RuneAttribute(value="collateralBalance")
        public List<? extends CollateralBalance> getCollateralBalance() {
            return this.collateralBalance;
        }

        @Override
        @RosettaAttribute(value="legalAgreement")
        @RuneAttribute(value="legalAgreement")
        public ReferenceWithMetaLegalAgreement getLegalAgreement() {
            return this.legalAgreement;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public CollateralPortfolio build() {
            return this;
        }

        @Override
        public CollateralPortfolioBuilder toBuilder() {
            CollateralPortfolioBuilder builder = CollateralPortfolio.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralPortfolioBuilder builder) {
            Optional.ofNullable(this.getPortfolioIdentifier()).ifPresent(builder::setPortfolioIdentifier);
            Optional.ofNullable(this.getCollateralPosition()).ifPresent(builder::setCollateralPosition);
            Optional.ofNullable(this.getCollateralBalance()).ifPresent(builder::setCollateralBalance);
            Optional.ofNullable(this.getLegalAgreement()).ifPresent(builder::setLegalAgreement);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralPortfolio _that = this.getType().cast(o);
            if (!Objects.equals(this.portfolioIdentifier, _that.getPortfolioIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralPosition, _that.getCollateralPosition())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralBalance, _that.getCollateralBalance())) {
                return false;
            }
            if (!Objects.equals(this.legalAgreement, _that.getLegalAgreement())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.portfolioIdentifier != null ? this.portfolioIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.collateralPosition != null ? this.collateralPosition.hashCode() : 0);
            _result = 31 * _result + (this.collateralBalance != null ? this.collateralBalance.hashCode() : 0);
            _result = 31 * _result + (this.legalAgreement != null ? this.legalAgreement.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralPortfolio {portfolioIdentifier=" + this.portfolioIdentifier + ", collateralPosition=" + this.collateralPosition + ", collateralBalance=" + this.collateralBalance + ", legalAgreement=" + this.legalAgreement + ", meta=" + this.meta + '}';
        }
    }
}

