/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.AccrualFactor;
import cdm.event.common.Merger;
import cdm.event.common.SpinOff;
import cdm.event.common.meta.AdjustmentFactorCalculationTermsMeta;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceSchedule;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AdjustmentFactorCalculationTerms", builder=AdjustmentFactorCalculationTermsBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="AdjustmentFactorCalculationTerms", model="cdm", builder=AdjustmentFactorCalculationTermsBuilderImpl.class, version="7.0.0-dev.50")
public interface AdjustmentFactorCalculationTerms
extends RosettaModelObject {
    public static final AdjustmentFactorCalculationTermsMeta metaData = new AdjustmentFactorCalculationTermsMeta();

    public BigDecimal getShareForShareRatio();

    public BigDecimal getShareForRightsRatio();

    public Price getRightsSubscriptionPrice();

    public BigDecimal getDividendRatio();

    public SpinOff getSpinOff();

    public Merger getMerger();

    public AccrualFactor getAccrualFactor();

    public Price getLastFixingPriceBeforeAdjustment();

    public PriceSchedule getDividendObservation();

    public String getBespokeCalculationFormula();

    public AdjustmentFactorCalculationTerms build();

    public AdjustmentFactorCalculationTermsBuilder toBuilder();

    public static AdjustmentFactorCalculationTermsBuilder builder() {
        return new AdjustmentFactorCalculationTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends AdjustmentFactorCalculationTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AdjustmentFactorCalculationTerms> getType() {
        return AdjustmentFactorCalculationTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("shareForShareRatio"), BigDecimal.class, (Object)this.getShareForShareRatio(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("shareForRightsRatio"), BigDecimal.class, (Object)this.getShareForRightsRatio(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rightsSubscriptionPrice"), processor, Price.class, this.getRightsSubscriptionPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dividendRatio"), BigDecimal.class, (Object)this.getDividendRatio(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spinOff"), processor, SpinOff.class, this.getSpinOff(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("merger"), processor, Merger.class, this.getMerger(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrualFactor"), processor, AccrualFactor.class, this.getAccrualFactor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lastFixingPriceBeforeAdjustment"), processor, Price.class, this.getLastFixingPriceBeforeAdjustment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendObservation"), processor, PriceSchedule.class, this.getDividendObservation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bespokeCalculationFormula"), String.class, (Object)this.getBespokeCalculationFormula(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AdjustmentFactorCalculationTermsBuilderImpl
    implements AdjustmentFactorCalculationTermsBuilder {
        protected BigDecimal shareForShareRatio;
        protected BigDecimal shareForRightsRatio;
        protected Price.PriceBuilder rightsSubscriptionPrice;
        protected BigDecimal dividendRatio;
        protected SpinOff.SpinOffBuilder spinOff;
        protected Merger.MergerBuilder merger;
        protected AccrualFactor.AccrualFactorBuilder accrualFactor;
        protected Price.PriceBuilder lastFixingPriceBeforeAdjustment;
        protected PriceSchedule.PriceScheduleBuilder dividendObservation;
        protected String bespokeCalculationFormula;

        @Override
        @RosettaAttribute(value="shareForShareRatio")
        @RuneAttribute(value="shareForShareRatio")
        public BigDecimal getShareForShareRatio() {
            return this.shareForShareRatio;
        }

        @Override
        @RosettaAttribute(value="shareForRightsRatio")
        @RuneAttribute(value="shareForRightsRatio")
        public BigDecimal getShareForRightsRatio() {
            return this.shareForRightsRatio;
        }

        @Override
        @RosettaAttribute(value="rightsSubscriptionPrice")
        @RuneAttribute(value="rightsSubscriptionPrice")
        public Price.PriceBuilder getRightsSubscriptionPrice() {
            return this.rightsSubscriptionPrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateRightsSubscriptionPrice() {
            Price.PriceBuilder result = this.rightsSubscriptionPrice != null ? this.rightsSubscriptionPrice : (this.rightsSubscriptionPrice = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dividendRatio")
        @RuneAttribute(value="dividendRatio")
        public BigDecimal getDividendRatio() {
            return this.dividendRatio;
        }

        @Override
        @RosettaAttribute(value="spinOff")
        @RuneAttribute(value="spinOff")
        public SpinOff.SpinOffBuilder getSpinOff() {
            return this.spinOff;
        }

        @Override
        public SpinOff.SpinOffBuilder getOrCreateSpinOff() {
            SpinOff.SpinOffBuilder result = this.spinOff != null ? this.spinOff : (this.spinOff = SpinOff.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="merger")
        @RuneAttribute(value="merger")
        public Merger.MergerBuilder getMerger() {
            return this.merger;
        }

        @Override
        public Merger.MergerBuilder getOrCreateMerger() {
            Merger.MergerBuilder result = this.merger != null ? this.merger : (this.merger = Merger.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualFactor")
        @RuneAttribute(value="accrualFactor")
        public AccrualFactor.AccrualFactorBuilder getAccrualFactor() {
            return this.accrualFactor;
        }

        @Override
        public AccrualFactor.AccrualFactorBuilder getOrCreateAccrualFactor() {
            AccrualFactor.AccrualFactorBuilder result = this.accrualFactor != null ? this.accrualFactor : (this.accrualFactor = AccrualFactor.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lastFixingPriceBeforeAdjustment")
        @RuneAttribute(value="lastFixingPriceBeforeAdjustment")
        public Price.PriceBuilder getLastFixingPriceBeforeAdjustment() {
            return this.lastFixingPriceBeforeAdjustment;
        }

        @Override
        public Price.PriceBuilder getOrCreateLastFixingPriceBeforeAdjustment() {
            Price.PriceBuilder result = this.lastFixingPriceBeforeAdjustment != null ? this.lastFixingPriceBeforeAdjustment : (this.lastFixingPriceBeforeAdjustment = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dividendObservation")
        @RuneAttribute(value="dividendObservation")
        public PriceSchedule.PriceScheduleBuilder getDividendObservation() {
            return this.dividendObservation;
        }

        @Override
        public PriceSchedule.PriceScheduleBuilder getOrCreateDividendObservation() {
            PriceSchedule.PriceScheduleBuilder result = this.dividendObservation != null ? this.dividendObservation : (this.dividendObservation = PriceSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="bespokeCalculationFormula")
        @RuneAttribute(value="bespokeCalculationFormula")
        public String getBespokeCalculationFormula() {
            return this.bespokeCalculationFormula;
        }

        @Override
        @RosettaAttribute(value="shareForShareRatio")
        @RuneAttribute(value="shareForShareRatio")
        public AdjustmentFactorCalculationTermsBuilder setShareForShareRatio(BigDecimal _shareForShareRatio) {
            this.shareForShareRatio = _shareForShareRatio == null ? null : _shareForShareRatio;
            return this;
        }

        @Override
        @RosettaAttribute(value="shareForRightsRatio")
        @RuneAttribute(value="shareForRightsRatio")
        public AdjustmentFactorCalculationTermsBuilder setShareForRightsRatio(BigDecimal _shareForRightsRatio) {
            this.shareForRightsRatio = _shareForRightsRatio == null ? null : _shareForRightsRatio;
            return this;
        }

        @Override
        @RosettaAttribute(value="rightsSubscriptionPrice")
        @RuneAttribute(value="rightsSubscriptionPrice")
        public AdjustmentFactorCalculationTermsBuilder setRightsSubscriptionPrice(Price _rightsSubscriptionPrice) {
            this.rightsSubscriptionPrice = _rightsSubscriptionPrice == null ? null : _rightsSubscriptionPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendRatio")
        @RuneAttribute(value="dividendRatio")
        public AdjustmentFactorCalculationTermsBuilder setDividendRatio(BigDecimal _dividendRatio) {
            this.dividendRatio = _dividendRatio == null ? null : _dividendRatio;
            return this;
        }

        @Override
        @RosettaAttribute(value="spinOff")
        @RuneAttribute(value="spinOff")
        public AdjustmentFactorCalculationTermsBuilder setSpinOff(SpinOff _spinOff) {
            this.spinOff = _spinOff == null ? null : _spinOff.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="merger")
        @RuneAttribute(value="merger")
        public AdjustmentFactorCalculationTermsBuilder setMerger(Merger _merger) {
            this.merger = _merger == null ? null : _merger.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrualFactor")
        @RuneAttribute(value="accrualFactor")
        public AdjustmentFactorCalculationTermsBuilder setAccrualFactor(AccrualFactor _accrualFactor) {
            this.accrualFactor = _accrualFactor == null ? null : _accrualFactor.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFixingPriceBeforeAdjustment")
        @RuneAttribute(value="lastFixingPriceBeforeAdjustment")
        public AdjustmentFactorCalculationTermsBuilder setLastFixingPriceBeforeAdjustment(Price _lastFixingPriceBeforeAdjustment) {
            this.lastFixingPriceBeforeAdjustment = _lastFixingPriceBeforeAdjustment == null ? null : _lastFixingPriceBeforeAdjustment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendObservation")
        @RuneAttribute(value="dividendObservation")
        public AdjustmentFactorCalculationTermsBuilder setDividendObservation(PriceSchedule _dividendObservation) {
            this.dividendObservation = _dividendObservation == null ? null : _dividendObservation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="bespokeCalculationFormula")
        @RuneAttribute(value="bespokeCalculationFormula")
        public AdjustmentFactorCalculationTermsBuilder setBespokeCalculationFormula(String _bespokeCalculationFormula) {
            this.bespokeCalculationFormula = _bespokeCalculationFormula == null ? null : _bespokeCalculationFormula;
            return this;
        }

        @Override
        public AdjustmentFactorCalculationTerms build() {
            return new AdjustmentFactorCalculationTermsImpl(this);
        }

        @Override
        public AdjustmentFactorCalculationTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public AdjustmentFactorCalculationTermsBuilder prune() {
            if (this.rightsSubscriptionPrice != null && !this.rightsSubscriptionPrice.prune().hasData()) {
                this.rightsSubscriptionPrice = null;
            }
            if (this.spinOff != null && !this.spinOff.prune().hasData()) {
                this.spinOff = null;
            }
            if (this.merger != null && !this.merger.prune().hasData()) {
                this.merger = null;
            }
            if (this.accrualFactor != null && !this.accrualFactor.prune().hasData()) {
                this.accrualFactor = null;
            }
            if (this.lastFixingPriceBeforeAdjustment != null && !this.lastFixingPriceBeforeAdjustment.prune().hasData()) {
                this.lastFixingPriceBeforeAdjustment = null;
            }
            if (this.dividendObservation != null && !this.dividendObservation.prune().hasData()) {
                this.dividendObservation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getShareForShareRatio() != null) {
                return true;
            }
            if (this.getShareForRightsRatio() != null) {
                return true;
            }
            if (this.getRightsSubscriptionPrice() != null && this.getRightsSubscriptionPrice().hasData()) {
                return true;
            }
            if (this.getDividendRatio() != null) {
                return true;
            }
            if (this.getSpinOff() != null && this.getSpinOff().hasData()) {
                return true;
            }
            if (this.getMerger() != null && this.getMerger().hasData()) {
                return true;
            }
            if (this.getAccrualFactor() != null && this.getAccrualFactor().hasData()) {
                return true;
            }
            if (this.getLastFixingPriceBeforeAdjustment() != null && this.getLastFixingPriceBeforeAdjustment().hasData()) {
                return true;
            }
            if (this.getDividendObservation() != null && this.getDividendObservation().hasData()) {
                return true;
            }
            return this.getBespokeCalculationFormula() != null;
        }

        public AdjustmentFactorCalculationTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AdjustmentFactorCalculationTermsBuilder o = (AdjustmentFactorCalculationTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRightsSubscriptionPrice(), (RosettaModelObjectBuilder)o.getRightsSubscriptionPrice(), this::setRightsSubscriptionPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpinOff(), (RosettaModelObjectBuilder)o.getSpinOff(), this::setSpinOff);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMerger(), (RosettaModelObjectBuilder)o.getMerger(), this::setMerger);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccrualFactor(), (RosettaModelObjectBuilder)o.getAccrualFactor(), this::setAccrualFactor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLastFixingPriceBeforeAdjustment(), (RosettaModelObjectBuilder)o.getLastFixingPriceBeforeAdjustment(), this::setLastFixingPriceBeforeAdjustment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendObservation(), (RosettaModelObjectBuilder)o.getDividendObservation(), this::setDividendObservation);
            merger.mergeBasic((Object)this.getShareForShareRatio(), (Object)o.getShareForShareRatio(), this::setShareForShareRatio, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getShareForRightsRatio(), (Object)o.getShareForRightsRatio(), this::setShareForRightsRatio, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDividendRatio(), (Object)o.getDividendRatio(), this::setDividendRatio, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBespokeCalculationFormula(), (Object)o.getBespokeCalculationFormula(), this::setBespokeCalculationFormula, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AdjustmentFactorCalculationTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.shareForShareRatio, _that.getShareForShareRatio())) {
                return false;
            }
            if (!Objects.equals(this.shareForRightsRatio, _that.getShareForRightsRatio())) {
                return false;
            }
            if (!Objects.equals(this.rightsSubscriptionPrice, _that.getRightsSubscriptionPrice())) {
                return false;
            }
            if (!Objects.equals(this.dividendRatio, _that.getDividendRatio())) {
                return false;
            }
            if (!Objects.equals(this.spinOff, _that.getSpinOff())) {
                return false;
            }
            if (!Objects.equals(this.merger, _that.getMerger())) {
                return false;
            }
            if (!Objects.equals(this.accrualFactor, _that.getAccrualFactor())) {
                return false;
            }
            if (!Objects.equals(this.lastFixingPriceBeforeAdjustment, _that.getLastFixingPriceBeforeAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.dividendObservation, _that.getDividendObservation())) {
                return false;
            }
            return Objects.equals(this.bespokeCalculationFormula, _that.getBespokeCalculationFormula());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.shareForShareRatio != null ? this.shareForShareRatio.hashCode() : 0);
            _result = 31 * _result + (this.shareForRightsRatio != null ? this.shareForRightsRatio.hashCode() : 0);
            _result = 31 * _result + (this.rightsSubscriptionPrice != null ? this.rightsSubscriptionPrice.hashCode() : 0);
            _result = 31 * _result + (this.dividendRatio != null ? this.dividendRatio.hashCode() : 0);
            _result = 31 * _result + (this.spinOff != null ? this.spinOff.hashCode() : 0);
            _result = 31 * _result + (this.merger != null ? this.merger.hashCode() : 0);
            _result = 31 * _result + (this.accrualFactor != null ? this.accrualFactor.hashCode() : 0);
            _result = 31 * _result + (this.lastFixingPriceBeforeAdjustment != null ? this.lastFixingPriceBeforeAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.dividendObservation != null ? this.dividendObservation.hashCode() : 0);
            _result = 31 * _result + (this.bespokeCalculationFormula != null ? this.bespokeCalculationFormula.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AdjustmentFactorCalculationTermsBuilder {shareForShareRatio=" + this.shareForShareRatio + ", shareForRightsRatio=" + this.shareForRightsRatio + ", rightsSubscriptionPrice=" + this.rightsSubscriptionPrice + ", dividendRatio=" + this.dividendRatio + ", spinOff=" + this.spinOff + ", merger=" + this.merger + ", accrualFactor=" + this.accrualFactor + ", lastFixingPriceBeforeAdjustment=" + this.lastFixingPriceBeforeAdjustment + ", dividendObservation=" + this.dividendObservation + ", bespokeCalculationFormula=" + this.bespokeCalculationFormula + '}';
        }
    }

    public static interface AdjustmentFactorCalculationTermsBuilder
    extends AdjustmentFactorCalculationTerms,
    RosettaModelObjectBuilder {
        public Price.PriceBuilder getOrCreateRightsSubscriptionPrice();

        @Override
        public Price.PriceBuilder getRightsSubscriptionPrice();

        public SpinOff.SpinOffBuilder getOrCreateSpinOff();

        @Override
        public SpinOff.SpinOffBuilder getSpinOff();

        public Merger.MergerBuilder getOrCreateMerger();

        @Override
        public Merger.MergerBuilder getMerger();

        public AccrualFactor.AccrualFactorBuilder getOrCreateAccrualFactor();

        @Override
        public AccrualFactor.AccrualFactorBuilder getAccrualFactor();

        public Price.PriceBuilder getOrCreateLastFixingPriceBeforeAdjustment();

        @Override
        public Price.PriceBuilder getLastFixingPriceBeforeAdjustment();

        public PriceSchedule.PriceScheduleBuilder getOrCreateDividendObservation();

        @Override
        public PriceSchedule.PriceScheduleBuilder getDividendObservation();

        public AdjustmentFactorCalculationTermsBuilder setShareForShareRatio(BigDecimal var1);

        public AdjustmentFactorCalculationTermsBuilder setShareForRightsRatio(BigDecimal var1);

        public AdjustmentFactorCalculationTermsBuilder setRightsSubscriptionPrice(Price var1);

        public AdjustmentFactorCalculationTermsBuilder setDividendRatio(BigDecimal var1);

        public AdjustmentFactorCalculationTermsBuilder setSpinOff(SpinOff var1);

        public AdjustmentFactorCalculationTermsBuilder setMerger(Merger var1);

        public AdjustmentFactorCalculationTermsBuilder setAccrualFactor(AccrualFactor var1);

        public AdjustmentFactorCalculationTermsBuilder setLastFixingPriceBeforeAdjustment(Price var1);

        public AdjustmentFactorCalculationTermsBuilder setDividendObservation(PriceSchedule var1);

        public AdjustmentFactorCalculationTermsBuilder setBespokeCalculationFormula(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("shareForShareRatio"), BigDecimal.class, (Object)this.getShareForShareRatio(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("shareForRightsRatio"), BigDecimal.class, (Object)this.getShareForRightsRatio(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rightsSubscriptionPrice"), processor, Price.PriceBuilder.class, this.getRightsSubscriptionPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dividendRatio"), BigDecimal.class, (Object)this.getDividendRatio(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spinOff"), processor, SpinOff.SpinOffBuilder.class, this.getSpinOff(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("merger"), processor, Merger.MergerBuilder.class, this.getMerger(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrualFactor"), processor, AccrualFactor.AccrualFactorBuilder.class, this.getAccrualFactor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lastFixingPriceBeforeAdjustment"), processor, Price.PriceBuilder.class, this.getLastFixingPriceBeforeAdjustment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendObservation"), processor, PriceSchedule.PriceScheduleBuilder.class, this.getDividendObservation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bespokeCalculationFormula"), String.class, (Object)this.getBespokeCalculationFormula(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AdjustmentFactorCalculationTermsBuilder prune();
    }

    public static class AdjustmentFactorCalculationTermsImpl
    implements AdjustmentFactorCalculationTerms {
        private final BigDecimal shareForShareRatio;
        private final BigDecimal shareForRightsRatio;
        private final Price rightsSubscriptionPrice;
        private final BigDecimal dividendRatio;
        private final SpinOff spinOff;
        private final Merger merger;
        private final AccrualFactor accrualFactor;
        private final Price lastFixingPriceBeforeAdjustment;
        private final PriceSchedule dividendObservation;
        private final String bespokeCalculationFormula;

        protected AdjustmentFactorCalculationTermsImpl(AdjustmentFactorCalculationTermsBuilder builder) {
            this.shareForShareRatio = builder.getShareForShareRatio();
            this.shareForRightsRatio = builder.getShareForRightsRatio();
            this.rightsSubscriptionPrice = Optional.ofNullable(builder.getRightsSubscriptionPrice()).map(f -> f.build()).orElse(null);
            this.dividendRatio = builder.getDividendRatio();
            this.spinOff = Optional.ofNullable(builder.getSpinOff()).map(f -> f.build()).orElse(null);
            this.merger = Optional.ofNullable(builder.getMerger()).map(f -> f.build()).orElse(null);
            this.accrualFactor = Optional.ofNullable(builder.getAccrualFactor()).map(f -> f.build()).orElse(null);
            this.lastFixingPriceBeforeAdjustment = Optional.ofNullable(builder.getLastFixingPriceBeforeAdjustment()).map(f -> f.build()).orElse(null);
            this.dividendObservation = Optional.ofNullable(builder.getDividendObservation()).map(f -> f.build()).orElse(null);
            this.bespokeCalculationFormula = builder.getBespokeCalculationFormula();
        }

        @Override
        @RosettaAttribute(value="shareForShareRatio")
        @RuneAttribute(value="shareForShareRatio")
        public BigDecimal getShareForShareRatio() {
            return this.shareForShareRatio;
        }

        @Override
        @RosettaAttribute(value="shareForRightsRatio")
        @RuneAttribute(value="shareForRightsRatio")
        public BigDecimal getShareForRightsRatio() {
            return this.shareForRightsRatio;
        }

        @Override
        @RosettaAttribute(value="rightsSubscriptionPrice")
        @RuneAttribute(value="rightsSubscriptionPrice")
        public Price getRightsSubscriptionPrice() {
            return this.rightsSubscriptionPrice;
        }

        @Override
        @RosettaAttribute(value="dividendRatio")
        @RuneAttribute(value="dividendRatio")
        public BigDecimal getDividendRatio() {
            return this.dividendRatio;
        }

        @Override
        @RosettaAttribute(value="spinOff")
        @RuneAttribute(value="spinOff")
        public SpinOff getSpinOff() {
            return this.spinOff;
        }

        @Override
        @RosettaAttribute(value="merger")
        @RuneAttribute(value="merger")
        public Merger getMerger() {
            return this.merger;
        }

        @Override
        @RosettaAttribute(value="accrualFactor")
        @RuneAttribute(value="accrualFactor")
        public AccrualFactor getAccrualFactor() {
            return this.accrualFactor;
        }

        @Override
        @RosettaAttribute(value="lastFixingPriceBeforeAdjustment")
        @RuneAttribute(value="lastFixingPriceBeforeAdjustment")
        public Price getLastFixingPriceBeforeAdjustment() {
            return this.lastFixingPriceBeforeAdjustment;
        }

        @Override
        @RosettaAttribute(value="dividendObservation")
        @RuneAttribute(value="dividendObservation")
        public PriceSchedule getDividendObservation() {
            return this.dividendObservation;
        }

        @Override
        @RosettaAttribute(value="bespokeCalculationFormula")
        @RuneAttribute(value="bespokeCalculationFormula")
        public String getBespokeCalculationFormula() {
            return this.bespokeCalculationFormula;
        }

        @Override
        public AdjustmentFactorCalculationTerms build() {
            return this;
        }

        @Override
        public AdjustmentFactorCalculationTermsBuilder toBuilder() {
            AdjustmentFactorCalculationTermsBuilder builder = AdjustmentFactorCalculationTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AdjustmentFactorCalculationTermsBuilder builder) {
            Optional.ofNullable(this.getShareForShareRatio()).ifPresent(builder::setShareForShareRatio);
            Optional.ofNullable(this.getShareForRightsRatio()).ifPresent(builder::setShareForRightsRatio);
            Optional.ofNullable(this.getRightsSubscriptionPrice()).ifPresent(builder::setRightsSubscriptionPrice);
            Optional.ofNullable(this.getDividendRatio()).ifPresent(builder::setDividendRatio);
            Optional.ofNullable(this.getSpinOff()).ifPresent(builder::setSpinOff);
            Optional.ofNullable(this.getMerger()).ifPresent(builder::setMerger);
            Optional.ofNullable(this.getAccrualFactor()).ifPresent(builder::setAccrualFactor);
            Optional.ofNullable(this.getLastFixingPriceBeforeAdjustment()).ifPresent(builder::setLastFixingPriceBeforeAdjustment);
            Optional.ofNullable(this.getDividendObservation()).ifPresent(builder::setDividendObservation);
            Optional.ofNullable(this.getBespokeCalculationFormula()).ifPresent(builder::setBespokeCalculationFormula);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AdjustmentFactorCalculationTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.shareForShareRatio, _that.getShareForShareRatio())) {
                return false;
            }
            if (!Objects.equals(this.shareForRightsRatio, _that.getShareForRightsRatio())) {
                return false;
            }
            if (!Objects.equals(this.rightsSubscriptionPrice, _that.getRightsSubscriptionPrice())) {
                return false;
            }
            if (!Objects.equals(this.dividendRatio, _that.getDividendRatio())) {
                return false;
            }
            if (!Objects.equals(this.spinOff, _that.getSpinOff())) {
                return false;
            }
            if (!Objects.equals(this.merger, _that.getMerger())) {
                return false;
            }
            if (!Objects.equals(this.accrualFactor, _that.getAccrualFactor())) {
                return false;
            }
            if (!Objects.equals(this.lastFixingPriceBeforeAdjustment, _that.getLastFixingPriceBeforeAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.dividendObservation, _that.getDividendObservation())) {
                return false;
            }
            return Objects.equals(this.bespokeCalculationFormula, _that.getBespokeCalculationFormula());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.shareForShareRatio != null ? this.shareForShareRatio.hashCode() : 0);
            _result = 31 * _result + (this.shareForRightsRatio != null ? this.shareForRightsRatio.hashCode() : 0);
            _result = 31 * _result + (this.rightsSubscriptionPrice != null ? this.rightsSubscriptionPrice.hashCode() : 0);
            _result = 31 * _result + (this.dividendRatio != null ? this.dividendRatio.hashCode() : 0);
            _result = 31 * _result + (this.spinOff != null ? this.spinOff.hashCode() : 0);
            _result = 31 * _result + (this.merger != null ? this.merger.hashCode() : 0);
            _result = 31 * _result + (this.accrualFactor != null ? this.accrualFactor.hashCode() : 0);
            _result = 31 * _result + (this.lastFixingPriceBeforeAdjustment != null ? this.lastFixingPriceBeforeAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.dividendObservation != null ? this.dividendObservation.hashCode() : 0);
            _result = 31 * _result + (this.bespokeCalculationFormula != null ? this.bespokeCalculationFormula.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AdjustmentFactorCalculationTerms {shareForShareRatio=" + this.shareForShareRatio + ", shareForRightsRatio=" + this.shareForRightsRatio + ", rightsSubscriptionPrice=" + this.rightsSubscriptionPrice + ", dividendRatio=" + this.dividendRatio + ", spinOff=" + this.spinOff + ", merger=" + this.merger + ", accrualFactor=" + this.accrualFactor + ", lastFixingPriceBeforeAdjustment=" + this.lastFixingPriceBeforeAdjustment + ", dividendObservation=" + this.dividendObservation + ", bespokeCalculationFormula=" + this.bespokeCalculationFormula + '}';
        }
    }
}

