/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.DebtType;
import cdm.base.staticdata.asset.common.EquityType;
import cdm.base.staticdata.asset.common.FundProductTypeEnum;
import cdm.base.staticdata.asset.common.InstrumentBase;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.asset.common.meta.SecurityMeta;
import cdm.base.staticdata.party.LegalEntity;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Security", builder=SecurityBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="Security", model="cdm", builder=SecurityBuilderImpl.class, version="7.0.0-dev.50")
public interface Security
extends InstrumentBase {
    public static final SecurityMeta metaData = new SecurityMeta();

    public DebtType getDebtType();

    public EquityType getEquityType();

    public FundProductTypeEnum getFundType();

    @Override
    public Security build();

    @Override
    public SecurityBuilder toBuilder();

    public static SecurityBuilder builder() {
        return new SecurityBuilderImpl();
    }

    default public RosettaMetaData<? extends Security> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Security> getType() {
        return Security.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("instrumentType"), InstrumentTypeEnum.class, (Object)this.getInstrumentType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("debtType"), processor, DebtType.class, this.getDebtType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityType"), processor, EquityType.class, this.getEquityType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fundType"), FundProductTypeEnum.class, (Object)this.getFundType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SecurityBuilderImpl
    extends InstrumentBase.InstrumentBaseBuilderImpl
    implements SecurityBuilder {
        protected DebtType.DebtTypeBuilder debtType;
        protected EquityType.EquityTypeBuilder equityType;
        protected FundProductTypeEnum fundType;

        @Override
        @RosettaAttribute(value="debtType")
        @RuneAttribute(value="debtType")
        public DebtType.DebtTypeBuilder getDebtType() {
            return this.debtType;
        }

        @Override
        public DebtType.DebtTypeBuilder getOrCreateDebtType() {
            DebtType.DebtTypeBuilder result = this.debtType != null ? this.debtType : (this.debtType = DebtType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityType")
        @RuneAttribute(value="equityType")
        public EquityType.EquityTypeBuilder getEquityType() {
            return this.equityType;
        }

        @Override
        public EquityType.EquityTypeBuilder getOrCreateEquityType() {
            EquityType.EquityTypeBuilder result = this.equityType != null ? this.equityType : (this.equityType = EquityType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fundType")
        @RuneAttribute(value="fundType")
        public FundProductTypeEnum getFundType() {
            return this.fundType;
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public SecurityBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityBuilder addIdentifier(AssetIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public SecurityBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public SecurityBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityBuilder addTaxonomy(Taxonomy _taxonomy, int idx) {
            this.getIndex(this.taxonomy, idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public SecurityBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public SecurityBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public SecurityBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public SecurityBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public SecurityBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType", isRequired=true)
        @RuneAttribute(value="instrumentType", isRequired=true)
        public SecurityBuilder setInstrumentType(InstrumentTypeEnum _instrumentType) {
            this.instrumentType = _instrumentType == null ? null : _instrumentType;
            return this;
        }

        @Override
        @RosettaAttribute(value="debtType")
        @RuneAttribute(value="debtType")
        public SecurityBuilder setDebtType(DebtType _debtType) {
            this.debtType = _debtType == null ? null : _debtType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityType")
        @RuneAttribute(value="equityType")
        public SecurityBuilder setEquityType(EquityType _equityType) {
            this.equityType = _equityType == null ? null : _equityType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fundType")
        @RuneAttribute(value="fundType")
        public SecurityBuilder setFundType(FundProductTypeEnum _fundType) {
            this.fundType = _fundType == null ? null : _fundType;
            return this;
        }

        @Override
        public Security build() {
            return new SecurityImpl(this);
        }

        @Override
        public SecurityBuilder toBuilder() {
            return this;
        }

        @Override
        public SecurityBuilder prune() {
            super.prune();
            if (this.debtType != null && !this.debtType.prune().hasData()) {
                this.debtType = null;
            }
            if (this.equityType != null && !this.equityType.prune().hasData()) {
                this.equityType = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDebtType() != null && this.getDebtType().hasData()) {
                return true;
            }
            if (this.getEquityType() != null && this.getEquityType().hasData()) {
                return true;
            }
            return this.getFundType() != null;
        }

        @Override
        public SecurityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SecurityBuilder o = (SecurityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDebtType(), (RosettaModelObjectBuilder)o.getDebtType(), this::setDebtType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityType(), (RosettaModelObjectBuilder)o.getEquityType(), this::setEquityType);
            merger.mergeBasic((Object)this.getFundType(), (Object)o.getFundType(), this::setFundType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Security _that = (Security)this.getType().cast(o);
            if (!Objects.equals(this.debtType, _that.getDebtType())) {
                return false;
            }
            if (!Objects.equals(this.equityType, _that.getEquityType())) {
                return false;
            }
            return Objects.equals((Object)this.fundType, (Object)_that.getFundType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.debtType != null ? this.debtType.hashCode() : 0);
            _result = 31 * _result + (this.equityType != null ? this.equityType.hashCode() : 0);
            _result = 31 * _result + (this.fundType != null ? ((Object)((Object)this.fundType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SecurityBuilder {debtType=" + this.debtType + ", equityType=" + this.equityType + ", fundType=" + (Object)((Object)this.fundType) + '}' + " " + super.toString();
        }
    }

    public static interface SecurityBuilder
    extends Security,
    InstrumentBase.InstrumentBaseBuilder {
        public DebtType.DebtTypeBuilder getOrCreateDebtType();

        @Override
        public DebtType.DebtTypeBuilder getDebtType();

        public EquityType.EquityTypeBuilder getOrCreateEquityType();

        @Override
        public EquityType.EquityTypeBuilder getEquityType();

        @Override
        public SecurityBuilder addIdentifier(AssetIdentifier var1);

        @Override
        public SecurityBuilder addIdentifier(AssetIdentifier var1, int var2);

        @Override
        public SecurityBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public SecurityBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public SecurityBuilder addTaxonomy(Taxonomy var1);

        @Override
        public SecurityBuilder addTaxonomy(Taxonomy var1, int var2);

        @Override
        public SecurityBuilder addTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public SecurityBuilder setTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public SecurityBuilder setIsExchangeListed(Boolean var1);

        @Override
        public SecurityBuilder setExchange(LegalEntity var1);

        @Override
        public SecurityBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public SecurityBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public SecurityBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public SecurityBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public SecurityBuilder setInstrumentType(InstrumentTypeEnum var1);

        public SecurityBuilder setDebtType(DebtType var1);

        public SecurityBuilder setEquityType(EquityType var1);

        public SecurityBuilder setFundType(FundProductTypeEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("instrumentType"), InstrumentTypeEnum.class, (Object)this.getInstrumentType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("debtType"), processor, DebtType.DebtTypeBuilder.class, this.getDebtType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityType"), processor, EquityType.EquityTypeBuilder.class, this.getEquityType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fundType"), FundProductTypeEnum.class, (Object)this.getFundType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public SecurityBuilder prune();
    }

    public static class SecurityImpl
    extends InstrumentBase.InstrumentBaseImpl
    implements Security {
        private final DebtType debtType;
        private final EquityType equityType;
        private final FundProductTypeEnum fundType;

        protected SecurityImpl(SecurityBuilder builder) {
            super(builder);
            this.debtType = Optional.ofNullable(builder.getDebtType()).map(f -> f.build()).orElse(null);
            this.equityType = Optional.ofNullable(builder.getEquityType()).map(f -> f.build()).orElse(null);
            this.fundType = builder.getFundType();
        }

        @Override
        @RosettaAttribute(value="debtType")
        @RuneAttribute(value="debtType")
        public DebtType getDebtType() {
            return this.debtType;
        }

        @Override
        @RosettaAttribute(value="equityType")
        @RuneAttribute(value="equityType")
        public EquityType getEquityType() {
            return this.equityType;
        }

        @Override
        @RosettaAttribute(value="fundType")
        @RuneAttribute(value="fundType")
        public FundProductTypeEnum getFundType() {
            return this.fundType;
        }

        @Override
        public Security build() {
            return this;
        }

        @Override
        public SecurityBuilder toBuilder() {
            SecurityBuilder builder = Security.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SecurityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDebtType()).ifPresent(builder::setDebtType);
            Optional.ofNullable(this.getEquityType()).ifPresent(builder::setEquityType);
            Optional.ofNullable(this.getFundType()).ifPresent(builder::setFundType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Security _that = (Security)this.getType().cast(o);
            if (!Objects.equals(this.debtType, _that.getDebtType())) {
                return false;
            }
            if (!Objects.equals(this.equityType, _that.getEquityType())) {
                return false;
            }
            return Objects.equals((Object)this.fundType, (Object)_that.getFundType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.debtType != null ? this.debtType.hashCode() : 0);
            _result = 31 * _result + (this.equityType != null ? this.equityType.hashCode() : 0);
            _result = 31 * _result + (this.fundType != null ? ((Object)((Object)this.fundType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Security {debtType=" + this.debtType + ", equityType=" + this.equityType + ", fundType=" + (Object)((Object)this.fundType) + '}' + " " + super.toString();
        }
    }
}

