# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['PortfolioReturnTerms']

from cdm.product.template.ReturnTerms import ReturnTerms

class PortfolioReturnTerms(ReturnTerms):
    """
    Specifies an individual type of return of a Performance Payout, when such individual return is part of an aggregation of multiple similar returns, at Performance Payout level.
    """
    payerReceiver: cdm.base.staticdata.party.PayerReceiver.PayerReceiver = Field(..., description="Canonical representation of the payer and receiver parties applicable to each individual return leg.")
    """
    Canonical representation of the payer and receiver parties applicable to each individual return leg.
    """
    underlier: AttributeWithAddress[cdm.observable.asset.Observable.Observable] | cdm.observable.asset.Observable.Observable = Field(..., description="Defines the product that is the subject of a tradable product definition, an underlying product definition, a physical exercise, a position, or other purposes.")
    """
    Defines the product that is the subject of a tradable product definition, an underlying product definition, a physical exercise, a position, or other purposes.
    """
    quantity: Optional[AttributeWithAddress[cdm.base.math.NonNegativeQuantitySchedule.NonNegativeQuantitySchedule] | cdm.base.math.NonNegativeQuantitySchedule.NonNegativeQuantitySchedule] = Field(None, description="Specifies a quantity schedule for the underlier, which applies to each individual return leg.")
    """
    Specifies a quantity schedule for the underlier, which applies to each individual return leg.
    """
    initialValuationPrice: List[AttributeWithAddress[cdm.observable.asset.PriceSchedule.PriceSchedule] | cdm.observable.asset.PriceSchedule.PriceSchedule] = Field([], description="Specifies the initial valuation price(s) of the underlier. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.")
    """
    Specifies the initial valuation price(s) of the underlier. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.
    """
    interimValuationPrice: List[AttributeWithAddress[cdm.observable.asset.PriceSchedule.PriceSchedule] | cdm.observable.asset.PriceSchedule.PriceSchedule] = Field([], description="Specifies the initial valuation price(s) of the underlier. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.")
    """
    Specifies the initial valuation price(s) of the underlier. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.
    """
    finalValuationPrice: List[AttributeWithAddress[cdm.observable.asset.PriceSchedule.PriceSchedule] | cdm.observable.asset.PriceSchedule.PriceSchedule] = Field([], description="2018 ISDA CDM Equity Confirmation for Security Equity Swap: Final Price | Specifies the final valuation price of the underlier. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.")
    """
    2018 ISDA CDM Equity Confirmation for Security Equity Swap: Final Price | Specifies the final valuation price of the underlier. This price can be expressed either as an actual amount/currency, as a determination method, or by reference to another value specified in the swap document.
    """

import cdm 
import cdm.base.staticdata.party.PayerReceiver
import cdm.observable.asset.Observable
import cdm.base.math.NonNegativeQuantitySchedule
import cdm.observable.asset.PriceSchedule
