# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Payout']


class Payout(BaseDataClass):
    _CHOICE_ALIAS_MAP ={"payerReceiver":[("AssetPayout", rosetta_resolve_attr), ("CommodityPayout", rosetta_resolve_attr), ("CreditDefaultPayout", rosetta_resolve_attr), ("FixedPricePayout", rosetta_resolve_attr), ("InterestRatePayout", rosetta_resolve_attr), ("OptionPayout", rosetta_resolve_attr), ("PerformancePayout", rosetta_resolve_attr), ("SettlementPayout", rosetta_resolve_attr)],"priceQuantity":[("AssetPayout", rosetta_resolve_attr), ("CommodityPayout", rosetta_resolve_attr), ("CreditDefaultPayout", rosetta_resolve_attr), ("FixedPricePayout", rosetta_resolve_attr), ("InterestRatePayout", rosetta_resolve_attr), ("OptionPayout", rosetta_resolve_attr), ("PerformancePayout", rosetta_resolve_attr), ("SettlementPayout", rosetta_resolve_attr)],"settlementTerms":[("AssetPayout", rosetta_resolve_attr), ("CommodityPayout", rosetta_resolve_attr), ("CreditDefaultPayout", rosetta_resolve_attr), ("FixedPricePayout", rosetta_resolve_attr), ("InterestRatePayout", rosetta_resolve_attr), ("OptionPayout", rosetta_resolve_attr), ("PerformancePayout", rosetta_resolve_attr), ("SettlementPayout", rosetta_resolve_attr)],"principalPayment":[("AssetPayout", rosetta_resolve_attr), ("CommodityPayout", rosetta_resolve_attr), ("CreditDefaultPayout", rosetta_resolve_attr), ("FixedPricePayout", rosetta_resolve_attr), ("InterestRatePayout", rosetta_resolve_attr), ("OptionPayout", rosetta_resolve_attr), ("PerformancePayout", rosetta_resolve_attr), ("SettlementPayout", rosetta_resolve_attr)]}
    """
    Represents the set of future cashflow methodologies in the form of specific payout data type(s) which result from the financial product.  Examples: a trade in a cash asset will use only a settlement payout; for derivatives, two interest rate payouts can be combined to specify an interest rate swap; one interest rate payout can be combined with a credit default payout to specify a credit default swap.
    """
    AssetPayout: Optional[cdm.product.template.AssetPayout.AssetPayout] = Field(None, description="Defines the assets and movements in a security financing transaction.")
    """
    Defines the assets and movements in a security financing transaction.
    """
    CommodityPayout: Optional[cdm.product.asset.CommodityPayout.CommodityPayout] = Field(None, description="Defines the payout for the floating leg of a Commodity Swap.")
    """
    Defines the payout for the floating leg of a Commodity Swap.
    """
    CreditDefaultPayout: Optional[cdm.product.asset.CreditDefaultPayout.CreditDefaultPayout] = Field(None, description="The credit default payout, which provides the details necessary for determining when a credit payout will be triggered as well as the parameters for calculating the payout and the settlement terms.")
    """
    The credit default payout, which provides the details necessary for determining when a credit payout will be triggered as well as the parameters for calculating the payout and the settlement terms.
    """
    FixedPricePayout: Optional[cdm.product.template.FixedPricePayout.FixedPricePayout] = Field(None, description="Defines a payout in which one or more payouts are defined as a fixed price.")
    """
    Defines a payout in which one or more payouts are defined as a fixed price.
    """
    InterestRatePayout: Optional[cdm.product.asset.InterestRatePayout.InterestRatePayout] = Field(None, description="All of the terms necessary to define and calculate a cash flow based on a fixed, a floating or an inflation index rate. The interest rate payout can be applied to interest rate swaps and FRA (which both have two associated interest rate payouts), credit default swaps (to represent the fee leg when subject to periodic payments) and equity swaps (to represent the funding leg).")
    """
    All of the terms necessary to define and calculate a cash flow based on a fixed, a floating or an inflation index rate. The interest rate payout can be applied to interest rate swaps and FRA (which both have two associated interest rate payouts), credit default swaps (to represent the fee leg when subject to periodic payments) and equity swaps (to represent the funding leg).
    """
    OptionPayout: Optional[cdm.product.template.OptionPayout.OptionPayout] = Field(None, description="The option payout.")
    """
    The option payout.
    """
    PerformancePayout: Optional[cdm.product.template.PerformancePayout.PerformancePayout] = Field(None, description="The performance payout, which encompasses the equity price returns, dividend returns, volatility return, variance return and correlation provisions.")
    """
    The performance payout, which encompasses the equity price returns, dividend returns, volatility return, variance return and correlation provisions.
    """
    SettlementPayout: Optional[cdm.product.template.SettlementPayout.SettlementPayout] = Field(None, description="Represents a forward settling payout. The 'Underlier' attribute captures the underlying payout, which is settled according to the 'SettlementTerms' attribute. Both FX Spot and FX Forward should use this component.")
    """
    Represents a forward settling payout. The 'Underlier' attribute captures the underlying payout, which is settled according to the 'SettlementTerms' attribute. Both FX Spot and FX Forward should use this component.
    """
    
    @rosetta_condition
    def condition_0_Choice(self):
        item = self
        return rosetta_check_one_of(self, 'AssetPayout', 'CommodityPayout', 'CreditDefaultPayout', 'FixedPricePayout', 'InterestRatePayout', 'OptionPayout', 'PerformancePayout', 'SettlementPayout', necessity=True)

import cdm 
import cdm.product.template.AssetPayout
import cdm.product.asset.CommodityPayout
import cdm.product.asset.CreditDefaultPayout
import cdm.product.template.FixedPricePayout
import cdm.product.asset.InterestRatePayout
import cdm.product.template.OptionPayout
import cdm.product.template.PerformancePayout
import cdm.product.template.SettlementPayout
