# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.observable.asset.fro.functions.FloatingRateIndexMetadata import FloatingRateIndexMetadata
from cdm.event.common.TradeState import TradeState
from cdm.base.staticdata.asset.rates.FloatingRateIndexEnum import FloatingRateIndexEnum

__all__ = ['FilterInvalidFloatingRateIndexTradeDate']


@replaceable
def FilterInvalidFloatingRateIndexTradeDate(tradeState: TradeState) -> FloatingRateIndexEnum:
    """
    Returns the invalid floating rate index or indices of a trade based on their metadata and the trade date.
    
    Parameters 
    ----------
    tradeState : TradeState
    The input is a trade to validate its floating rate index based on the trade date
    
    Returns
    -------
    invalidFloatingRateIndex : FloatingRateIndexEnum
    
    """
    self = inspect.currentframe()
    
    
    invalidFloatingRateIndex =  (lambda item: list(map(lambda item: rosetta_resolve_attr(rosetta_resolve_attr(item, "fro"), "floatingRateIndex"), item)))((lambda item: rosetta_filter(item, lambda item: (all_elements(rosetta_resolve_attr(rosetta_resolve_attr(item, "history"), "startDate"), ">", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "tradeDate")) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(item, "history"), "endDate"), "<", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "tradeDate")))))(list(map(lambda item: FloatingRateIndexMetadata(item), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "tradeState"), "trade"), "tradeLot"), "priceQuantity"), "observable"), "Index"), "InterestRateIndex"), "FloatingRateIndex"), "floatingRateIndex")))))
    
    
    return invalidFloatingRateIndex

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
