# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['BrokerConfirmationTypeEnum']

class BrokerConfirmationTypeEnum(Enum):
    """
    The enumerated values to specify the type of Broker Confirm that the FpML trade represents.
    """
    ABX = "ABX"
    """
    Broker Confirmation Type representing ABX index trades.
    """
    ASIA_CORPORATE = "AsiaCorporate"
    """
    Broker Confirmation Type of Asia Corporate.
    """
    ASIA_SOVEREIGN = "AsiaSovereign"
    """
    Broker Confirmation Type of Asia Sovereign.
    """
    AUSTRALIA_CORPORATE = "AustraliaCorporate"
    """
    Broker Confirmation Type of Australia Corporate.
    """
    AUSTRALIA_SOVEREIGN = "AustraliaSovereign"
    """
    Broker Confirmation Type of Australia Sovereign.
    """
    CD_SON_LEVERAGED_LOANS = "CDSonLeveragedLoans"
    """
    Broker Confirmation Type for use with Credit Derivative Transactions on Leveraged Loans.
    """
    CD_SON_MBS = "CDSonMBS"
    """
    Broker Confirmation Type for use with Credit Derivative Transactions on Mortgage-backed Security with Pay-As-You-Go or Physical Settlement.
    """
    CDX_EMERGING_MARKETS = "CDXEmergingMarkets"
    """
    Broker Confirmation Type for CDX Emerging Markets Untranched Transactions.
    """
    CDX_EMERGING_MARKETS_DIVERSIFIED = "CDXEmergingMarketsDiversified"
    """
    Broker Confirmation Type for CDX Emerging Markets Diversified Untranched Transactions.
    """
    CDX_SWAPTION = "CDXSwaption"
    """
    Broker Confirmation Type for CDX Swaption Transactions.
    """
    CDX_TRANCHE = "CDXTranche"
    """
    Broker Confirmation Type for Dow Jones CDX Tranche Transactions.
    """
    CMBX = "CMBX"
    """
    Broker Confirmation Type representing CMBX index trades.
    """
    DJ_CDX_EM_ = "DJ.CDX.EM "
    """
    Broker Confirmation Type for CDS Index trades relating to Dow Jones CDX.EM index series.
    """
    DJ_CDX_NA = "DJ.CDX.NA"
    """
    Broker Confirmation Type for CDS Index trades relating to Dow Jones CDX.NA.IG and Dow Jones CDX.NA.HY index series.
    """
    EMERGING_EUROPEAN_AND_MIDDLE_EASTERN_SOVEREIGN = "EmergingEuropeanAndMiddleEasternSovereign"
    """
    Broker Confirmation Type of Emerging European and Middle Eastern Sovereign.
    """
    EMERGING_EUROPEAN_CORPORATE = "EmergingEuropeanCorporate"
    """
    Broker Confirmation Type for EMERGING EUROPEAN CORPORATE.
    """
    EMERGING_EUROPEAN_CORPORATE_LPN = "EmergingEuropeanCorporateLPN"
    """
    Broker Confirmation Type for EMERGING EUROPEAN CORPORATE LPN.
    """
    EUROPEAN_CMBS = "EuropeanCMBS"
    """
    Broker Confirmation Type for Single Name European CMBS Transactions.
    """
    EUROPEAN_CORPORATE = "EuropeanCorporate"
    """
    Broker Confirmation Type of European Corporate.
    """
    EUROPEAN_RMBS = "EuropeanRMBS"
    """
    Broker Confirmation Type for Single Name European RMBS Transactions.
    """
    JAPAN_CORPORATE = "JapanCorporate"
    """
    Broker Confirmation Type of Japan Corporate.
    """
    JAPAN_SOVEREIGN = "JapanSovereign"
    """
    Broker Confirmation Type of Japan Sovereign.
    """
    LATIN_AMERICA_CORPORATE = "LatinAmericaCorporate"
    """
    Broker Confirmation Type of Latin America Corporate.
    """
    LATIN_AMERICA_CORPORATE_BOND = "LatinAmericaCorporateBond"
    """
    Broker Confirmation Type for LATIN AMERICA CORPORATE B.
    """
    LATIN_AMERICA_CORPORATE_BOND_OR_LOAN = "LatinAmericaCorporateBondOrLoan"
    """
    Broker Confirmation Type for LATIN AMERICA CORPORATE BL.
    """
    LATIN_AMERICA_SOVEREIGN = "LatinAmericaSovereign"
    """
    Broker Confirmation Type of Latin America Sovereign.
    """
    MBX = "MBX"
    """
    Broker Confirmation Type for MBX Transactions.
    """
    MCDX = "MCDX"
    """
    Broker Confirmation Type for Municipal CDX Untranched Transactions.
    """
    NEW_ZEALAND_CORPORATE = "NewZealandCorporate"
    """
    Broker Confirmation Type of New Zealand Corporate.
    """
    NEW_ZEALAND_SOVEREIGN = "NewZealandSovereign"
    """
    Broker Confirmation Type of New Zealand Sovereign.
    """
    NORTH_AMERICAN_CORPORATE = "NorthAmericanCorporate"
    """
    Broker ConfirmationType of North American Corporate.
    """
    PO = "PO"
    """
    Broker Confirmation Type for PO Index Transactions.
    """
    SINGAPORE_CORPORATE = "SingaporeCorporate"
    """
    Broker Confirmation Type of Singapore Corporate.
    """
    SINGAPORE_SOVEREIGN = "SingaporeSovereign"
    """
    Broker Confirmation Type of Singapore Sovereign.
    """
    STANDARD_ASIA_CORPORATE = "StandardAsiaCorporate"
    """
    Broker Confirmation Type of STANDARD ASIA CORPORATE.
    """
    STANDARD_ASIA_SOVEREIGN = "StandardAsiaSovereign"
    """
    Broker Confirmation Type of STANDARD ASIA SOVEREIGN.
    """
    STANDARD_AUSTRALIA_CORPORATE = "StandardAustraliaCorporate"
    """
    Broker Confirmation Type of STANDARD AUSTRALIA CORPORATE.
    """
    STANDARD_AUSTRALIA_SOVEREIGN = "StandardAustraliaSovereign"
    """
    Broker Confirmation Type of STANDARD AUSTRALIA SOVEREIGN.
    """
    STANDARD_CDX_TRANCHE = "StandardCDXTranche"
    """
    Broker Confirmation Type for Standard CDX Tranche Transactions.
    """
    STANDARD_EMERGING_EUROPEAN_AND_MIDDLE_EASTERN_SOVEREIGN = "StandardEmergingEuropeanAndMiddleEasternSovereign"
    """
    Broker Confirmation Type of STANDARD EMERGING EUROPEAN AND MIDDLE EASTERN SOVEREIGN.
    """
    STANDARD_EMERGING_EUROPEAN_CORPORATE = "StandardEmergingEuropeanCorporate"
    """
    Broker Confirmation Type of STANDARD EMERGING EUROPEAN CORPORATE.
    """
    STANDARD_EMERGING_EUROPEAN_CORPORATE_LPN = "StandardEmergingEuropeanCorporateLPN"
    """
    Broker Confirmation Type of STANDARD EMERGING EUROPEAN CORPORATE LPN.
    """
    STANDARD_EUROPEAN_CORPORATE = "StandardEuropeanCorporate"
    """
    Broker Confirmation Type for STANDARD EUROPEAN CORPORATE.
    """
    STANDARD_JAPAN_CORPORATE = "StandardJapanCorporate"
    """
    Broker Confirmation Type of STANDARD JAPAN CORPORATE.
    """
    STANDARD_JAPAN_SOVEREIGN = "StandardJapanSovereign"
    """
    Broker Confirmation Type of STANDARD JAPAN SOVEREIGN.
    """
    STANDARD_LCDS = "StandardLCDS"
    """
    Standard Syndicated Secured Loan Credit Default Swap Broker Confirmation Type.
    """
    STANDARD_LCDS_BULLET = "StandardLCDSBullet"
    """
    Broker Confirmation Type for Standard Syndicated Secured Loan Credit Default Swap Bullet Transactions.
    """
    STANDARD_LCDX_BULLET = "StandardLCDXBullet"
    """
    Broker Confirmation Type for Standard Syndicated Secured Loan Credit Default Swap Index Bullet Transactions.
    """
    STANDARD_LCDX_BULLET_TRANCHE = "StandardLCDXBulletTranche"
    """
    Broker Confirmation Type for Standard Syndicated Secured Loan Credit Default Swap Index Bullet Tranche Transactions.
    """
    STANDARD_LATIN_AMERICA_CORPORATE_BOND = "StandardLatinAmericaCorporateBond"
    """
    Broker Confirmation Type of STANDARD LATIN AMERICA CORPORATE B.
    """
    STANDARD_LATIN_AMERICA_CORPORATE_BOND_OR_LOAN = "StandardLatinAmericaCorporateBondOrLoan"
    """
    Broker Confirmation Type of STANDARD LATIN AMERICA CORPORATE BL.
    """
    STANDARD_LATIN_AMERICA_SOVEREIGN = "StandardLatinAmericaSovereign"
    """
    Broker Confirmation Type of STANDARD LATIN AMERICA SOVEREIGN.
    """
    STANDARD_NEW_ZEALAND_CORPORATE = "StandardNewZealandCorporate"
    """
    Broker Confirmation Type of STANDARD NEW ZEALAND CORPORATE.
    """
    STANDARD_NEW_ZEALAND_SOVEREIGN = "StandardNewZealandSovereign"
    """
    Broker Confirmation Type of STANDARD NEW ZEALAND SOVEREIGN.
    """
    STANDARD_NORTH_AMERICAN_CORPORATE = "StandardNorthAmericanCorporate"
    """
    Broker Confirmation Type for STANDARD NORTH AMERICAN CORPORATE.
    """
    STANDARD_SINGAPORE_CORPORATE = "StandardSingaporeCorporate"
    """
    Broker Confirmation Type of STANDARD SINGAPORE CORPORATE.
    """
    STANDARD_SINGAPORE_SOVEREIGN = "StandardSingaporeSovereign"
    """
    Broker Confirmation Type of STANDARD SINGAPORE SOVEREIGN.
    """
    STANDARD_SUBORDINATED_EUROPEAN_INSURANCE_CORPORATE = "StandardSubordinatedEuropeanInsuranceCorporate"
    """
    Broker Confirmation Type for STANDARD SUBORDINATED EUROPEAN INSURANCE CORPORATE.
    """
    STANDARD_WESTERN_EUROPEAN_SOVEREIGN = "StandardWesternEuropeanSovereign"
    """
    Broker Confirmation Type for STANDARD WESTERN EUROPEAN SOVEREIGN.
    """
    STANDARDI_TRAXX_EUROPE_TRANCHE = "StandardiTraxxEuropeTranche"
    """
    Broker Confirmation Type for Standard iTraxx Europe Tranched Transactions.
    """
    SUBORDINATED_EUROPEAN_INSURANCE_CORPORATE = "SubordinatedEuropeanInsuranceCorporate"
    """
    Broker Confirmation Type of Subordinated European Insurance Corporate.
    """
    SUKUK_CORPORATE = "SukukCorporate"
    """
    Broker Confirmation Type of SUKUK CORPORATE.
    """
    SUKUK_SOVEREIGN = "SukukSovereign"
    """
    Broker Confirmation Type of SUKUK SOVEREIGN.
    """
    SYNDICATED_SECURED_LOAN_CDS = "SyndicatedSecuredLoanCDS"
    """
    Syndicated Secured Loan Credit Default Swap Broker Confirmation Type.
    """
    TRX = "TRX"
    """
    Broker Confirmation Type for TRX Transactions.
    """
    TRX_II = "TRX.II"
    """
    Broker Confirmation Type for TRX.II Transactions.
    """
    US_MUNICIPAL_FULL_FAITH_AND_CREDIT = "USMunicipalFullFaithAndCredit"
    """
    Broker Confirmation Type for U.S. MUNICIPAL FULL FAITH AND CREDIT.
    """
    US_MUNICIPAL_GENERAL_FUND = "USMunicipalGeneralFund"
    """
    Broker Confirmation Type for U.S. MUNICIPAL GENERAL FUND.
    """
    US_MUNICIPAL_REVENUE = "USMunicipalRevenue"
    """
    Broker Confirmation Type for U.S. MUNICIPAL REVENUE.
    """
    WESTERN_EUROPEAN_SOVEREIGN = "WesternEuropeanSovereign"
    """
    Broker Confirmation Type of Western European Sovereign.
    """
    I_TRAXX_ASIA_EX_JAPAN = "iTraxxAsiaExJapan"
    """
    Broker Confirmation Type for iTraxx Asia Excluding Japan.
    """
    I_TRAXX_ASIA_EX_JAPAN_SWAPTION = "iTraxxAsiaExJapanSwaption"
    """
    Broker Confirmation Type for iTraxx Asia Ex-Japan Swaption Transactions.
    """
    I_TRAXX_ASIA_EX_JAPAN_TRANCHE = "iTraxxAsiaExJapanTranche"
    """
    Broker Confirmation Type for iTraxx Asia Excluding Japan Tranched Transactions.
    """
    I_TRAXX_AUSTRALIA = "iTraxxAustralia"
    """
    Broker Confirmation Type for iTraxx Australia.
    """
    I_TRAXX_AUSTRALIA_SWAPTION = "iTraxxAustraliaSwaption"
    """
    Broker Confirmation Type for iTraxx Australia Swaption Transactions.
    """
    I_TRAXX_AUSTRALIA_TRANCHE = "iTraxxAustraliaTranche"
    """
    Broker Confirmation Type for iTraxx Australia Tranched Transactions.
    """
    I_TRAXX_CJ = "iTraxxCJ"
    """
    Broker Confirmation Type for iTraxx CJ.
    """
    I_TRAXX_CJ_TRANCHE = "iTraxxCJTranche"
    """
    Broker Confirmation Type for iTraxx CJ Tranched Transactions.
    """
    I_TRAXX_EUROPE = "iTraxxEurope"
    """
    Broker Confirmation Type for iTraxx Europe Transactions
    """
    I_TRAXX_EUROPE_SWAPTION = "iTraxxEuropeSwaption"
    """
    Broker Confirmation Type for iTraxx Europe Swaption Transactions.
    """
    I_TRAXX_EUROPE_TRANCHE = "iTraxxEuropeTranche"
    """
    Broker Confirmation Type for iTraxx Europe Tranched Transactions.
    """
    I_TRAXX_JAPAN = "iTraxxJapan"
    """
    Broker Confirmation Type for iTraxx Japan.
    """
    I_TRAXX_JAPAN_SWAPTION = "iTraxxJapanSwaption"
    """
    Broker Confirmation Type for iTraxx Japan Swaption Transactions.
    """
    I_TRAXX_JAPAN_TRANCHE = "iTraxxJapanTranche"
    """
    Broker Confirmation Type for iTraxx Japan Tranched Transactions.
    """
    I_TRAXX_LEV_X = "iTraxxLevX"
    """
    Broker Confirmation Type for iTraxx LevX.
    """
    I_TRAXX_SDI_75 = "iTraxxSDI75"
    """
    Broker Confirmation Type for iTraxx SDI 75 Transactions.
    """
    I_TRAXX_SOV_X = "iTraxxSovX"
    """
    Broker Confirmation Type for iTraxx SovX.
    """
