# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SpecifiedEntities']


class SpecifiedEntities(BaseDataClass):
    """
    A provision that allows each party to specify its Specified Entities for certain Events of Default and Termination Events.
    """
    specifiedEntityClause: cdm.legaldocumentation.common.SpecifiedEntityClauseEnum.SpecifiedEntityClauseEnum = Field(..., description="The Event of Default or Termination event for which Specified Entities terms are being defined.")
    """
    The Event of Default or Termination event for which Specified Entities terms are being defined.
    """
    specifiedEntity: List[cdm.legaldocumentation.master.isda.SpecifiedEntity.SpecifiedEntity] = Field([], description="The party specific election of Specified Entities for the Event of Default or Termination Event specified.")
    """
    The party specific election of Specified Entities for the Event of Default or Termination Event specified.
    """
    @rosetta_condition
    def cardinality_specifiedEntity(self):
        return check_cardinality(self.specifiedEntity, 2, None)
    

import cdm 
import cdm.legaldocumentation.common.SpecifiedEntityClauseEnum
import cdm.legaldocumentation.master.isda.SpecifiedEntity
