# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['MasterAgreementElections']


class MasterAgreementElections(BaseDataClass):
    """
    A representation of a master agreement extended from a base agreement of shared elections.
    """
    islaGmsla: Optional[cdm.legaldocumentation.master.isla.GlobalMasterSecuritiesLendingAgreement.GlobalMasterSecuritiesLendingAgreement] = Field(None, description="The set of elections that define a GMSLA.")
    """
    The set of elections that define a GMSLA.
    """
    icmaGmra: Optional[cdm.legaldocumentation.master.icma.GlobalMasterRepoAgreement.GlobalMasterRepoAgreement] = Field(None, description="The set of elections that define a GMRA.")
    """
    The set of elections that define a GMRA.
    """
    isdaMaster: Optional[cdm.legaldocumentation.master.isda.MasterAgreement.MasterAgreement] = Field(None, description="The set of elections that define an ISDA Master Agreement.")
    """
    The set of elections that define an ISDA Master Agreement.
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'islaGmsla', 'icmaGmra', 'isdaMaster', necessity=True)

import cdm 
import cdm.legaldocumentation.master.isla.GlobalMasterSecuritiesLendingAgreement
import cdm.legaldocumentation.master.icma.GlobalMasterRepoAgreement
import cdm.legaldocumentation.master.isda.MasterAgreement
