# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['MTAFixedAmount']


class MTAFixedAmount(BaseDataClass):
    """
    Defines that the Minimum Transfer Amount (MTA) is a Fixed Amount.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The party to which the Minimum Transfer Amount (MTA) applies.")
    """
    The party to which the Minimum Transfer Amount (MTA) applies.
    """
    amount: int = Field(..., description="The amount value applicable to the Minimum Transfer Amount (MTA).")
    """
    The amount value applicable to the Minimum Transfer Amount (MTA).
    """
    currency: cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum.ISOCurrencyCodeEnum = Field(..., description="The minimum transfer amount currency code.")
    """
    The minimum transfer amount currency code.
    """

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum
