# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['LegacyValuationAgentEnum']

class LegacyValuationAgentEnum(Enum):
    """
    Specifies how the Valuation Agent is determined.
    """
    FIXED_PARTY_FOR_DISPUTES = "FixedPartyForDisputes"
    """
    There is a fixed party for disputes.
    """
    SOLE_VALUATION_AGENT = "SoleValuationAgent"
    """
    There is only a Sole Valuation Agent.
    """
    SWITCH_UPON_DEFAULT = "SwitchUponDefault"
    """
    Switch of Valuation Agent can occur upon Default.
    """
    SWITCH_UPON_FAILURE_TO_PERFORM = "SwitchUponFailureToPerform"
    """
    Switch of Valuation Agent can occur upon failure to perform.
    """
