# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['InterestAdjustmentPeriodicity']


class InterestAdjustmentPeriodicity(BaseDataClass):
    """
    A class to specify the Interest Adjustment periodicity.
    """
    standardElection: Optional[cdm.legaldocumentation.csa.InterestAdjustmentPeriodicityEnum.InterestAdjustmentPeriodicityEnum] = Field(None, description="The Interest Adjustment periodicity when specified through a standardized election.")
    """
    The Interest Adjustment periodicity when specified through a standardized election.
    """
    customElection: Optional[str] = Field(None, description="The Interest Adjustment periodicity when specified through a custom election.")
    """
    The Interest Adjustment periodicity when specified through a custom election.
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'standardElection', 'customElection', necessity=True)

import cdm 
import cdm.legaldocumentation.csa.InterestAdjustmentPeriodicityEnum
