# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CustodianTerms']


class CustodianTerms(BaseDataClass):
    """
    A class to specify the requirements applicable to the custodian with respect to the holding of posted collateral.
    """
    minimumAssets: Optional[cdm.observable.asset.Money.Money] = Field(None, description="The minimal level of assets requirement with respect to the custody agent.")
    """
    The minimal level of assets requirement with respect to the custody agent.
    """
    minimumRating: Optional[cdm.observable.asset.CreditNotation.CreditNotation] = Field(None, description="The minimal rating requirement with respect to the custody agent.")
    """
    The minimal rating requirement with respect to the custody agent.
    """
    initialDesignation: Optional[cdm.base.staticdata.party.LegalEntity.LegalEntity] = Field(None, description="Election to specify the initial custodian.")
    """
    Election to specify the initial custodian.
    """

import cdm 
import cdm.observable.asset.Money
import cdm.observable.asset.CreditNotation
import cdm.base.staticdata.party.LegalEntity
