# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Custodian']


class Custodian(BaseDataClass):
    """
    A class to specify the custodian and custody account details for each party to the agreement.
    """
    partyElection: List[cdm.legaldocumentation.csa.CustodianElection.CustodianElection] = Field([], description="The party specific elections.")
    """
    The party specific elections.
    """
    @rosetta_condition
    def cardinality_partyElection(self):
        return check_cardinality(self.partyElection, 2, None)
    

import cdm 
import cdm.legaldocumentation.csa.CustodianElection
