# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CreditSupportProviderElection']


class CreditSupportProviderElection(BaseDataClass):
    """
    The party election of Credit Support Provider(s), if any.
    """
    party: cdm.base.staticdata.party.Party.Party = Field(..., description="The elective party.")
    """
    The elective party.
    """
    creditSupportProviderTerms: cdm.legaldocumentation.common.CreditSupportProviderTermsEnum.CreditSupportProviderTermsEnum = Field(..., description="Specification of the Credit Support Provider terms.")
    """
    Specification of the Credit Support Provider terms.
    """
    creditSupportProvider: List[cdm.base.staticdata.party.LegalEntity.LegalEntity] = Field([], description="The specified Credit Support Provider(s), if any.")
    """
    The specified Credit Support Provider(s), if any.
    """
    bespokeCreditSuppportProvider: Optional[str] = Field(None, description="...")
    """
    ...
    """
    
    @rosetta_condition
    def condition_0_CreditSupportProvider(self):
        """
        A validation rule to ensure that a Credit Support Provider is specified when required.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "creditSupportProvider"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "creditSupportProviderTerms"), "=", rosetta_resolve_attr(CreditSupportProviderTermsEnum, "SPECIFIED")), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.Party
import cdm.legaldocumentation.common.CreditSupportProviderTermsEnum
import cdm.base.staticdata.party.LegalEntity
from cdm.legaldocumentation.common.CreditSupportProviderTermsEnum import CreditSupportProviderTermsEnum
