# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.datetime.functions.ResolveAdjustableDate import ResolveAdjustableDate
from cdm.event.common.functions.AdjustedValuationDates import AdjustedValuationDates
from cdm.event.common.functions.ResolvePerformanceValuationTime import ResolvePerformanceValuationTime
from cdm.product.template.PerformancePayout import PerformancePayout
from cdm.observable.event.ObservationIdentifier import ObservationIdentifier

__all__ = ['ResolvePerformanceObservationIdentifiers']


@replaceable
def ResolvePerformanceObservationIdentifiers(payout: PerformancePayout, adjustedDate: datetime.date) -> ObservationIdentifier:
    """
    Defines which attributes on the PerformancePayout should be used to locate and resolve the underlier's price, for example for the reset process.
    
    Parameters 
    ----------
    payout : PerformancePayout
    
    adjustedDate : date
    
    Returns
    -------
    identifiers : ObservationIdentifier
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "valuationDates"), "interimValuationDate")
    
    def _else_fn0():
        return rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "valuationDates"), "finalValuationDate")
    
    adjustedFinalValuationDate = ResolveAdjustableDate(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "valuationDates"), "finalValuationDate"), "valuationDate"))
    valuationDates = if_cond_fn(all_elements(rosetta_resolve_attr(self, "adjustedDate"), "<", rosetta_resolve_attr(self, "adjustedFinalValuationDate")), _then_fn0, _else_fn0)
    identifiers = _get_rosetta_object('ObservationIdentifier', 'observable', rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "underlier"), "Observable"))
    identifiers = set_rosetta_attr(rosetta_resolve_attr(self, 'identifiers'), 'observationDate', (lambda item: item[-1])(rosetta_filter(AdjustedValuationDates(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "valuationDates")), lambda item: all_elements(item, "<=", rosetta_resolve_attr(self, "adjustedDate")))))
    identifiers = set_rosetta_attr(rosetta_resolve_attr(self, 'identifiers'), 'observationTime', ResolvePerformanceValuationTime(rosetta_resolve_attr(rosetta_resolve_attr(self, "valuationDates"), "valuationTime"), rosetta_resolve_attr(rosetta_resolve_attr(self, "valuationDates"), "valuationTimeType"), get_only_element(rosetta_resolve_deep_attr(self, "identifier")), rosetta_resolve_attr(rosetta_resolve_attr(self, "valuationDates"), "determinationMethod")))
    identifiers = set_rosetta_attr(rosetta_resolve_attr(self, 'identifiers'), 'informationSource', rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "observationTerms"), "informationSource"), "primarySource"))
    identifiers = set_rosetta_attr(rosetta_resolve_attr(self, 'identifiers'), 'determinationMethodology->determinationMethod', rosetta_resolve_attr(rosetta_resolve_attr(self, "valuationDates"), "determinationMethod"))
    
    
    return identifiers

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
