# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.observable.asset.PriceQuantity import PriceQuantity

__all__ = ['FindMatchingIndexTransitionInstruction']


@replaceable
def FindMatchingIndexTransitionInstruction(instructions: list[PriceQuantity], priceQuantity: PriceQuantity) -> PriceQuantity:
    """
    
    Parameters 
    ----------
    instructions : PriceQuantity
    
    priceQuantity : PriceQuantity
    
    Returns
    -------
    matchingInstruction : PriceQuantity
    
    """
    self = inspect.currentframe()
    
    
    matchingInstruction =  (lambda item: item[0])(rosetta_filter(rosetta_resolve_attr(self, "instructions"), lambda item: ((all_elements(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "indexTenor"), "period"), "=", rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "indexTenor"), "period")) and all_elements(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "indexTenor"), "periodMultiplier"), "=", rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "indexTenor"), "periodMultiplier"))) and (all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(item, "quantity"), "unit"), "currency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "priceQuantity"), "quantity"), "unit"), "currency")) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(item, "price"), "unit"), "currency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "priceQuantity"), "price"), "unit"), "currency"))))))
    
    
    return matchingInstruction

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
