/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="EconomicTermsNotionalResetInterestRatePayoutExists")
@ImplementedBy(value=Default.class)
public interface EconomicTermsNotionalResetInterestRatePayoutExists
extends Validator<EconomicTerms> {
    public static final String NAME = "EconomicTermsNotionalResetInterestRatePayoutExists";
    public static final String DEFINITION = "if payout -> PerformancePayout -> priceQuantity -> reset contains True then payout -> InterestRatePayout exists";

    public static class NoOp
    implements EconomicTermsNotionalResetInterestRatePayoutExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EconomicTerms economicTerms) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements EconomicTermsNotionalResetInterestRatePayoutExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EconomicTerms economicTerms) {
            ComparisonResult result = this.executeDataRule(economicTerms);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)EconomicTermsNotionalResetInterestRatePayoutExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsNotionalResetInterestRatePayoutExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)EconomicTermsNotionalResetInterestRatePayoutExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EconomicTerms", (RosettaPath)path, (String)EconomicTermsNotionalResetInterestRatePayoutExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(EconomicTerms economicTerms) {
            try {
                if (ExpressionOperators.contains((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getPriceQuantity", performancePayout -> performancePayout.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()), (Mapper)MapperS.of((Object)true)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)economicTerms).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

