/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.qualification.functions;

import cdm.base.staticdata.asset.common.FundProductTypeEnum;
import cdm.base.staticdata.asset.common.Instrument;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.base.staticdata.asset.common.util.InstrumentDeepPathUtil;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

@ImplementedBy(value=Qualify_InstrumentTypeEquityDefault.class)
public abstract class Qualify_InstrumentTypeEquity
implements RosettaFunction {
    @Inject
    protected InstrumentDeepPathUtil instrumentDeepPathUtil;

    public Boolean evaluate(Instrument instrument) {
        Boolean is_equity = this.doEvaluate(instrument);
        return is_equity;
    }

    protected abstract Boolean doEvaluate(Instrument var1);

    protected abstract MapperS<InstrumentTypeEnum> instrumentType(Instrument var1);

    public static class Qualify_InstrumentTypeEquityDefault
    extends Qualify_InstrumentTypeEquity {
        @Override
        protected Boolean doEvaluate(Instrument instrument) {
            Boolean is_equity = null;
            return this.assignOutput(is_equity, instrument);
        }

        protected Boolean assignOutput(Boolean is_equity, Instrument instrument) {
            is_equity = ExpressionOperators.areEqual(this.instrumentType(instrument), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual(this.instrumentType(instrument), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.FUND)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instrument).map("getSecurity", _instrument -> _instrument.getSecurity()).map("getFundType", security -> security.getFundType()), (Mapper)MapperS.of((Object)((Object)FundProductTypeEnum.EXCHANGE_TRADED_FUND)), (CardinalityOperator)CardinalityOperator.All))).or(ExpressionOperators.areEqual(this.instrumentType(instrument), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.FUND)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instrument).map("getSecurity", _instrument -> _instrument.getSecurity()).map("getFundType", security -> security.getFundType()), (Mapper)MapperS.of((Object)((Object)FundProductTypeEnum.MUTUAL_FUND)), (CardinalityOperator)CardinalityOperator.All))).or(ExpressionOperators.areEqual(this.instrumentType(instrument), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.WARRANT)), (CardinalityOperator)CardinalityOperator.All)).get();
            return is_equity;
        }

        @Override
        protected MapperS<InstrumentTypeEnum> instrumentType(Instrument instrument) {
            return MapperS.of((Object)instrument).map("chooseInstrumentType", _instrument -> this.instrumentDeepPathUtil.chooseInstrumentType((Instrument)_instrument));
        }
    }
}

