/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.CashPriceTypeEnum;
import cdm.observable.asset.FeeTypeEnum;
import cdm.observable.asset.PremiumExpression;
import cdm.observable.asset.meta.CashPriceMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CashPrice", builder=CashPriceBuilderImpl.class, version="6.10.0")
@RuneDataType(value="CashPrice", model="cdm", builder=CashPriceBuilderImpl.class, version="6.10.0")
public interface CashPrice
extends RosettaModelObject {
    public static final CashPriceMeta metaData = new CashPriceMeta();

    public CashPriceTypeEnum getCashPriceType();

    public PremiumExpression getPremiumExpression();

    public FeeTypeEnum getFeeType();

    public CashPrice build();

    public CashPriceBuilder toBuilder();

    public static CashPriceBuilder builder() {
        return new CashPriceBuilderImpl();
    }

    default public RosettaMetaData<? extends CashPrice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CashPrice> getType() {
        return CashPrice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("cashPriceType"), CashPriceTypeEnum.class, (Object)this.getCashPriceType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premiumExpression"), processor, PremiumExpression.class, this.getPremiumExpression(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("feeType"), FeeTypeEnum.class, (Object)this.getFeeType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CashPriceBuilderImpl
    implements CashPriceBuilder {
        protected CashPriceTypeEnum cashPriceType;
        protected PremiumExpression.PremiumExpressionBuilder premiumExpression;
        protected FeeTypeEnum feeType;

        @Override
        @RosettaAttribute(value="cashPriceType", isRequired=true)
        @RuneAttribute(value="cashPriceType", isRequired=true)
        public CashPriceTypeEnum getCashPriceType() {
            return this.cashPriceType;
        }

        @Override
        @RosettaAttribute(value="premiumExpression")
        @RuneAttribute(value="premiumExpression")
        public PremiumExpression.PremiumExpressionBuilder getPremiumExpression() {
            return this.premiumExpression;
        }

        @Override
        public PremiumExpression.PremiumExpressionBuilder getOrCreatePremiumExpression() {
            PremiumExpression.PremiumExpressionBuilder result = this.premiumExpression != null ? this.premiumExpression : (this.premiumExpression = PremiumExpression.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="feeType")
        @RuneAttribute(value="feeType")
        public FeeTypeEnum getFeeType() {
            return this.feeType;
        }

        @Override
        @RosettaAttribute(value="cashPriceType", isRequired=true)
        @RuneAttribute(value="cashPriceType", isRequired=true)
        public CashPriceBuilder setCashPriceType(CashPriceTypeEnum _cashPriceType) {
            this.cashPriceType = _cashPriceType == null ? null : _cashPriceType;
            return this;
        }

        @Override
        @RosettaAttribute(value="premiumExpression")
        @RuneAttribute(value="premiumExpression")
        public CashPriceBuilder setPremiumExpression(PremiumExpression _premiumExpression) {
            this.premiumExpression = _premiumExpression == null ? null : _premiumExpression.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="feeType")
        @RuneAttribute(value="feeType")
        public CashPriceBuilder setFeeType(FeeTypeEnum _feeType) {
            this.feeType = _feeType == null ? null : _feeType;
            return this;
        }

        @Override
        public CashPrice build() {
            return new CashPriceImpl(this);
        }

        @Override
        public CashPriceBuilder toBuilder() {
            return this;
        }

        @Override
        public CashPriceBuilder prune() {
            if (this.premiumExpression != null && !this.premiumExpression.prune().hasData()) {
                this.premiumExpression = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCashPriceType() != null) {
                return true;
            }
            if (this.getPremiumExpression() != null && this.getPremiumExpression().hasData()) {
                return true;
            }
            return this.getFeeType() != null;
        }

        public CashPriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CashPriceBuilder o = (CashPriceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPremiumExpression(), (RosettaModelObjectBuilder)o.getPremiumExpression(), this::setPremiumExpression);
            merger.mergeBasic((Object)this.getCashPriceType(), (Object)o.getCashPriceType(), this::setCashPriceType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFeeType(), (Object)o.getFeeType(), this::setFeeType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashPrice _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.cashPriceType, (Object)_that.getCashPriceType())) {
                return false;
            }
            if (!Objects.equals(this.premiumExpression, _that.getPremiumExpression())) {
                return false;
            }
            return Objects.equals((Object)this.feeType, (Object)_that.getFeeType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashPriceType != null ? ((Object)((Object)this.cashPriceType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.premiumExpression != null ? this.premiumExpression.hashCode() : 0);
            _result = 31 * _result + (this.feeType != null ? ((Object)((Object)this.feeType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashPriceBuilder {cashPriceType=" + (Object)((Object)this.cashPriceType) + ", premiumExpression=" + this.premiumExpression + ", feeType=" + (Object)((Object)this.feeType) + '}';
        }
    }

    public static interface CashPriceBuilder
    extends CashPrice,
    RosettaModelObjectBuilder {
        public PremiumExpression.PremiumExpressionBuilder getOrCreatePremiumExpression();

        @Override
        public PremiumExpression.PremiumExpressionBuilder getPremiumExpression();

        public CashPriceBuilder setCashPriceType(CashPriceTypeEnum var1);

        public CashPriceBuilder setPremiumExpression(PremiumExpression var1);

        public CashPriceBuilder setFeeType(FeeTypeEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("cashPriceType"), CashPriceTypeEnum.class, (Object)this.getCashPriceType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premiumExpression"), processor, PremiumExpression.PremiumExpressionBuilder.class, this.getPremiumExpression(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("feeType"), FeeTypeEnum.class, (Object)this.getFeeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CashPriceBuilder prune();
    }

    public static class CashPriceImpl
    implements CashPrice {
        private final CashPriceTypeEnum cashPriceType;
        private final PremiumExpression premiumExpression;
        private final FeeTypeEnum feeType;

        protected CashPriceImpl(CashPriceBuilder builder) {
            this.cashPriceType = builder.getCashPriceType();
            this.premiumExpression = Optional.ofNullable(builder.getPremiumExpression()).map(f -> f.build()).orElse(null);
            this.feeType = builder.getFeeType();
        }

        @Override
        @RosettaAttribute(value="cashPriceType", isRequired=true)
        @RuneAttribute(value="cashPriceType", isRequired=true)
        public CashPriceTypeEnum getCashPriceType() {
            return this.cashPriceType;
        }

        @Override
        @RosettaAttribute(value="premiumExpression")
        @RuneAttribute(value="premiumExpression")
        public PremiumExpression getPremiumExpression() {
            return this.premiumExpression;
        }

        @Override
        @RosettaAttribute(value="feeType")
        @RuneAttribute(value="feeType")
        public FeeTypeEnum getFeeType() {
            return this.feeType;
        }

        @Override
        public CashPrice build() {
            return this;
        }

        @Override
        public CashPriceBuilder toBuilder() {
            CashPriceBuilder builder = CashPrice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashPriceBuilder builder) {
            Optional.ofNullable(this.getCashPriceType()).ifPresent(builder::setCashPriceType);
            Optional.ofNullable(this.getPremiumExpression()).ifPresent(builder::setPremiumExpression);
            Optional.ofNullable(this.getFeeType()).ifPresent(builder::setFeeType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashPrice _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.cashPriceType, (Object)_that.getCashPriceType())) {
                return false;
            }
            if (!Objects.equals(this.premiumExpression, _that.getPremiumExpression())) {
                return false;
            }
            return Objects.equals((Object)this.feeType, (Object)_that.getFeeType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashPriceType != null ? ((Object)((Object)this.cashPriceType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.premiumExpression != null ? this.premiumExpression.hashCode() : 0);
            _result = 31 * _result + (this.feeType != null ? ((Object)((Object)this.feeType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashPrice {cashPriceType=" + (Object)((Object)this.cashPriceType) + ", premiumExpression=" + this.premiumExpression + ", feeType=" + (Object)((Object)this.feeType) + '}';
        }
    }
}

