/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common;

import cdm.base.staticdata.party.PartyContactInformation;
import cdm.legaldocumentation.common.meta.AddressForNoticesMeta;
import cdm.product.collateral.ContactElection;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AddressForNotices", builder=AddressForNoticesBuilderImpl.class, version="6.10.0")
@RuneDataType(value="AddressForNotices", model="cdm", builder=AddressForNoticesBuilderImpl.class, version="6.10.0")
public interface AddressForNotices
extends RosettaModelObject {
    public static final AddressForNoticesMeta metaData = new AddressForNoticesMeta();

    public ContactElection getPrimaryNotices();

    public List<? extends PartyContactInformation> getAdditionalNotices();

    public AddressForNotices build();

    public AddressForNoticesBuilder toBuilder();

    public static AddressForNoticesBuilder builder() {
        return new AddressForNoticesBuilderImpl();
    }

    default public RosettaMetaData<? extends AddressForNotices> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AddressForNotices> getType() {
        return AddressForNotices.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("primaryNotices"), processor, ContactElection.class, this.getPrimaryNotices(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalNotices"), processor, PartyContactInformation.class, this.getAdditionalNotices(), new AttributeMeta[0]);
    }

    public static class AddressForNoticesBuilderImpl
    implements AddressForNoticesBuilder {
        protected ContactElection.ContactElectionBuilder primaryNotices;
        protected List<PartyContactInformation.PartyContactInformationBuilder> additionalNotices = new ArrayList<PartyContactInformation.PartyContactInformationBuilder>();

        @Override
        @RosettaAttribute(value="primaryNotices", isRequired=true)
        @RuneAttribute(value="primaryNotices", isRequired=true)
        public ContactElection.ContactElectionBuilder getPrimaryNotices() {
            return this.primaryNotices;
        }

        @Override
        public ContactElection.ContactElectionBuilder getOrCreatePrimaryNotices() {
            ContactElection.ContactElectionBuilder result = this.primaryNotices != null ? this.primaryNotices : (this.primaryNotices = ContactElection.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalNotices")
        @RuneAttribute(value="additionalNotices")
        public List<? extends PartyContactInformation.PartyContactInformationBuilder> getAdditionalNotices() {
            return this.additionalNotices;
        }

        @Override
        public PartyContactInformation.PartyContactInformationBuilder getOrCreateAdditionalNotices(int index) {
            if (this.additionalNotices == null) {
                this.additionalNotices = new ArrayList<PartyContactInformation.PartyContactInformationBuilder>();
            }
            return (PartyContactInformation.PartyContactInformationBuilder)this.getIndex(this.additionalNotices, index, () -> {
                PartyContactInformation.PartyContactInformationBuilder newAdditionalNotices = PartyContactInformation.builder();
                return newAdditionalNotices;
            });
        }

        @Override
        @RosettaAttribute(value="primaryNotices", isRequired=true)
        @RuneAttribute(value="primaryNotices", isRequired=true)
        public AddressForNoticesBuilder setPrimaryNotices(ContactElection _primaryNotices) {
            this.primaryNotices = _primaryNotices == null ? null : _primaryNotices.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalNotices")
        @RuneAttribute(value="additionalNotices")
        public AddressForNoticesBuilder addAdditionalNotices(PartyContactInformation _additionalNotices) {
            if (_additionalNotices != null) {
                this.additionalNotices.add(_additionalNotices.toBuilder());
            }
            return this;
        }

        @Override
        public AddressForNoticesBuilder addAdditionalNotices(PartyContactInformation _additionalNotices, int idx) {
            this.getIndex(this.additionalNotices, idx, () -> _additionalNotices.toBuilder());
            return this;
        }

        @Override
        public AddressForNoticesBuilder addAdditionalNotices(List<? extends PartyContactInformation> additionalNoticess) {
            if (additionalNoticess != null) {
                for (PartyContactInformation partyContactInformation : additionalNoticess) {
                    this.additionalNotices.add(partyContactInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalNotices")
        public AddressForNoticesBuilder setAdditionalNotices(List<? extends PartyContactInformation> additionalNoticess) {
            this.additionalNotices = additionalNoticess == null ? new ArrayList<PartyContactInformation.PartyContactInformationBuilder>() : (List)additionalNoticess.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AddressForNotices build() {
            return new AddressForNoticesImpl(this);
        }

        @Override
        public AddressForNoticesBuilder toBuilder() {
            return this;
        }

        @Override
        public AddressForNoticesBuilder prune() {
            if (this.primaryNotices != null && !this.primaryNotices.prune().hasData()) {
                this.primaryNotices = null;
            }
            this.additionalNotices = this.additionalNotices.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPrimaryNotices() != null && this.getPrimaryNotices().hasData()) {
                return true;
            }
            return this.getAdditionalNotices() != null && this.getAdditionalNotices().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AddressForNoticesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AddressForNoticesBuilder o = (AddressForNoticesBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryNotices(), (RosettaModelObjectBuilder)o.getPrimaryNotices(), this::setPrimaryNotices);
            merger.mergeRosetta(this.getAdditionalNotices(), o.getAdditionalNotices(), this::getOrCreateAdditionalNotices);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AddressForNotices _that = this.getType().cast(o);
            if (!Objects.equals(this.primaryNotices, _that.getPrimaryNotices())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalNotices, _that.getAdditionalNotices());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.primaryNotices != null ? this.primaryNotices.hashCode() : 0);
            _result = 31 * _result + (this.additionalNotices != null ? this.additionalNotices.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AddressForNoticesBuilder {primaryNotices=" + this.primaryNotices + ", additionalNotices=" + this.additionalNotices + '}';
        }
    }

    public static interface AddressForNoticesBuilder
    extends AddressForNotices,
    RosettaModelObjectBuilder {
        public ContactElection.ContactElectionBuilder getOrCreatePrimaryNotices();

        @Override
        public ContactElection.ContactElectionBuilder getPrimaryNotices();

        public PartyContactInformation.PartyContactInformationBuilder getOrCreateAdditionalNotices(int var1);

        public List<? extends PartyContactInformation.PartyContactInformationBuilder> getAdditionalNotices();

        public AddressForNoticesBuilder setPrimaryNotices(ContactElection var1);

        public AddressForNoticesBuilder addAdditionalNotices(PartyContactInformation var1);

        public AddressForNoticesBuilder addAdditionalNotices(PartyContactInformation var1, int var2);

        public AddressForNoticesBuilder addAdditionalNotices(List<? extends PartyContactInformation> var1);

        public AddressForNoticesBuilder setAdditionalNotices(List<? extends PartyContactInformation> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("primaryNotices"), processor, ContactElection.ContactElectionBuilder.class, this.getPrimaryNotices(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalNotices"), processor, PartyContactInformation.PartyContactInformationBuilder.class, this.getAdditionalNotices(), new AttributeMeta[0]);
        }

        public AddressForNoticesBuilder prune();
    }

    public static class AddressForNoticesImpl
    implements AddressForNotices {
        private final ContactElection primaryNotices;
        private final List<? extends PartyContactInformation> additionalNotices;

        protected AddressForNoticesImpl(AddressForNoticesBuilder builder) {
            this.primaryNotices = Optional.ofNullable(builder.getPrimaryNotices()).map(f -> f.build()).orElse(null);
            this.additionalNotices = Optional.ofNullable(builder.getAdditionalNotices()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="primaryNotices", isRequired=true)
        @RuneAttribute(value="primaryNotices", isRequired=true)
        public ContactElection getPrimaryNotices() {
            return this.primaryNotices;
        }

        @Override
        @RosettaAttribute(value="additionalNotices")
        @RuneAttribute(value="additionalNotices")
        public List<? extends PartyContactInformation> getAdditionalNotices() {
            return this.additionalNotices;
        }

        @Override
        public AddressForNotices build() {
            return this;
        }

        @Override
        public AddressForNoticesBuilder toBuilder() {
            AddressForNoticesBuilder builder = AddressForNotices.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AddressForNoticesBuilder builder) {
            Optional.ofNullable(this.getPrimaryNotices()).ifPresent(builder::setPrimaryNotices);
            Optional.ofNullable(this.getAdditionalNotices()).ifPresent(builder::setAdditionalNotices);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AddressForNotices _that = this.getType().cast(o);
            if (!Objects.equals(this.primaryNotices, _that.getPrimaryNotices())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalNotices, _that.getAdditionalNotices());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.primaryNotices != null ? this.primaryNotices.hashCode() : 0);
            _result = 31 * _result + (this.additionalNotices != null ? this.additionalNotices.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AddressForNotices {primaryNotices=" + this.primaryNotices + ", additionalNotices=" + this.additionalNotices + '}';
        }
    }
}

