/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.position.PositionStatusEnum;
import cdm.observable.asset.PriceQuantity;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.common.NotionalAdjustmentEnum;
import cdm.product.common.settlement.functions.UpdateAmountForEachMatchingQuantity;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import cdm.product.template.functions.AddTradeLot;
import cdm.product.template.functions.FilterTradeLot;
import cdm.product.template.functions.ReplaceTradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_QuantityChangeDefault.class)
public abstract class Create_QuantityChange
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected AddTradeLot addTradeLot;
    @Inject
    protected FilterTradeLot filterTradeLot;
    @Inject
    protected ReplaceTradeLot replaceTradeLot;
    @Inject
    protected UpdateAmountForEachMatchingQuantity updateAmountForEachMatchingQuantity;

    public TradeState evaluate(QuantityChangeInstruction instruction, TradeState tradeState) {
        TradeState quantityChange;
        this.conditionValidator.validate(() -> {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instruction).map("getDirection", quantityChangeInstruction -> quantityChangeInstruction.getDirection()), (Mapper)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.DECREASE)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).mapC("getChange", quantityChangeInstruction -> quantityChangeInstruction.getChange()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instruction).mapC("getChange", quantityChangeInstruction -> quantityChangeInstruction.getChange()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.CASH_PRICE)), (CardinalityOperator)CardinalityOperator.All);
            }
            return ComparisonResult.successEmptyOperand((String)"");
        }, "Only termination where the termination price is specified as a cash price is supported for now.");
        TradeState.TradeStateBuilder quantityChangeBuilder = this.doEvaluate(instruction, tradeState);
        if (quantityChangeBuilder == null) {
            quantityChange = null;
        } else {
            quantityChange = quantityChangeBuilder.build();
            this.objectValidator.validate(TradeState.class, (RosettaModelObject)quantityChange);
        }
        return quantityChange;
    }

    protected abstract TradeState.TradeStateBuilder doEvaluate(QuantityChangeInstruction var1, TradeState var2);

    protected abstract MapperS<? extends Trade> trade(QuantityChangeInstruction var1, TradeState var2);

    protected abstract MapperS<Boolean> tradeLotExists(QuantityChangeInstruction var1, TradeState var2);

    protected abstract MapperC<? extends TradeLot> tradeLot(QuantityChangeInstruction var1, TradeState var2);

    protected abstract MapperC<? extends PriceQuantity> newPriceQuantity(QuantityChangeInstruction var1, TradeState var2);

    protected abstract MapperC<? extends TradeLot> newTradeLots(QuantityChangeInstruction var1, TradeState var2);

    public static class Create_QuantityChangeDefault
    extends Create_QuantityChange {
        @Override
        protected TradeState.TradeStateBuilder doEvaluate(QuantityChangeInstruction instruction, TradeState tradeState) {
            TradeState.TradeStateBuilder quantityChange = TradeState.builder();
            return this.assignOutput(quantityChange, instruction, tradeState);
        }

        protected TradeState.TradeStateBuilder assignOutput(TradeState.TradeStateBuilder quantityChange, QuantityChangeInstruction instruction, TradeState tradeState) {
            quantityChange = (TradeState.TradeStateBuilder)this.toBuilder(tradeState, () -> TradeState.builder());
            quantityChange.getOrCreateTrade().setProduct((NonTransferableProduct)this.trade(instruction, tradeState).map("getProduct", _trade -> _trade.getProduct()).get());
            quantityChange.getOrCreateTrade().setTradeLot(this.newTradeLots(instruction, tradeState).getMulti());
            quantityChange.getOrCreateTrade().setCounterparty(this.trade(instruction, tradeState).mapC("getCounterparty", _trade -> _trade.getCounterparty()).getMulti());
            quantityChange.getOrCreateTrade().setAncillaryParty(this.trade(instruction, tradeState).mapC("getAncillaryParty", _trade -> _trade.getAncillaryParty()).getMulti());
            quantityChange.getOrCreateTrade().setAdjustment((NotionalAdjustmentEnum)((Object)this.trade(instruction, tradeState).map("getAdjustment", _trade -> _trade.getAdjustment()).get()));
            PositionStatusEnum ifThenElseResult = null;
            if (ExpressionOperators.areEqual((Mapper)this.newTradeLots(instruction, tradeState).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult = PositionStatusEnum.CLOSED;
            }
            quantityChange.getOrCreateState().setPositionState(ifThenElseResult);
            return Optional.ofNullable(quantityChange).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends Trade> trade(QuantityChangeInstruction instruction, TradeState tradeState) {
            return MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade());
        }

        @Override
        protected MapperS<Boolean> tradeLotExists(QuantityChangeInstruction instruction, TradeState tradeState) {
            return ExpressionOperators.exists((Mapper)MapperC.of(this.filterTradeLot.evaluate(this.trade(instruction, tradeState).mapC("getTradeLot", _trade -> _trade.getTradeLot()).getMulti(), MapperS.of((Object)instruction).mapC("getLotIdentifier", quantityChangeInstruction -> quantityChangeInstruction.getLotIdentifier()).getMulti()))).asMapper();
        }

        @Override
        protected MapperC<? extends TradeLot> tradeLot(QuantityChangeInstruction instruction, TradeState tradeState) {
            if (((Boolean)this.tradeLotExists(instruction, tradeState).getOrDefault((Object)false)).booleanValue()) {
                return MapperC.of(this.filterTradeLot.evaluate(this.trade(instruction, tradeState).mapC("getTradeLot", _trade -> _trade.getTradeLot()).getMulti(), MapperS.of((Object)instruction).mapC("getLotIdentifier", quantityChangeInstruction -> quantityChangeInstruction.getLotIdentifier()).getMulti()));
            }
            return MapperC.of(Collections.singletonList((TradeLot)this.trade(instruction, tradeState).mapC("getTradeLot", _trade -> _trade.getTradeLot()).get()));
        }

        @Override
        protected MapperC<? extends PriceQuantity> newPriceQuantity(QuantityChangeInstruction instruction, TradeState tradeState) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instruction).map("getDirection", quantityChangeInstruction -> quantityChangeInstruction.getDirection()), (Mapper)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.INCREASE)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual(this.tradeLotExists(instruction, tradeState), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)instruction).mapC("getChange", quantityChangeInstruction -> quantityChangeInstruction.getChange());
            }
            return MapperC.of(this.updateAmountForEachMatchingQuantity.evaluate(this.tradeLot(instruction, tradeState).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).getMulti(), MapperS.of((Object)instruction).mapC("getChange", quantityChangeInstruction -> quantityChangeInstruction.getChange()).getMulti(), (QuantityChangeDirectionEnum)((Object)MapperS.of((Object)instruction).map("getDirection", quantityChangeInstruction -> quantityChangeInstruction.getDirection()).get())));
        }

        @Override
        protected MapperC<? extends TradeLot> newTradeLots(QuantityChangeInstruction instruction, TradeState tradeState) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instruction).map("getDirection", quantityChangeInstruction -> quantityChangeInstruction.getDirection()), (Mapper)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.INCREASE)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual(this.tradeLotExists(instruction, tradeState), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.addTradeLot.evaluate((TradableProduct)this.trade(instruction, tradeState).get(), TradeLot.builder().setLotIdentifier(MapperS.of((Object)instruction).mapC("getLotIdentifier", quantityChangeInstruction -> quantityChangeInstruction.getLotIdentifier()).getMulti()).setPriceQuantity(new ArrayList(this.newPriceQuantity(instruction, tradeState).getMulti())).build())).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot());
            }
            return MapperC.of(this.replaceTradeLot.evaluate(this.trade(instruction, tradeState).mapC("getTradeLot", _trade -> _trade.getTradeLot()).getMulti(), TradeLot.builder().setLotIdentifier(MapperS.of((Object)instruction).mapC("getLotIdentifier", quantityChangeInstruction -> quantityChangeInstruction.getLotIdentifier()).getMulti()).setPriceQuantity(new ArrayList(this.newPriceQuantity(instruction, tradeState).getMulti())).build()));
        }
    }
}

