# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SecurityLeg']


class SecurityLeg(BaseDataClass):
    """
     Terms defining a security leg in a securities financing transaction, which can either be the near leg or the far leg and is closely modelled onto the nearLeg and farLeg types in FpML
    """
    buyerSeller: cdm.base.staticdata.party.BuyerSeller.BuyerSeller = Field(..., description="Whether the leg is a buyer or seller of security")
    """
    Whether the leg is a buyer or seller of security
    """
    settlementDate: cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDate = Field(..., description="Settlement or Payment Date for the security leg")
    """
    Settlement or Payment Date for the security leg
    """
    settlementAmount: Optional[cdm.observable.asset.Money.Money] = Field(None, description="Settlement amount for the security leg")
    """
    Settlement amount for the security leg
    """
    settlementCurrency: Optional[str] = Field(None, description="Settlement Currency for use where the Settlement Amount cannot be known in advance.")
    """
    Settlement Currency for use where the Settlement Amount cannot be known in advance.
    """
    fxRate: Optional[cdm.observable.asset.ExchangeRate.ExchangeRate] = Field(None, description="FX rate in case when cash settlement amount is in a different currency to the security.")
    """
    FX rate in case when cash settlement amount is in a different currency to the security.
    """
    deliveryDate: Optional[cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDate] = Field(None, description="Delivery Date for the transaction. Delivery Date can be populated when it is not equal to the Settlement Date.")
    """
    Delivery Date for the transaction. Delivery Date can be populated when it is not equal to the Settlement Date.
    """
    deliveryMethod: cdm.product.common.settlement.DeliveryMethodEnum.DeliveryMethodEnum = Field(..., description="Specifies a delivery method for the security transaction.")
    """
    Specifies a delivery method for the security transaction.
    """
    
    @rosetta_condition
    def condition_0_SecurityLegChoice(self):
        item = self
        return rosetta_check_one_of(self, 'settlementAmount', 'settlementCurrency', necessity=True)

import cdm 
import cdm.base.staticdata.party.BuyerSeller
import cdm.base.datetime.AdjustableOrRelativeDate
import cdm.observable.asset.Money
import cdm.observable.asset.ExchangeRate
import cdm.product.common.settlement.DeliveryMethodEnum
