# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CheckEligibilityResult']


class CheckEligibilityResult(BaseDataClass):
    """
    Result for the CheckEligibilityByDetails and CheckEligibilityForProduct functions
    """
    isEligible: bool = Field(..., description="True if the asset is eligible")
    """
    True if the asset is eligible
    """
    matchingEligibleCriteria: List[cdm.product.collateral.EligibleCollateralCriteria.EligibleCollateralCriteria] = Field([], description="Eligible Collateral Criteria that matched the eligibility query")
    """
    Eligible Collateral Criteria that matched the eligibility query
    """
    @rosetta_condition
    def cardinality_matchingEligibleCriteria(self):
        return check_cardinality(self.matchingEligibleCriteria, 1, None)
    
    eligibilityQuery: Optional[cdm.product.collateral.EligibilityQuery.EligibilityQuery] = Field(None, description="eligibility query was was checked against the eligible collateral specification")
    """
    eligibility query was was checked against the eligible collateral specification
    """
    specification: cdm.product.collateral.EligibleCollateralSpecification.EligibleCollateralSpecification = Field(..., description="The eligible collateral specification that was queried")
    """
    The eligible collateral specification that was queried
    """

import cdm 
import cdm.product.collateral.EligibleCollateralCriteria
import cdm.product.collateral.EligibilityQuery
import cdm.product.collateral.EligibleCollateralSpecification
