# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CrossRate']

from cdm.observable.asset.QuotedCurrencyPair import QuotedCurrencyPair

class CrossRate(QuotedCurrencyPair):
    """
    A class that is used for including the currency exchange rates used to cross between the traded currencies for non-base currency FX contracts.
    """
    rate: Decimal = Field(..., description="The exchange rate used to cross between the traded currencies.")
    """
    The exchange rate used to cross between the traded currencies.
    """
    spotRate: Optional[Decimal] = Field(None, description="An optional element used for FX forwards and certain types of FX OTC options. For deals consummated in the FX Forwards Market, this represents the current market rate for a particular currency pair.")
    """
    An optional element used for FX forwards and certain types of FX OTC options. For deals consummated in the FX Forwards Market, this represents the current market rate for a particular currency pair.
    """
    forwardPoints: Optional[Decimal] = Field(None, description="An optional element used for deals consummated in the FX Forwards market. Forward points represent the interest rate differential between the two currencies traded and are quoted as a premium or a discount. Forward points are added to, or subtracted from, the spot rate to create the rate of the forward trade.")
    """
    An optional element used for deals consummated in the FX Forwards market. Forward points represent the interest rate differential between the two currencies traded and are quoted as a premium or a discount. Forward points are added to, or subtracted from, the spot rate to create the rate of the forward trade.
    """
    
    @rosetta_condition
    def condition_0_CrossRate(self):
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "spotRate"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "forwardPoints")), _then_fn0, _else_fn0)

import cdm 
