# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Confirmation']


class Confirmation(BaseDataClass):
    """
    A class to specify a trade confirmation.
    """
    identifier: List[cdm.base.staticdata.identifier.Identifier.Identifier] = Field([], description="The identifier(s) associated with the trade and resulting confirmation.")
    """
    The identifier(s) associated with the trade and resulting confirmation.
    """
    @rosetta_condition
    def cardinality_identifier(self):
        return check_cardinality(self.identifier, 1, None)
    
    party: List[cdm.base.staticdata.party.Party.Party] = Field([], description="The parties associated with the trade.")
    """
    The parties associated with the trade.
    """
    @rosetta_condition
    def cardinality_party(self):
        return check_cardinality(self.party, 1, None)
    
    partyRole: List[cdm.base.staticdata.party.PartyRole.PartyRole] = Field([], description="The role(s) that party(ies) may have in relation to the trade")
    """
    The role(s) that party(ies) may have in relation to the trade
    """
    @rosetta_condition
    def cardinality_partyRole(self):
        return check_cardinality(self.partyRole, 1, None)
    
    lineage: Optional[cdm.event.common.Lineage.Lineage] = Field(None, description="The lineage attribute provides a linkage to previous lifecycle events and associated data.")
    """
    The lineage attribute provides a linkage to previous lifecycle events and associated data.
    """
    status: cdm.event.common.ConfirmationStatusEnum.ConfirmationStatusEnum = Field(..., description="")
    
    @rosetta_condition
    def condition_0_BothBuyerAndSellerPartyRolesMustExist(self):
        """
        For an security confirmation, both buyer and seller party roles must exist.
        """
        item = self
        def _then_fn0():
            return (contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "partyRole"), "role"), rosetta_resolve_attr(PartyRoleEnum, "BUYER")) or contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "partyRole"), "role"), rosetta_resolve_attr(PartyRoleEnum, "SELLER")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "lineage"), "tradeReference"), "tradableProduct"), "product"), "security")), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.identifier.Identifier
import cdm.base.staticdata.party.Party
import cdm.base.staticdata.party.PartyRole
import cdm.event.common.Lineage
import cdm.event.common.ConfirmationStatusEnum
from cdm.base.staticdata.party.PartyRoleEnum import PartyRoleEnum
