# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ProductBase']


class ProductBase(BaseDataClass):
    """
    Serves as an abstract class to specify a product using a productIdentifier.
    """
    productTaxonomy: List[cdm.base.staticdata.asset.common.ProductTaxonomy.ProductTaxonomy] = Field([], description="Specifies the product taxonomy, which is composed of a taxonomy value and a taxonomy source.")
    """
    Specifies the product taxonomy, which is composed of a taxonomy value and a taxonomy source.
    """
    productIdentifier: List[AttributeWithAddress[cdm.base.staticdata.asset.common.ProductIdentifier.ProductIdentifier] | cdm.base.staticdata.asset.common.ProductIdentifier.ProductIdentifier] = Field([], description="Comprises an identifier and a source. The associated metadata key denotes the ability to associate a hash value to the ProductIdentifier instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.")
    """
    Comprises an identifier and a source. The associated metadata key denotes the ability to associate a hash value to the ProductIdentifier instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    """

import cdm 
import cdm.base.staticdata.asset.common.ProductTaxonomy
import cdm.base.staticdata.asset.common.ProductIdentifier
