/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.ForwardPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ForwardPayoutFxSettlement")
@ImplementedBy(value=Default.class)
public interface ForwardPayoutFxSettlement
extends Validator<ForwardPayout> {
    public static final String NAME = "ForwardPayoutFxSettlement";
    public static final String DEFINITION = "if underlier -> foreignExchange exists then settlementTerms -> physicalSettlementTerms is absent";

    public static class NoOp
    implements ForwardPayoutFxSettlement {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ForwardPayout forwardPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ForwardPayoutFxSettlement {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ForwardPayout forwardPayout) {
            ComparisonResult result = this.executeDataRule(forwardPayout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ForwardPayoutFxSettlement.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ForwardPayout", (RosettaPath)path, (String)ForwardPayoutFxSettlement.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ForwardPayoutFxSettlement.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ForwardPayout", (RosettaPath)path, (String)ForwardPayoutFxSettlement.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ForwardPayout forwardPayout) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)forwardPayout).map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)forwardPayout).map("getSettlementTerms", _forwardPayout -> _forwardPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

