/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.ContractualProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ContractualProductPrimaryAssetClass")
@ImplementedBy(value=Default.class)
public interface ContractualProductPrimaryAssetClass
extends Validator<ContractualProduct> {
    public static final String NAME = "ContractualProductPrimaryAssetClass";
    public static final String DEFINITION = "if economicTerms -> nonStandardisedTerms = True then productTaxonomy -> primaryAssetClass exists";

    public static class NoOp
    implements ContractualProductPrimaryAssetClass {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ContractualProduct contractualProduct) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ContractualProductPrimaryAssetClass {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ContractualProduct contractualProduct) {
            ComparisonResult result = this.executeDataRule(contractualProduct);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ContractualProductPrimaryAssetClass.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ContractualProduct", (RosettaPath)path, (String)ContractualProductPrimaryAssetClass.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ContractualProductPrimaryAssetClass.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ContractualProduct", (RosettaPath)path, (String)ContractualProductPrimaryAssetClass.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ContractualProduct contractualProduct) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)contractualProduct).map("getEconomicTerms", _contractualProduct -> _contractualProduct.getEconomicTerms()).map("getNonStandardisedTerms", economicTerms -> economicTerms.getNonStandardisedTerms()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)contractualProduct).mapC("getProductTaxonomy", _contractualProduct -> _contractualProduct.getProductTaxonomy()).map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

