/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.processor;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.legaldocumentation.contract.processor.PartyMappingHelper;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.processor.PriceQuantityHelper;
import cdm.product.template.processor.FraHelper;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.util.CollectionUtils;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FraPayoutSplitterMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FraPayoutSplitterMappingProcessor.class);

    public FraPayoutSplitterMappingProcessor(RosettaPath path, List<Path> synonymPaths, MappingContext context) {
        super(path, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        List interestRatePayouts = CollectionUtils.emptyIfNull(builder);
        if (interestRatePayouts.size() == 1 && ((InterestRatePayout.InterestRatePayoutBuilder)interestRatePayouts.get(0)).getRateSpecification() != null) {
            InterestRatePayout.InterestRatePayoutBuilder fixedLeg = (InterestRatePayout.InterestRatePayoutBuilder)interestRatePayouts.get(0);
            InterestRatePayout.InterestRatePayoutBuilder floatingLeg = ((InterestRatePayout.InterestRatePayoutBuilder)interestRatePayouts.get(0)).build().toBuilder();
            interestRatePayouts.add(floatingLeg);
            this.updateFixedLeg(fixedLeg);
            this.updateFloatingLeg(synonymPath, floatingLeg);
        }
    }

    private void updateFixedLeg(InterestRatePayout.InterestRatePayoutBuilder fixedLeg) {
        fixedLeg.getRateSpecification().setFloatingRate(null);
        if (fixedLeg.getResetDates() != null) {
            fixedLeg.getResetDates().setFixingDates(null);
        }
    }

    private void updateFloatingLeg(Path synonymPath, InterestRatePayout.InterestRatePayoutBuilder floatingLeg) {
        floatingLeg.getRateSpecification().toBuilder().setFixedRate(null);
        floatingLeg.setPaymentDates(null);
        this.getReferenceMapping(synonymPath.addElement("notional").addElement("amount")).ifPresent(m -> this.addFloatingLegQuantityReference((Mapping)m, floatingLeg));
        this.getReferenceMapping(synonymPath.addElement("floatingRateIndex")).ifPresent(m -> this.updateFloatingRateIndexReference((Mapping)m, floatingLeg));
        this.updateFloatingLegParties(floatingLeg);
    }

    private Optional<Mapping> getReferenceMapping(Path synonymPath) {
        return MappingProcessorUtils.filterMappings((List)this.getContext().getMappings(), (Path)synonymPath).stream().filter(m -> m.getRosettaValue() instanceof Reference.ReferenceBuilder).findFirst();
    }

    private void addFloatingLegQuantityReference(Mapping mapping, InterestRatePayout.InterestRatePayoutBuilder floatingLeg) {
        Path newSynonymPath = FraHelper.getDummyFloatingLegPath(mapping.getXmlPath());
        Reference.ReferenceBuilderImpl reference = Reference.builder();
        floatingLeg.getOrCreatePriceQuantity().getOrCreateQuantitySchedule().setReference((Reference)reference);
        this.getMappings().add(new Mapping(newSynonymPath, mapping.getXmlValue(), mapping.getRosettaPath(), (Object)reference, null, false, true, false));
    }

    private void updateFloatingRateIndexReference(Mapping mapping, InterestRatePayout.InterestRatePayoutBuilder floatingLeg) {
        Reference.ReferenceBuilder reference = Optional.of(floatingLeg).map(b -> b.getRateSpecification()).map(b -> b.getFloatingRate()).map(b -> b.getRateOption()).map(b -> b.getReference()).orElse(null);
        mapping.setRosettaValue((Object)reference);
        mapping.setRosettaPath(PriceQuantityHelper.incrementPathElementIndex(mapping.getRosettaPath(), "interestRatePayout", 1));
    }

    private void updateFloatingLegParties(InterestRatePayout.InterestRatePayoutBuilder floatingLeg) {
        LOGGER.info("Flipping payer/receiver on new FRA interest rate payout");
        PayerReceiver.PayerReceiverBuilder newBuilder = floatingLeg.getPayerReceiver().toBuilder();
        PartyMappingHelper helper = PartyMappingHelper.getInstanceOrThrow(this.getContext());
        this.getPartyReference("buyerPartyReference").ifPresent(partyReference -> helper.setCounterpartyRoleEnum((String)partyReference, newBuilder::setReceiver));
        this.getPartyReference("sellerPartyReference").ifPresent(partyReference -> helper.setCounterpartyRoleEnum((String)partyReference, newBuilder::setPayer));
    }

    private Optional<String> getPartyReference(String endsWith) {
        return this.getMappings().stream().filter(m -> m.getXmlPath() != null && m.getXmlValue() != null).filter(m -> m.getXmlPath().endsWith(new String[]{"fra", endsWith, "href"})).findFirst().map(Mapping::getXmlValue).map(String.class::cast);
    }
}

