/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.asset.common.AssetPool;
import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.asset.ForeignExchange;
import cdm.product.template.Basket;
import cdm.product.template.ContractualProduct;
import cdm.product.template.Product;
import cdm.product.template.meta.BasketConstituentMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="BasketConstituent", builder=BasketConstituentBuilderImpl.class, version="5.28.0")
@RuneDataType(value="BasketConstituent", model="cdm", builder=BasketConstituentBuilderImpl.class, version="5.28.0")
public interface BasketConstituent
extends Product {
    public static final BasketConstituentMeta metaData = new BasketConstituentMeta();

    public List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> getQuantity();

    public List<? extends ReferenceWithMetaPriceSchedule> getInitialValuationPrice();

    public List<? extends ReferenceWithMetaPriceSchedule> getInterimValuationPrice();

    public List<? extends ReferenceWithMetaPriceSchedule> getFinalValuationPrice();

    @Override
    public BasketConstituent build();

    @Override
    public BasketConstituentBuilder toBuilder();

    public static BasketConstituentBuilder builder() {
        return new BasketConstituentBuilderImpl();
    }

    default public RosettaMetaData<? extends BasketConstituent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BasketConstituent> getType() {
        return BasketConstituent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("contractualProduct"), processor, ContractualProduct.class, this.getContractualProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("index"), processor, Index.class, this.getIndex(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loan"), processor, Loan.class, this.getLoan(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetPool"), processor, AssetPool.class, this.getAssetPool(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("foreignExchange"), processor, ForeignExchange.class, this.getForeignExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodity"), processor, ReferenceWithMetaCommodity.class, this.getCommodity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("security"), processor, Security.class, this.getSecurity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basket"), processor, Basket.class, this.getBasket(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quantity"), processor, ReferenceWithMetaNonNegativeQuantitySchedule.class, this.getQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("initialValuationPrice"), processor, ReferenceWithMetaPriceSchedule.class, this.getInitialValuationPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interimValuationPrice"), processor, ReferenceWithMetaPriceSchedule.class, this.getInterimValuationPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalValuationPrice"), processor, ReferenceWithMetaPriceSchedule.class, this.getFinalValuationPrice(), new AttributeMeta[0]);
    }

    public static class BasketConstituentBuilderImpl
    extends Product.ProductBuilderImpl
    implements BasketConstituentBuilder {
        protected List<ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder> quantity = new ArrayList<ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder>();
        protected List<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> initialValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
        protected List<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> interimValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
        protected List<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> finalValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder> getQuantity() {
            return this.quantity;
        }

        @Override
        public ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder getOrCreateQuantity(int _index) {
            if (this.quantity == null) {
                this.quantity = new ArrayList<ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder>();
            }
            return (ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder)this.getIndex(this.quantity, _index, () -> {
                ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder newQuantity = ReferenceWithMetaNonNegativeQuantitySchedule.builder();
                return newQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="initialValuationPrice")
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInitialValuationPrice() {
            return this.initialValuationPrice;
        }

        @Override
        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInitialValuationPrice(int _index) {
            if (this.initialValuationPrice == null) {
                this.initialValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
            }
            return (ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder)this.getIndex(this.initialValuationPrice, _index, () -> {
                ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder newInitialValuationPrice = ReferenceWithMetaPriceSchedule.builder();
                return newInitialValuationPrice;
            });
        }

        @Override
        @RosettaAttribute(value="interimValuationPrice")
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInterimValuationPrice() {
            return this.interimValuationPrice;
        }

        @Override
        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInterimValuationPrice(int _index) {
            if (this.interimValuationPrice == null) {
                this.interimValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
            }
            return (ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder)this.getIndex(this.interimValuationPrice, _index, () -> {
                ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder newInterimValuationPrice = ReferenceWithMetaPriceSchedule.builder();
                return newInterimValuationPrice;
            });
        }

        @Override
        @RosettaAttribute(value="finalValuationPrice")
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getFinalValuationPrice() {
            return this.finalValuationPrice;
        }

        @Override
        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateFinalValuationPrice(int _index) {
            if (this.finalValuationPrice == null) {
                this.finalValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
            }
            return (ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder)this.getIndex(this.finalValuationPrice, _index, () -> {
                ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder newFinalValuationPrice = ReferenceWithMetaPriceSchedule.builder();
                return newFinalValuationPrice;
            });
        }

        @Override
        @RosettaAttribute(value="contractualProduct")
        @RuneAttribute(value="contractualProduct")
        public BasketConstituentBuilder setContractualProduct(ContractualProduct _contractualProduct) {
            this.contractualProduct = _contractualProduct == null ? null : _contractualProduct.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="index")
        @RuneAttribute(value="index")
        public BasketConstituentBuilder setIndex(Index _index) {
            this.index = _index == null ? null : _index.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loan")
        @RuneAttribute(value="loan")
        public BasketConstituentBuilder setLoan(Loan _loan) {
            this.loan = _loan == null ? null : _loan.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetPool")
        @RuneAttribute(value="assetPool")
        public BasketConstituentBuilder setAssetPool(AssetPool _assetPool) {
            this.assetPool = _assetPool == null ? null : _assetPool.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="foreignExchange")
        @RuneAttribute(value="foreignExchange")
        public BasketConstituentBuilder setForeignExchange(ForeignExchange _foreignExchange) {
            this.foreignExchange = _foreignExchange == null ? null : _foreignExchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodity")
        @RuneAttribute(value="commodity")
        @RuneScopedAttributeReference
        public BasketConstituentBuilder setCommodity(ReferenceWithMetaCommodity _commodity) {
            this.commodity = _commodity == null ? null : _commodity.toBuilder();
            return this;
        }

        @Override
        public BasketConstituentBuilder setCommodityValue(Commodity _commodity) {
            this.getOrCreateCommodity().setValue(_commodity);
            return this;
        }

        @Override
        @RosettaAttribute(value="security")
        @RuneAttribute(value="security")
        public BasketConstituentBuilder setSecurity(Security _security) {
            this.security = _security == null ? null : _security.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="basket")
        @RuneAttribute(value="basket")
        public BasketConstituentBuilder setBasket(Basket _basket) {
            this.basket = _basket == null ? null : _basket.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public BasketConstituentBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeReference
        public BasketConstituentBuilder addQuantity(ReferenceWithMetaNonNegativeQuantitySchedule _quantity) {
            if (_quantity != null) {
                this.quantity.add(_quantity.toBuilder());
            }
            return this;
        }

        @Override
        public BasketConstituentBuilder addQuantity(ReferenceWithMetaNonNegativeQuantitySchedule _quantity, int idx) {
            this.getIndex(this.quantity, idx, () -> _quantity.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addQuantityValue(NonNegativeQuantitySchedule _quantity) {
            this.getOrCreateQuantity(-1).setValue(_quantity.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addQuantityValue(NonNegativeQuantitySchedule _quantity, int idx) {
            this.getOrCreateQuantity(idx).setValue(_quantity.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addQuantity(List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitys) {
            if (quantitys != null) {
                for (ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule : quantitys) {
                    this.quantity.add(referenceWithMetaNonNegativeQuantitySchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeReference
        public BasketConstituentBuilder setQuantity(List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitys) {
            this.quantity = quantitys == null ? new ArrayList<ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder>() : (List)quantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketConstituentBuilder addQuantityValue(List<? extends NonNegativeQuantitySchedule> quantitys) {
            if (quantitys != null) {
                for (NonNegativeQuantitySchedule nonNegativeQuantitySchedule : quantitys) {
                    this.addQuantityValue(nonNegativeQuantitySchedule);
                }
            }
            return this;
        }

        @Override
        public BasketConstituentBuilder setQuantityValue(List<? extends NonNegativeQuantitySchedule> quantitys) {
            this.quantity.clear();
            if (quantitys != null) {
                quantitys.forEach(this::addQuantityValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="initialValuationPrice")
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public BasketConstituentBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule _initialValuationPrice) {
            if (_initialValuationPrice != null) {
                this.initialValuationPrice.add(_initialValuationPrice.toBuilder());
            }
            return this;
        }

        @Override
        public BasketConstituentBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule _initialValuationPrice, int idx) {
            this.getIndex(this.initialValuationPrice, idx, () -> _initialValuationPrice.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addInitialValuationPriceValue(PriceSchedule _initialValuationPrice) {
            this.getOrCreateInitialValuationPrice(-1).setValue(_initialValuationPrice.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addInitialValuationPriceValue(PriceSchedule _initialValuationPrice, int idx) {
            this.getOrCreateInitialValuationPrice(idx).setValue(_initialValuationPrice.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> initialValuationPrices) {
            if (initialValuationPrices != null) {
                for (ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule : initialValuationPrices) {
                    this.initialValuationPrice.add(referenceWithMetaPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public BasketConstituentBuilder setInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> initialValuationPrices) {
            this.initialValuationPrice = initialValuationPrices == null ? new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>() : (List)initialValuationPrices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketConstituentBuilder addInitialValuationPriceValue(List<? extends PriceSchedule> initialValuationPrices) {
            if (initialValuationPrices != null) {
                for (PriceSchedule priceSchedule : initialValuationPrices) {
                    this.addInitialValuationPriceValue(priceSchedule);
                }
            }
            return this;
        }

        @Override
        public BasketConstituentBuilder setInitialValuationPriceValue(List<? extends PriceSchedule> initialValuationPrices) {
            this.initialValuationPrice.clear();
            if (initialValuationPrices != null) {
                initialValuationPrices.forEach(this::addInitialValuationPriceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="interimValuationPrice")
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public BasketConstituentBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule _interimValuationPrice) {
            if (_interimValuationPrice != null) {
                this.interimValuationPrice.add(_interimValuationPrice.toBuilder());
            }
            return this;
        }

        @Override
        public BasketConstituentBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule _interimValuationPrice, int idx) {
            this.getIndex(this.interimValuationPrice, idx, () -> _interimValuationPrice.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addInterimValuationPriceValue(PriceSchedule _interimValuationPrice) {
            this.getOrCreateInterimValuationPrice(-1).setValue(_interimValuationPrice.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addInterimValuationPriceValue(PriceSchedule _interimValuationPrice, int idx) {
            this.getOrCreateInterimValuationPrice(idx).setValue(_interimValuationPrice.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> interimValuationPrices) {
            if (interimValuationPrices != null) {
                for (ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule : interimValuationPrices) {
                    this.interimValuationPrice.add(referenceWithMetaPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public BasketConstituentBuilder setInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> interimValuationPrices) {
            this.interimValuationPrice = interimValuationPrices == null ? new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>() : (List)interimValuationPrices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketConstituentBuilder addInterimValuationPriceValue(List<? extends PriceSchedule> interimValuationPrices) {
            if (interimValuationPrices != null) {
                for (PriceSchedule priceSchedule : interimValuationPrices) {
                    this.addInterimValuationPriceValue(priceSchedule);
                }
            }
            return this;
        }

        @Override
        public BasketConstituentBuilder setInterimValuationPriceValue(List<? extends PriceSchedule> interimValuationPrices) {
            this.interimValuationPrice.clear();
            if (interimValuationPrices != null) {
                interimValuationPrices.forEach(this::addInterimValuationPriceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="finalValuationPrice")
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public BasketConstituentBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule _finalValuationPrice) {
            if (_finalValuationPrice != null) {
                this.finalValuationPrice.add(_finalValuationPrice.toBuilder());
            }
            return this;
        }

        @Override
        public BasketConstituentBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule _finalValuationPrice, int idx) {
            this.getIndex(this.finalValuationPrice, idx, () -> _finalValuationPrice.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addFinalValuationPriceValue(PriceSchedule _finalValuationPrice) {
            this.getOrCreateFinalValuationPrice(-1).setValue(_finalValuationPrice.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addFinalValuationPriceValue(PriceSchedule _finalValuationPrice, int idx) {
            this.getOrCreateFinalValuationPrice(idx).setValue(_finalValuationPrice.toBuilder());
            return this;
        }

        @Override
        public BasketConstituentBuilder addFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> finalValuationPrices) {
            if (finalValuationPrices != null) {
                for (ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule : finalValuationPrices) {
                    this.finalValuationPrice.add(referenceWithMetaPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public BasketConstituentBuilder setFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> finalValuationPrices) {
            this.finalValuationPrice = finalValuationPrices == null ? new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>() : (List)finalValuationPrices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketConstituentBuilder addFinalValuationPriceValue(List<? extends PriceSchedule> finalValuationPrices) {
            if (finalValuationPrices != null) {
                for (PriceSchedule priceSchedule : finalValuationPrices) {
                    this.addFinalValuationPriceValue(priceSchedule);
                }
            }
            return this;
        }

        @Override
        public BasketConstituentBuilder setFinalValuationPriceValue(List<? extends PriceSchedule> finalValuationPrices) {
            this.finalValuationPrice.clear();
            if (finalValuationPrices != null) {
                finalValuationPrices.forEach(this::addFinalValuationPriceValue);
            }
            return this;
        }

        @Override
        public BasketConstituent build() {
            return new BasketConstituentImpl(this);
        }

        @Override
        public BasketConstituentBuilder toBuilder() {
            return this;
        }

        @Override
        public BasketConstituentBuilder prune() {
            super.prune();
            this.quantity = this.quantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.initialValuationPrice = this.initialValuationPrice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.interimValuationPrice = this.interimValuationPrice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.finalValuationPrice = this.finalValuationPrice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getQuantity() != null && this.getQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getInitialValuationPrice() != null && this.getInitialValuationPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getInterimValuationPrice() != null && this.getInterimValuationPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getFinalValuationPrice() != null && this.getFinalValuationPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public BasketConstituentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BasketConstituentBuilder o = (BasketConstituentBuilder)other;
            merger.mergeRosetta(this.getQuantity(), o.getQuantity(), this::getOrCreateQuantity);
            merger.mergeRosetta(this.getInitialValuationPrice(), o.getInitialValuationPrice(), this::getOrCreateInitialValuationPrice);
            merger.mergeRosetta(this.getInterimValuationPrice(), o.getInterimValuationPrice(), this::getOrCreateInterimValuationPrice);
            merger.mergeRosetta(this.getFinalValuationPrice(), o.getFinalValuationPrice(), this::getOrCreateFinalValuationPrice);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BasketConstituent _that = (BasketConstituent)this.getType().cast(o);
            if (!ListEquals.listEquals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.initialValuationPrice, _that.getInitialValuationPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.interimValuationPrice, _that.getInterimValuationPrice())) {
                return false;
            }
            return ListEquals.listEquals(this.finalValuationPrice, _that.getFinalValuationPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.initialValuationPrice != null ? this.initialValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.interimValuationPrice != null ? this.interimValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.finalValuationPrice != null ? this.finalValuationPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BasketConstituentBuilder {quantity=" + this.quantity + ", initialValuationPrice=" + this.initialValuationPrice + ", interimValuationPrice=" + this.interimValuationPrice + ", finalValuationPrice=" + this.finalValuationPrice + '}' + " " + super.toString();
        }
    }

    public static interface BasketConstituentBuilder
    extends BasketConstituent,
    Product.ProductBuilder {
        public ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder getOrCreateQuantity(int var1);

        public List<? extends ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder> getQuantity();

        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInitialValuationPrice(int var1);

        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInitialValuationPrice();

        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInterimValuationPrice(int var1);

        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInterimValuationPrice();

        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateFinalValuationPrice(int var1);

        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getFinalValuationPrice();

        @Override
        public BasketConstituentBuilder setContractualProduct(ContractualProduct var1);

        @Override
        public BasketConstituentBuilder setIndex(Index var1);

        @Override
        public BasketConstituentBuilder setLoan(Loan var1);

        @Override
        public BasketConstituentBuilder setAssetPool(AssetPool var1);

        @Override
        public BasketConstituentBuilder setForeignExchange(ForeignExchange var1);

        @Override
        public BasketConstituentBuilder setCommodity(ReferenceWithMetaCommodity var1);

        @Override
        public BasketConstituentBuilder setCommodityValue(Commodity var1);

        @Override
        public BasketConstituentBuilder setSecurity(Security var1);

        @Override
        public BasketConstituentBuilder setBasket(Basket var1);

        @Override
        public BasketConstituentBuilder setMeta(MetaFields var1);

        public BasketConstituentBuilder addQuantity(ReferenceWithMetaNonNegativeQuantitySchedule var1);

        public BasketConstituentBuilder addQuantity(ReferenceWithMetaNonNegativeQuantitySchedule var1, int var2);

        public BasketConstituentBuilder addQuantityValue(NonNegativeQuantitySchedule var1);

        public BasketConstituentBuilder addQuantityValue(NonNegativeQuantitySchedule var1, int var2);

        public BasketConstituentBuilder addQuantity(List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> var1);

        public BasketConstituentBuilder setQuantity(List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> var1);

        public BasketConstituentBuilder addQuantityValue(List<? extends NonNegativeQuantitySchedule> var1);

        public BasketConstituentBuilder setQuantityValue(List<? extends NonNegativeQuantitySchedule> var1);

        public BasketConstituentBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule var1);

        public BasketConstituentBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule var1, int var2);

        public BasketConstituentBuilder addInitialValuationPriceValue(PriceSchedule var1);

        public BasketConstituentBuilder addInitialValuationPriceValue(PriceSchedule var1, int var2);

        public BasketConstituentBuilder addInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public BasketConstituentBuilder setInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public BasketConstituentBuilder addInitialValuationPriceValue(List<? extends PriceSchedule> var1);

        public BasketConstituentBuilder setInitialValuationPriceValue(List<? extends PriceSchedule> var1);

        public BasketConstituentBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule var1);

        public BasketConstituentBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule var1, int var2);

        public BasketConstituentBuilder addInterimValuationPriceValue(PriceSchedule var1);

        public BasketConstituentBuilder addInterimValuationPriceValue(PriceSchedule var1, int var2);

        public BasketConstituentBuilder addInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public BasketConstituentBuilder setInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public BasketConstituentBuilder addInterimValuationPriceValue(List<? extends PriceSchedule> var1);

        public BasketConstituentBuilder setInterimValuationPriceValue(List<? extends PriceSchedule> var1);

        public BasketConstituentBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule var1);

        public BasketConstituentBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule var1, int var2);

        public BasketConstituentBuilder addFinalValuationPriceValue(PriceSchedule var1);

        public BasketConstituentBuilder addFinalValuationPriceValue(PriceSchedule var1, int var2);

        public BasketConstituentBuilder addFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public BasketConstituentBuilder setFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public BasketConstituentBuilder addFinalValuationPriceValue(List<? extends PriceSchedule> var1);

        public BasketConstituentBuilder setFinalValuationPriceValue(List<? extends PriceSchedule> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("contractualProduct"), processor, ContractualProduct.ContractualProductBuilder.class, (RosettaModelObjectBuilder)this.getContractualProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("index"), processor, Index.IndexBuilder.class, (RosettaModelObjectBuilder)this.getIndex(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loan"), processor, Loan.LoanBuilder.class, (RosettaModelObjectBuilder)this.getLoan(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetPool"), processor, AssetPool.AssetPoolBuilder.class, (RosettaModelObjectBuilder)this.getAssetPool(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("foreignExchange"), processor, ForeignExchange.ForeignExchangeBuilder.class, (RosettaModelObjectBuilder)this.getForeignExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodity"), processor, ReferenceWithMetaCommodity.ReferenceWithMetaCommodityBuilder.class, (RosettaModelObjectBuilder)this.getCommodity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("security"), processor, Security.SecurityBuilder.class, (RosettaModelObjectBuilder)this.getSecurity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basket"), processor, Basket.BasketBuilder.class, (RosettaModelObjectBuilder)this.getBasket(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quantity"), processor, ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder.class, this.getQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("initialValuationPrice"), processor, ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder.class, this.getInitialValuationPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interimValuationPrice"), processor, ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder.class, this.getInterimValuationPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalValuationPrice"), processor, ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder.class, this.getFinalValuationPrice(), new AttributeMeta[0]);
        }

        @Override
        public BasketConstituentBuilder prune();
    }

    public static class BasketConstituentImpl
    extends Product.ProductImpl
    implements BasketConstituent {
        private final List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity;
        private final List<? extends ReferenceWithMetaPriceSchedule> initialValuationPrice;
        private final List<? extends ReferenceWithMetaPriceSchedule> interimValuationPrice;
        private final List<? extends ReferenceWithMetaPriceSchedule> finalValuationPrice;

        protected BasketConstituentImpl(BasketConstituentBuilder builder) {
            super(builder);
            this.quantity = Optional.ofNullable(builder.getQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.initialValuationPrice = Optional.ofNullable(builder.getInitialValuationPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.interimValuationPrice = Optional.ofNullable(builder.getInterimValuationPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.finalValuationPrice = Optional.ofNullable(builder.getFinalValuationPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> getQuantity() {
            return this.quantity;
        }

        @Override
        @RosettaAttribute(value="initialValuationPrice")
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule> getInitialValuationPrice() {
            return this.initialValuationPrice;
        }

        @Override
        @RosettaAttribute(value="interimValuationPrice")
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule> getInterimValuationPrice() {
            return this.interimValuationPrice;
        }

        @Override
        @RosettaAttribute(value="finalValuationPrice")
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule> getFinalValuationPrice() {
            return this.finalValuationPrice;
        }

        @Override
        public BasketConstituent build() {
            return this;
        }

        @Override
        public BasketConstituentBuilder toBuilder() {
            BasketConstituentBuilder builder = BasketConstituent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BasketConstituentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
            Optional.ofNullable(this.getInitialValuationPrice()).ifPresent(builder::setInitialValuationPrice);
            Optional.ofNullable(this.getInterimValuationPrice()).ifPresent(builder::setInterimValuationPrice);
            Optional.ofNullable(this.getFinalValuationPrice()).ifPresent(builder::setFinalValuationPrice);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BasketConstituent _that = (BasketConstituent)this.getType().cast(o);
            if (!ListEquals.listEquals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.initialValuationPrice, _that.getInitialValuationPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.interimValuationPrice, _that.getInterimValuationPrice())) {
                return false;
            }
            return ListEquals.listEquals(this.finalValuationPrice, _that.getFinalValuationPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.initialValuationPrice != null ? this.initialValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.interimValuationPrice != null ? this.interimValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.finalValuationPrice != null ? this.finalValuationPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BasketConstituent {quantity=" + this.quantity + ", initialValuationPrice=" + this.initialValuationPrice + ", interimValuationPrice=" + this.interimValuationPrice + ", finalValuationPrice=" + this.finalValuationPrice + '}' + " " + super.toString();
        }
    }
}

