/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.staticdata.asset.common.CollateralIssuerType;
import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.party.LegalEntity;
import cdm.product.collateral.AgencyRatingCriteria;
import cdm.product.collateral.meta.IssuerCriteriaMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="IssuerCriteria", builder=IssuerCriteriaBuilderImpl.class, version="5.28.0")
@RuneDataType(value="IssuerCriteria", model="cdm", builder=IssuerCriteriaBuilderImpl.class, version="5.28.0")
public interface IssuerCriteria
extends RosettaModelObject {
    public static final IssuerCriteriaMeta metaData = new IssuerCriteriaMeta();

    public List<? extends CollateralIssuerType> getIssuerType();

    public List<ISOCountryCodeEnum> getIssuerCountryOfOrigin();

    public List<? extends LegalEntity> getIssuerName();

    public List<? extends AgencyRatingCriteria> getIssuerAgencyRating();

    public List<? extends AgencyRatingCriteria> getSovereignAgencyRating();

    public Boolean getCounterpartyOwnIssuePermitted();

    public IssuerCriteria build();

    public IssuerCriteriaBuilder toBuilder();

    public static IssuerCriteriaBuilder builder() {
        return new IssuerCriteriaBuilderImpl();
    }

    default public RosettaMetaData<? extends IssuerCriteria> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends IssuerCriteria> getType() {
        return IssuerCriteria.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("issuerType"), processor, CollateralIssuerType.class, this.getIssuerType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("issuerCountryOfOrigin"), ISOCountryCodeEnum.class, this.getIssuerCountryOfOrigin(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerName"), processor, LegalEntity.class, this.getIssuerName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuerAgencyRating"), processor, AgencyRatingCriteria.class, this.getIssuerAgencyRating(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sovereignAgencyRating"), processor, AgencyRatingCriteria.class, this.getSovereignAgencyRating(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterpartyOwnIssuePermitted"), Boolean.class, (Object)this.getCounterpartyOwnIssuePermitted(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class IssuerCriteriaBuilderImpl
    implements IssuerCriteriaBuilder {
        protected List<CollateralIssuerType.CollateralIssuerTypeBuilder> issuerType = new ArrayList<CollateralIssuerType.CollateralIssuerTypeBuilder>();
        protected List<ISOCountryCodeEnum> issuerCountryOfOrigin = new ArrayList<ISOCountryCodeEnum>();
        protected List<LegalEntity.LegalEntityBuilder> issuerName = new ArrayList<LegalEntity.LegalEntityBuilder>();
        protected List<AgencyRatingCriteria.AgencyRatingCriteriaBuilder> issuerAgencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();
        protected List<AgencyRatingCriteria.AgencyRatingCriteriaBuilder> sovereignAgencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();
        protected Boolean counterpartyOwnIssuePermitted;

        @Override
        @RosettaAttribute(value="issuerType")
        @RuneAttribute(value="issuerType")
        public List<? extends CollateralIssuerType.CollateralIssuerTypeBuilder> getIssuerType() {
            return this.issuerType;
        }

        @Override
        public CollateralIssuerType.CollateralIssuerTypeBuilder getOrCreateIssuerType(int index) {
            if (this.issuerType == null) {
                this.issuerType = new ArrayList<CollateralIssuerType.CollateralIssuerTypeBuilder>();
            }
            return (CollateralIssuerType.CollateralIssuerTypeBuilder)this.getIndex(this.issuerType, index, () -> {
                CollateralIssuerType.CollateralIssuerTypeBuilder newIssuerType = CollateralIssuerType.builder();
                return newIssuerType;
            });
        }

        @Override
        @RosettaAttribute(value="issuerCountryOfOrigin")
        @RuneAttribute(value="issuerCountryOfOrigin")
        public List<ISOCountryCodeEnum> getIssuerCountryOfOrigin() {
            return this.issuerCountryOfOrigin;
        }

        @Override
        @RosettaAttribute(value="issuerName")
        @RuneAttribute(value="issuerName")
        public List<? extends LegalEntity.LegalEntityBuilder> getIssuerName() {
            return this.issuerName;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateIssuerName(int index) {
            if (this.issuerName == null) {
                this.issuerName = new ArrayList<LegalEntity.LegalEntityBuilder>();
            }
            return (LegalEntity.LegalEntityBuilder)this.getIndex(this.issuerName, index, () -> {
                LegalEntity.LegalEntityBuilder newIssuerName = LegalEntity.builder();
                return newIssuerName;
            });
        }

        @Override
        @RosettaAttribute(value="issuerAgencyRating")
        @RuneAttribute(value="issuerAgencyRating")
        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getIssuerAgencyRating() {
            return this.issuerAgencyRating;
        }

        @Override
        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateIssuerAgencyRating(int index) {
            if (this.issuerAgencyRating == null) {
                this.issuerAgencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();
            }
            return (AgencyRatingCriteria.AgencyRatingCriteriaBuilder)this.getIndex(this.issuerAgencyRating, index, () -> {
                AgencyRatingCriteria.AgencyRatingCriteriaBuilder newIssuerAgencyRating = AgencyRatingCriteria.builder();
                return newIssuerAgencyRating;
            });
        }

        @Override
        @RosettaAttribute(value="sovereignAgencyRating")
        @RuneAttribute(value="sovereignAgencyRating")
        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getSovereignAgencyRating() {
            return this.sovereignAgencyRating;
        }

        @Override
        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateSovereignAgencyRating(int index) {
            if (this.sovereignAgencyRating == null) {
                this.sovereignAgencyRating = new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>();
            }
            return (AgencyRatingCriteria.AgencyRatingCriteriaBuilder)this.getIndex(this.sovereignAgencyRating, index, () -> {
                AgencyRatingCriteria.AgencyRatingCriteriaBuilder newSovereignAgencyRating = AgencyRatingCriteria.builder();
                return newSovereignAgencyRating;
            });
        }

        @Override
        @RosettaAttribute(value="counterpartyOwnIssuePermitted")
        @RuneAttribute(value="counterpartyOwnIssuePermitted")
        public Boolean getCounterpartyOwnIssuePermitted() {
            return this.counterpartyOwnIssuePermitted;
        }

        @Override
        @RosettaAttribute(value="issuerType")
        @RuneAttribute(value="issuerType")
        public IssuerCriteriaBuilder addIssuerType(CollateralIssuerType _issuerType) {
            if (_issuerType != null) {
                this.issuerType.add(_issuerType.toBuilder());
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerType(CollateralIssuerType _issuerType, int idx) {
            this.getIndex(this.issuerType, idx, () -> _issuerType.toBuilder());
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerType(List<? extends CollateralIssuerType> issuerTypes) {
            if (issuerTypes != null) {
                for (CollateralIssuerType collateralIssuerType : issuerTypes) {
                    this.issuerType.add(collateralIssuerType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="issuerType")
        public IssuerCriteriaBuilder setIssuerType(List<? extends CollateralIssuerType> issuerTypes) {
            this.issuerType = issuerTypes == null ? new ArrayList<CollateralIssuerType.CollateralIssuerTypeBuilder>() : (List)issuerTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="issuerCountryOfOrigin")
        @RuneAttribute(value="issuerCountryOfOrigin")
        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(ISOCountryCodeEnum _issuerCountryOfOrigin) {
            if (_issuerCountryOfOrigin != null) {
                this.issuerCountryOfOrigin.add(_issuerCountryOfOrigin);
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(ISOCountryCodeEnum _issuerCountryOfOrigin, int idx) {
            this.getIndex(this.issuerCountryOfOrigin, idx, () -> _issuerCountryOfOrigin);
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(List<ISOCountryCodeEnum> issuerCountryOfOrigins) {
            if (issuerCountryOfOrigins != null) {
                for (ISOCountryCodeEnum toAdd : issuerCountryOfOrigins) {
                    this.issuerCountryOfOrigin.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="issuerCountryOfOrigin")
        public IssuerCriteriaBuilder setIssuerCountryOfOrigin(List<ISOCountryCodeEnum> issuerCountryOfOrigins) {
            this.issuerCountryOfOrigin = issuerCountryOfOrigins == null ? new ArrayList<ISOCountryCodeEnum>() : (List)issuerCountryOfOrigins.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="issuerName")
        @RuneAttribute(value="issuerName")
        public IssuerCriteriaBuilder addIssuerName(LegalEntity _issuerName) {
            if (_issuerName != null) {
                this.issuerName.add(_issuerName.toBuilder());
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerName(LegalEntity _issuerName, int idx) {
            this.getIndex(this.issuerName, idx, () -> _issuerName.toBuilder());
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerName(List<? extends LegalEntity> issuerNames) {
            if (issuerNames != null) {
                for (LegalEntity legalEntity : issuerNames) {
                    this.issuerName.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="issuerName")
        public IssuerCriteriaBuilder setIssuerName(List<? extends LegalEntity> issuerNames) {
            this.issuerName = issuerNames == null ? new ArrayList<LegalEntity.LegalEntityBuilder>() : (List)issuerNames.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="issuerAgencyRating")
        @RuneAttribute(value="issuerAgencyRating")
        public IssuerCriteriaBuilder addIssuerAgencyRating(AgencyRatingCriteria _issuerAgencyRating) {
            if (_issuerAgencyRating != null) {
                this.issuerAgencyRating.add(_issuerAgencyRating.toBuilder());
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerAgencyRating(AgencyRatingCriteria _issuerAgencyRating, int idx) {
            this.getIndex(this.issuerAgencyRating, idx, () -> _issuerAgencyRating.toBuilder());
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addIssuerAgencyRating(List<? extends AgencyRatingCriteria> issuerAgencyRatings) {
            if (issuerAgencyRatings != null) {
                for (AgencyRatingCriteria agencyRatingCriteria : issuerAgencyRatings) {
                    this.issuerAgencyRating.add(agencyRatingCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="issuerAgencyRating")
        public IssuerCriteriaBuilder setIssuerAgencyRating(List<? extends AgencyRatingCriteria> issuerAgencyRatings) {
            this.issuerAgencyRating = issuerAgencyRatings == null ? new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>() : (List)issuerAgencyRatings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="sovereignAgencyRating")
        @RuneAttribute(value="sovereignAgencyRating")
        public IssuerCriteriaBuilder addSovereignAgencyRating(AgencyRatingCriteria _sovereignAgencyRating) {
            if (_sovereignAgencyRating != null) {
                this.sovereignAgencyRating.add(_sovereignAgencyRating.toBuilder());
            }
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addSovereignAgencyRating(AgencyRatingCriteria _sovereignAgencyRating, int idx) {
            this.getIndex(this.sovereignAgencyRating, idx, () -> _sovereignAgencyRating.toBuilder());
            return this;
        }

        @Override
        public IssuerCriteriaBuilder addSovereignAgencyRating(List<? extends AgencyRatingCriteria> sovereignAgencyRatings) {
            if (sovereignAgencyRatings != null) {
                for (AgencyRatingCriteria agencyRatingCriteria : sovereignAgencyRatings) {
                    this.sovereignAgencyRating.add(agencyRatingCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="sovereignAgencyRating")
        public IssuerCriteriaBuilder setSovereignAgencyRating(List<? extends AgencyRatingCriteria> sovereignAgencyRatings) {
            this.sovereignAgencyRating = sovereignAgencyRatings == null ? new ArrayList<AgencyRatingCriteria.AgencyRatingCriteriaBuilder>() : (List)sovereignAgencyRatings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="counterpartyOwnIssuePermitted")
        @RuneAttribute(value="counterpartyOwnIssuePermitted")
        public IssuerCriteriaBuilder setCounterpartyOwnIssuePermitted(Boolean _counterpartyOwnIssuePermitted) {
            this.counterpartyOwnIssuePermitted = _counterpartyOwnIssuePermitted == null ? null : _counterpartyOwnIssuePermitted;
            return this;
        }

        @Override
        public IssuerCriteria build() {
            return new IssuerCriteriaImpl(this);
        }

        @Override
        public IssuerCriteriaBuilder toBuilder() {
            return this;
        }

        @Override
        public IssuerCriteriaBuilder prune() {
            this.issuerType = this.issuerType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.issuerName = this.issuerName.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.issuerAgencyRating = this.issuerAgencyRating.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.sovereignAgencyRating = this.sovereignAgencyRating.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getIssuerType() != null && this.getIssuerType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getIssuerCountryOfOrigin() != null && !this.getIssuerCountryOfOrigin().isEmpty()) {
                return true;
            }
            if (this.getIssuerName() != null && this.getIssuerName().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getIssuerAgencyRating() != null && this.getIssuerAgencyRating().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSovereignAgencyRating() != null && this.getSovereignAgencyRating().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getCounterpartyOwnIssuePermitted() != null;
        }

        public IssuerCriteriaBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            IssuerCriteriaBuilder o = (IssuerCriteriaBuilder)other;
            merger.mergeRosetta(this.getIssuerType(), o.getIssuerType(), this::getOrCreateIssuerType);
            merger.mergeRosetta(this.getIssuerName(), o.getIssuerName(), this::getOrCreateIssuerName);
            merger.mergeRosetta(this.getIssuerAgencyRating(), o.getIssuerAgencyRating(), this::getOrCreateIssuerAgencyRating);
            merger.mergeRosetta(this.getSovereignAgencyRating(), o.getSovereignAgencyRating(), this::getOrCreateSovereignAgencyRating);
            merger.mergeBasic(this.getIssuerCountryOfOrigin(), o.getIssuerCountryOfOrigin(), this::addIssuerCountryOfOrigin);
            merger.mergeBasic((Object)this.getCounterpartyOwnIssuePermitted(), (Object)o.getCounterpartyOwnIssuePermitted(), this::setCounterpartyOwnIssuePermitted, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IssuerCriteria _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.issuerType, _that.getIssuerType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerCountryOfOrigin, _that.getIssuerCountryOfOrigin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerName, _that.getIssuerName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerAgencyRating, _that.getIssuerAgencyRating())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sovereignAgencyRating, _that.getSovereignAgencyRating())) {
                return false;
            }
            return Objects.equals(this.counterpartyOwnIssuePermitted, _that.getCounterpartyOwnIssuePermitted());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuerType != null ? this.issuerType.hashCode() : 0);
            _result = 31 * _result + (this.issuerCountryOfOrigin != null ? this.issuerCountryOfOrigin.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.issuerName != null ? this.issuerName.hashCode() : 0);
            _result = 31 * _result + (this.issuerAgencyRating != null ? this.issuerAgencyRating.hashCode() : 0);
            _result = 31 * _result + (this.sovereignAgencyRating != null ? this.sovereignAgencyRating.hashCode() : 0);
            _result = 31 * _result + (this.counterpartyOwnIssuePermitted != null ? this.counterpartyOwnIssuePermitted.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IssuerCriteriaBuilder {issuerType=" + this.issuerType + ", issuerCountryOfOrigin=" + this.issuerCountryOfOrigin + ", issuerName=" + this.issuerName + ", issuerAgencyRating=" + this.issuerAgencyRating + ", sovereignAgencyRating=" + this.sovereignAgencyRating + ", counterpartyOwnIssuePermitted=" + this.counterpartyOwnIssuePermitted + '}';
        }
    }

    public static interface IssuerCriteriaBuilder
    extends IssuerCriteria,
    RosettaModelObjectBuilder {
        public CollateralIssuerType.CollateralIssuerTypeBuilder getOrCreateIssuerType(int var1);

        public List<? extends CollateralIssuerType.CollateralIssuerTypeBuilder> getIssuerType();

        public LegalEntity.LegalEntityBuilder getOrCreateIssuerName(int var1);

        public List<? extends LegalEntity.LegalEntityBuilder> getIssuerName();

        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateIssuerAgencyRating(int var1);

        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getIssuerAgencyRating();

        public AgencyRatingCriteria.AgencyRatingCriteriaBuilder getOrCreateSovereignAgencyRating(int var1);

        public List<? extends AgencyRatingCriteria.AgencyRatingCriteriaBuilder> getSovereignAgencyRating();

        public IssuerCriteriaBuilder addIssuerType(CollateralIssuerType var1);

        public IssuerCriteriaBuilder addIssuerType(CollateralIssuerType var1, int var2);

        public IssuerCriteriaBuilder addIssuerType(List<? extends CollateralIssuerType> var1);

        public IssuerCriteriaBuilder setIssuerType(List<? extends CollateralIssuerType> var1);

        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(ISOCountryCodeEnum var1);

        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(ISOCountryCodeEnum var1, int var2);

        public IssuerCriteriaBuilder addIssuerCountryOfOrigin(List<ISOCountryCodeEnum> var1);

        public IssuerCriteriaBuilder setIssuerCountryOfOrigin(List<ISOCountryCodeEnum> var1);

        public IssuerCriteriaBuilder addIssuerName(LegalEntity var1);

        public IssuerCriteriaBuilder addIssuerName(LegalEntity var1, int var2);

        public IssuerCriteriaBuilder addIssuerName(List<? extends LegalEntity> var1);

        public IssuerCriteriaBuilder setIssuerName(List<? extends LegalEntity> var1);

        public IssuerCriteriaBuilder addIssuerAgencyRating(AgencyRatingCriteria var1);

        public IssuerCriteriaBuilder addIssuerAgencyRating(AgencyRatingCriteria var1, int var2);

        public IssuerCriteriaBuilder addIssuerAgencyRating(List<? extends AgencyRatingCriteria> var1);

        public IssuerCriteriaBuilder setIssuerAgencyRating(List<? extends AgencyRatingCriteria> var1);

        public IssuerCriteriaBuilder addSovereignAgencyRating(AgencyRatingCriteria var1);

        public IssuerCriteriaBuilder addSovereignAgencyRating(AgencyRatingCriteria var1, int var2);

        public IssuerCriteriaBuilder addSovereignAgencyRating(List<? extends AgencyRatingCriteria> var1);

        public IssuerCriteriaBuilder setSovereignAgencyRating(List<? extends AgencyRatingCriteria> var1);

        public IssuerCriteriaBuilder setCounterpartyOwnIssuePermitted(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("issuerType"), processor, CollateralIssuerType.CollateralIssuerTypeBuilder.class, this.getIssuerType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("issuerCountryOfOrigin"), ISOCountryCodeEnum.class, this.getIssuerCountryOfOrigin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerName"), processor, LegalEntity.LegalEntityBuilder.class, this.getIssuerName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuerAgencyRating"), processor, AgencyRatingCriteria.AgencyRatingCriteriaBuilder.class, this.getIssuerAgencyRating(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sovereignAgencyRating"), processor, AgencyRatingCriteria.AgencyRatingCriteriaBuilder.class, this.getSovereignAgencyRating(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterpartyOwnIssuePermitted"), Boolean.class, (Object)this.getCounterpartyOwnIssuePermitted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public IssuerCriteriaBuilder prune();
    }

    public static class IssuerCriteriaImpl
    implements IssuerCriteria {
        private final List<? extends CollateralIssuerType> issuerType;
        private final List<ISOCountryCodeEnum> issuerCountryOfOrigin;
        private final List<? extends LegalEntity> issuerName;
        private final List<? extends AgencyRatingCriteria> issuerAgencyRating;
        private final List<? extends AgencyRatingCriteria> sovereignAgencyRating;
        private final Boolean counterpartyOwnIssuePermitted;

        protected IssuerCriteriaImpl(IssuerCriteriaBuilder builder) {
            this.issuerType = Optional.ofNullable(builder.getIssuerType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.issuerCountryOfOrigin = Optional.ofNullable(builder.getIssuerCountryOfOrigin()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.issuerName = Optional.ofNullable(builder.getIssuerName()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.issuerAgencyRating = Optional.ofNullable(builder.getIssuerAgencyRating()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.sovereignAgencyRating = Optional.ofNullable(builder.getSovereignAgencyRating()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.counterpartyOwnIssuePermitted = builder.getCounterpartyOwnIssuePermitted();
        }

        @Override
        @RosettaAttribute(value="issuerType")
        @RuneAttribute(value="issuerType")
        public List<? extends CollateralIssuerType> getIssuerType() {
            return this.issuerType;
        }

        @Override
        @RosettaAttribute(value="issuerCountryOfOrigin")
        @RuneAttribute(value="issuerCountryOfOrigin")
        public List<ISOCountryCodeEnum> getIssuerCountryOfOrigin() {
            return this.issuerCountryOfOrigin;
        }

        @Override
        @RosettaAttribute(value="issuerName")
        @RuneAttribute(value="issuerName")
        public List<? extends LegalEntity> getIssuerName() {
            return this.issuerName;
        }

        @Override
        @RosettaAttribute(value="issuerAgencyRating")
        @RuneAttribute(value="issuerAgencyRating")
        public List<? extends AgencyRatingCriteria> getIssuerAgencyRating() {
            return this.issuerAgencyRating;
        }

        @Override
        @RosettaAttribute(value="sovereignAgencyRating")
        @RuneAttribute(value="sovereignAgencyRating")
        public List<? extends AgencyRatingCriteria> getSovereignAgencyRating() {
            return this.sovereignAgencyRating;
        }

        @Override
        @RosettaAttribute(value="counterpartyOwnIssuePermitted")
        @RuneAttribute(value="counterpartyOwnIssuePermitted")
        public Boolean getCounterpartyOwnIssuePermitted() {
            return this.counterpartyOwnIssuePermitted;
        }

        @Override
        public IssuerCriteria build() {
            return this;
        }

        @Override
        public IssuerCriteriaBuilder toBuilder() {
            IssuerCriteriaBuilder builder = IssuerCriteria.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IssuerCriteriaBuilder builder) {
            Optional.ofNullable(this.getIssuerType()).ifPresent(builder::setIssuerType);
            Optional.ofNullable(this.getIssuerCountryOfOrigin()).ifPresent(builder::setIssuerCountryOfOrigin);
            Optional.ofNullable(this.getIssuerName()).ifPresent(builder::setIssuerName);
            Optional.ofNullable(this.getIssuerAgencyRating()).ifPresent(builder::setIssuerAgencyRating);
            Optional.ofNullable(this.getSovereignAgencyRating()).ifPresent(builder::setSovereignAgencyRating);
            Optional.ofNullable(this.getCounterpartyOwnIssuePermitted()).ifPresent(builder::setCounterpartyOwnIssuePermitted);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IssuerCriteria _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.issuerType, _that.getIssuerType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerCountryOfOrigin, _that.getIssuerCountryOfOrigin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerName, _that.getIssuerName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.issuerAgencyRating, _that.getIssuerAgencyRating())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sovereignAgencyRating, _that.getSovereignAgencyRating())) {
                return false;
            }
            return Objects.equals(this.counterpartyOwnIssuePermitted, _that.getCounterpartyOwnIssuePermitted());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuerType != null ? this.issuerType.hashCode() : 0);
            _result = 31 * _result + (this.issuerCountryOfOrigin != null ? this.issuerCountryOfOrigin.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.issuerName != null ? this.issuerName.hashCode() : 0);
            _result = 31 * _result + (this.issuerAgencyRating != null ? this.issuerAgencyRating.hashCode() : 0);
            _result = 31 * _result + (this.sovereignAgencyRating != null ? this.sovereignAgencyRating.hashCode() : 0);
            _result = 31 * _result + (this.counterpartyOwnIssuePermitted != null ? this.counterpartyOwnIssuePermitted.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IssuerCriteria {issuerType=" + this.issuerType + ", issuerCountryOfOrigin=" + this.issuerCountryOfOrigin + ", issuerName=" + this.issuerName + ", issuerAgencyRating=" + this.issuerAgencyRating + ", sovereignAgencyRating=" + this.sovereignAgencyRating + ", counterpartyOwnIssuePermitted=" + this.counterpartyOwnIssuePermitted + '}';
        }
    }
}

