/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.base.datetime.TimeZone;
import cdm.observable.asset.InformationSource;
import cdm.observable.asset.Observable;
import cdm.observable.event.DeterminationMethodology;
import cdm.observable.event.meta.ObservationIdentifierMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ObservationIdentifier", builder=ObservationIdentifierBuilderImpl.class, version="5.28.0")
@RuneDataType(value="ObservationIdentifier", model="cdm", builder=ObservationIdentifierBuilderImpl.class, version="5.28.0")
public interface ObservationIdentifier
extends RosettaModelObject {
    public static final ObservationIdentifierMeta metaData = new ObservationIdentifierMeta();

    public Observable getObservable();

    public Date getObservationDate();

    public TimeZone getObservationTime();

    public InformationSource getInformationSource();

    public DeterminationMethodology getDeterminationMethodology();

    public ObservationIdentifier build();

    public ObservationIdentifierBuilder toBuilder();

    public static ObservationIdentifierBuilder builder() {
        return new ObservationIdentifierBuilderImpl();
    }

    default public RosettaMetaData<? extends ObservationIdentifier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ObservationIdentifier> getType() {
        return ObservationIdentifier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("observable"), processor, Observable.class, this.getObservable(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("observationDate"), Date.class, (Object)this.getObservationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationTime"), processor, TimeZone.class, this.getObservationTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("determinationMethodology"), processor, DeterminationMethodology.class, this.getDeterminationMethodology(), new AttributeMeta[0]);
    }

    public static class ObservationIdentifierBuilderImpl
    implements ObservationIdentifierBuilder {
        protected Observable.ObservableBuilder observable;
        protected Date observationDate;
        protected TimeZone.TimeZoneBuilder observationTime;
        protected InformationSource.InformationSourceBuilder informationSource;
        protected DeterminationMethodology.DeterminationMethodologyBuilder determinationMethodology;

        @Override
        @RosettaAttribute(value="observable", isRequired=true)
        @RuneAttribute(value="observable", isRequired=true)
        public Observable.ObservableBuilder getObservable() {
            return this.observable;
        }

        @Override
        public Observable.ObservableBuilder getOrCreateObservable() {
            Observable.ObservableBuilder result = this.observable != null ? this.observable : (this.observable = Observable.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationDate", isRequired=true)
        @RuneAttribute(value="observationDate", isRequired=true)
        public Date getObservationDate() {
            return this.observationDate;
        }

        @Override
        @RosettaAttribute(value="observationTime")
        @RuneAttribute(value="observationTime")
        public TimeZone.TimeZoneBuilder getObservationTime() {
            return this.observationTime;
        }

        @Override
        public TimeZone.TimeZoneBuilder getOrCreateObservationTime() {
            TimeZone.TimeZoneBuilder result = this.observationTime != null ? this.observationTime : (this.observationTime = TimeZone.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public InformationSource.InformationSourceBuilder getInformationSource() {
            return this.informationSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource() {
            InformationSource.InformationSourceBuilder result = this.informationSource != null ? this.informationSource : (this.informationSource = InformationSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="determinationMethodology")
        @RuneAttribute(value="determinationMethodology")
        public DeterminationMethodology.DeterminationMethodologyBuilder getDeterminationMethodology() {
            return this.determinationMethodology;
        }

        @Override
        public DeterminationMethodology.DeterminationMethodologyBuilder getOrCreateDeterminationMethodology() {
            DeterminationMethodology.DeterminationMethodologyBuilder result = this.determinationMethodology != null ? this.determinationMethodology : (this.determinationMethodology = DeterminationMethodology.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observable", isRequired=true)
        @RuneAttribute(value="observable", isRequired=true)
        public ObservationIdentifierBuilder setObservable(Observable _observable) {
            this.observable = _observable == null ? null : _observable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationDate", isRequired=true)
        @RuneAttribute(value="observationDate", isRequired=true)
        public ObservationIdentifierBuilder setObservationDate(Date _observationDate) {
            this.observationDate = _observationDate == null ? null : _observationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="observationTime")
        @RuneAttribute(value="observationTime")
        public ObservationIdentifierBuilder setObservationTime(TimeZone _observationTime) {
            this.observationTime = _observationTime == null ? null : _observationTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public ObservationIdentifierBuilder setInformationSource(InformationSource _informationSource) {
            this.informationSource = _informationSource == null ? null : _informationSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="determinationMethodology")
        @RuneAttribute(value="determinationMethodology")
        public ObservationIdentifierBuilder setDeterminationMethodology(DeterminationMethodology _determinationMethodology) {
            this.determinationMethodology = _determinationMethodology == null ? null : _determinationMethodology.toBuilder();
            return this;
        }

        @Override
        public ObservationIdentifier build() {
            return new ObservationIdentifierImpl(this);
        }

        @Override
        public ObservationIdentifierBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationIdentifierBuilder prune() {
            if (this.observable != null && !this.observable.prune().hasData()) {
                this.observable = null;
            }
            if (this.observationTime != null && !this.observationTime.prune().hasData()) {
                this.observationTime = null;
            }
            if (this.informationSource != null && !this.informationSource.prune().hasData()) {
                this.informationSource = null;
            }
            if (this.determinationMethodology != null && !this.determinationMethodology.prune().hasData()) {
                this.determinationMethodology = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getObservable() != null && this.getObservable().hasData()) {
                return true;
            }
            if (this.getObservationDate() != null) {
                return true;
            }
            if (this.getObservationTime() != null && this.getObservationTime().hasData()) {
                return true;
            }
            if (this.getInformationSource() != null && this.getInformationSource().hasData()) {
                return true;
            }
            return this.getDeterminationMethodology() != null && this.getDeterminationMethodology().hasData();
        }

        public ObservationIdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservationIdentifierBuilder o = (ObservationIdentifierBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservable(), (RosettaModelObjectBuilder)o.getObservable(), this::setObservable);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationTime(), (RosettaModelObjectBuilder)o.getObservationTime(), this::setObservationTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInformationSource(), (RosettaModelObjectBuilder)o.getInformationSource(), this::setInformationSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeterminationMethodology(), (RosettaModelObjectBuilder)o.getDeterminationMethodology(), this::setDeterminationMethodology);
            merger.mergeBasic((Object)this.getObservationDate(), (Object)o.getObservationDate(), this::setObservationDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!Objects.equals(this.observationDate, _that.getObservationDate())) {
                return false;
            }
            if (!Objects.equals(this.observationTime, _that.getObservationTime())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            return Objects.equals(this.determinationMethodology, _that.getDeterminationMethodology());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.observationDate != null ? this.observationDate.hashCode() : 0);
            _result = 31 * _result + (this.observationTime != null ? this.observationTime.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.determinationMethodology != null ? this.determinationMethodology.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationIdentifierBuilder {observable=" + this.observable + ", observationDate=" + this.observationDate + ", observationTime=" + this.observationTime + ", informationSource=" + this.informationSource + ", determinationMethodology=" + this.determinationMethodology + '}';
        }
    }

    public static interface ObservationIdentifierBuilder
    extends ObservationIdentifier,
    RosettaModelObjectBuilder {
        public Observable.ObservableBuilder getOrCreateObservable();

        @Override
        public Observable.ObservableBuilder getObservable();

        public TimeZone.TimeZoneBuilder getOrCreateObservationTime();

        @Override
        public TimeZone.TimeZoneBuilder getObservationTime();

        public InformationSource.InformationSourceBuilder getOrCreateInformationSource();

        @Override
        public InformationSource.InformationSourceBuilder getInformationSource();

        public DeterminationMethodology.DeterminationMethodologyBuilder getOrCreateDeterminationMethodology();

        @Override
        public DeterminationMethodology.DeterminationMethodologyBuilder getDeterminationMethodology();

        public ObservationIdentifierBuilder setObservable(Observable var1);

        public ObservationIdentifierBuilder setObservationDate(Date var1);

        public ObservationIdentifierBuilder setObservationTime(TimeZone var1);

        public ObservationIdentifierBuilder setInformationSource(InformationSource var1);

        public ObservationIdentifierBuilder setDeterminationMethodology(DeterminationMethodology var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("observable"), processor, Observable.ObservableBuilder.class, this.getObservable(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("observationDate"), Date.class, (Object)this.getObservationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationTime"), processor, TimeZone.TimeZoneBuilder.class, this.getObservationTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.InformationSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("determinationMethodology"), processor, DeterminationMethodology.DeterminationMethodologyBuilder.class, this.getDeterminationMethodology(), new AttributeMeta[0]);
        }

        public ObservationIdentifierBuilder prune();
    }

    public static class ObservationIdentifierImpl
    implements ObservationIdentifier {
        private final Observable observable;
        private final Date observationDate;
        private final TimeZone observationTime;
        private final InformationSource informationSource;
        private final DeterminationMethodology determinationMethodology;

        protected ObservationIdentifierImpl(ObservationIdentifierBuilder builder) {
            this.observable = Optional.ofNullable(builder.getObservable()).map(f -> f.build()).orElse(null);
            this.observationDate = builder.getObservationDate();
            this.observationTime = Optional.ofNullable(builder.getObservationTime()).map(f -> f.build()).orElse(null);
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).map(f -> f.build()).orElse(null);
            this.determinationMethodology = Optional.ofNullable(builder.getDeterminationMethodology()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="observable", isRequired=true)
        @RuneAttribute(value="observable", isRequired=true)
        public Observable getObservable() {
            return this.observable;
        }

        @Override
        @RosettaAttribute(value="observationDate", isRequired=true)
        @RuneAttribute(value="observationDate", isRequired=true)
        public Date getObservationDate() {
            return this.observationDate;
        }

        @Override
        @RosettaAttribute(value="observationTime")
        @RuneAttribute(value="observationTime")
        public TimeZone getObservationTime() {
            return this.observationTime;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public InformationSource getInformationSource() {
            return this.informationSource;
        }

        @Override
        @RosettaAttribute(value="determinationMethodology")
        @RuneAttribute(value="determinationMethodology")
        public DeterminationMethodology getDeterminationMethodology() {
            return this.determinationMethodology;
        }

        @Override
        public ObservationIdentifier build() {
            return this;
        }

        @Override
        public ObservationIdentifierBuilder toBuilder() {
            ObservationIdentifierBuilder builder = ObservationIdentifier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationIdentifierBuilder builder) {
            Optional.ofNullable(this.getObservable()).ifPresent(builder::setObservable);
            Optional.ofNullable(this.getObservationDate()).ifPresent(builder::setObservationDate);
            Optional.ofNullable(this.getObservationTime()).ifPresent(builder::setObservationTime);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
            Optional.ofNullable(this.getDeterminationMethodology()).ifPresent(builder::setDeterminationMethodology);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!Objects.equals(this.observationDate, _that.getObservationDate())) {
                return false;
            }
            if (!Objects.equals(this.observationTime, _that.getObservationTime())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            return Objects.equals(this.determinationMethodology, _that.getDeterminationMethodology());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.observationDate != null ? this.observationDate.hashCode() : 0);
            _result = 31 * _result + (this.observationTime != null ? this.observationTime.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.determinationMethodology != null ? this.determinationMethodology.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationIdentifier {observable=" + this.observable + ", observationDate=" + this.observationDate + ", observationTime=" + this.observationTime + ", informationSource=" + this.informationSource + ", determinationMethodology=" + this.determinationMethodology + '}';
        }
    }
}

